/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.BreakException;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.openapi.util.Comparing;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SwitchStatementEvaluator
implements Evaluator {
    private final Evaluator myExpressionEvaluator;
    private final Evaluator[] myBodyEvaluators;
    private final String myLabelName;

    public SwitchStatementEvaluator(Evaluator expressionEvaluator, Evaluator[] bodyEvaluators, @Nullable String labelName) {
        this.myExpressionEvaluator = expressionEvaluator;
        this.myBodyEvaluators = bodyEvaluators;
        this.myLabelName = labelName;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        block4: {
            Object switchValue = UnBoxingEvaluator.unbox(this.myExpressionEvaluator.evaluate(context), context);
            try {
                boolean caseFound = false;
                for (Evaluator evaluator : this.myBodyEvaluators) {
                    SwitchCaseEvaluator caseEvaluator;
                    if (caseFound) {
                        evaluator.evaluate(context);
                        continue;
                    }
                    Evaluator e = DisableGC.unwrap(evaluator);
                    if (!(e instanceof SwitchCaseEvaluator) || !(caseEvaluator = (SwitchCaseEvaluator)e).myDefaultCase && !caseEvaluator.match(switchValue, context)) continue;
                    caseFound = true;
                }
            }
            catch (BreakException e) {
                if (Comparing.equal((String)e.getLabelName(), (String)this.myLabelName)) break block4;
                throw e;
            }
        }
        return null;
    }

    static class SwitchCaseEvaluator
    implements Evaluator {
        private final List<? extends Evaluator> myEvaluators;
        private final boolean myDefaultCase;

        SwitchCaseEvaluator(List<? extends Evaluator> evaluators, boolean defaultCase) {
            this.myEvaluators = evaluators;
            this.myDefaultCase = defaultCase;
        }

        boolean match(Object value2, EvaluationContextImpl context) throws EvaluateException {
            for (Evaluator evaluator : this.myEvaluators) {
                if (!value2.equals(UnBoxingEvaluator.unbox(evaluator.evaluate(context), context))) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
            return null;
        }
    }
}

