/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.CodeFragmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.Nullable;

public class SyntheticVariableEvaluator
implements Evaluator {
    private static final Logger LOG = Logger.getInstance(SyntheticVariableEvaluator.class);
    private final CodeFragmentEvaluator myCodeFragmentEvaluator;
    private final String myLocalName;
    private final JVMName myTypeName;
    private String myTypeNameString = null;

    public SyntheticVariableEvaluator(CodeFragmentEvaluator codeFragmentEvaluator, String localName, @Nullable JVMName typeName) {
        this.myCodeFragmentEvaluator = codeFragmentEvaluator;
        this.myLocalName = localName;
        this.myTypeName = typeName;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        if (this.myTypeNameString == null && this.myTypeName != null) {
            this.myTypeNameString = this.myTypeName.getName(context.getDebugProcess());
        }
        return this.myCodeFragmentEvaluator.getValue(this.myLocalName, context.getDebugProcess().getVirtualMachineProxy());
    }

    @Override
    public Modifier getModifier() {
        return new Modifier(){

            public boolean canInspect() {
                return false;
            }

            public boolean canSetValue() {
                return false;
            }

            public void setValue(Value value2) throws EvaluateException {
                if (value2 != null) {
                    Type type2 = value2.type();
                    if (SyntheticVariableEvaluator.this.myTypeNameString != null && !DebuggerUtilsEx.isAssignableFrom(SyntheticVariableEvaluator.this.myTypeNameString, type2)) {
                        throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.cannot.cast.object", (Object[])new Object[]{type2.name(), SyntheticVariableEvaluator.this.myTypeNameString}));
                    }
                }
                SyntheticVariableEvaluator.this.myCodeFragmentEvaluator.setValue(SyntheticVariableEvaluator.this.myLocalName, value2);
            }

            public Type getExpectedType() {
                LOG.assertTrue(false);
                return null;
            }

            public NodeDescriptorImpl getInspectItem(Project project) {
                return null;
            }
        };
    }
}

