/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.reference.SoftReference;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ReferenceType;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

public class TypeEvaluator
implements Evaluator {
    private final JVMName myTypeName;
    private WeakReference<ReferenceType> myLastResult;
    private WeakReference<ClassLoaderReference> myLastClassLoader;

    public TypeEvaluator(@NotNull JVMName typeName) {
        if (typeName == null) {
            TypeEvaluator.$$$reportNull$$$0(0);
        }
        this.myTypeName = typeName;
    }

    @Override
    @NotNull
    public ReferenceType evaluate(EvaluationContextImpl context) throws EvaluateException {
        String typeName;
        ClassLoaderReference classLoader = context.getClassLoader();
        ReferenceType lastRes = (ReferenceType)SoftReference.dereference(this.myLastResult);
        if (lastRes != null && classLoader == SoftReference.dereference(this.myLastClassLoader) && (classLoader != null || lastRes.virtualMachine().equals(context.getDebugProcess().getVirtualMachineProxy().getVirtualMachine()))) {
            ReferenceType referenceType = lastRes;
            if (referenceType == null) {
                TypeEvaluator.$$$reportNull$$$0(1);
            }
            return referenceType;
        }
        DebugProcessImpl debugProcess = context.getDebugProcess();
        ReferenceType type2 = debugProcess.findClass(context, typeName = this.myTypeName.getName(debugProcess), classLoader);
        if (type2 == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"error.class.not.loaded", (Object[])new Object[]{typeName}));
        }
        this.myLastClassLoader = new WeakReference<ClassLoaderReference>(classLoader);
        this.myLastResult = new WeakReference<ReferenceType>(type2);
        ReferenceType referenceType = type2;
        if (referenceType == null) {
            TypeEvaluator.$$$reportNull$$$0(2);
        }
        return referenceType;
    }

    public String toString() {
        return "Type " + this.myTypeName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/evaluation/expression/TypeEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/evaluation/expression/TypeEvaluator";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

