/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.attach;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.attach.JavaAttachDebuggerProvider;
import com.intellij.debugger.impl.attach.PidRemoteConnection;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.openapi.project.Project;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class JavaDebuggerAttachUtil {
    public static boolean canAttach(BaseProcessHandler processHandler) {
        return JavaAttachDebuggerProvider.getProcessAttachInfo(processHandler) != null;
    }

    public static boolean attach(BaseProcessHandler processHandler, Project project) {
        JavaAttachDebuggerProvider.LocalAttachInfo info = JavaAttachDebuggerProvider.getProcessAttachInfo(processHandler);
        if (info != null) {
            JavaAttachDebuggerProvider.attach(info, project);
            return true;
        }
        return false;
    }

    @NotNull
    public static Set<String> getAttachedPids(@NotNull Project project) {
        if (project == null) {
            JavaDebuggerAttachUtil.$$$reportNull$$$0(0);
        }
        Set set = StreamEx.of(DebuggerManagerEx.getInstanceEx(project).getSessions()).map(s -> s.getDebugEnvironment().getRemoteConnection()).select(PidRemoteConnection.class).map(PidRemoteConnection::getPid).toSet();
        if (set == null) {
            JavaDebuggerAttachUtil.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public static VirtualMachine attachVirtualMachine(String id) throws IOException, AttachNotSupportedException {
        if (VirtualMachine.list().stream().map(VirtualMachineDescriptor::id).noneMatch(id::equals)) {
            throw new AttachNotSupportedException("AttachProvider for the vm is not found");
        }
        VirtualMachine virtualMachine = VirtualMachine.attach(id);
        if (virtualMachine == null) {
            JavaDebuggerAttachUtil.$$$reportNull$$$0(2);
        }
        return virtualMachine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/attach/JavaDebuggerAttachUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/attach/JavaDebuggerAttachUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachedPids";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "attachVirtualMachine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAttachedPids";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

