/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.LocalVariableProxy;
import com.intellij.debugger.jdi.JdiProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.util.Comparing;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Type;

public class LocalVariableProxyImpl
extends JdiProxy
implements LocalVariableProxy {
    private final StackFrameProxyImpl myFrame;
    private final String myVariableName;
    private final String myTypeName;
    private LocalVariable myVariable;
    private Type myVariableType;

    public LocalVariableProxyImpl(StackFrameProxyImpl frame, LocalVariable variable) {
        super(frame.myTimer);
        this.myFrame = frame;
        this.myVariableName = variable.name();
        this.myTypeName = variable.typeName();
        this.myVariable = variable;
    }

    @Override
    protected void clearCaches() {
        this.myVariable = null;
        this.myVariableType = null;
    }

    public LocalVariable getVariable() throws EvaluateException {
        this.checkValid();
        if (this.myVariable == null) {
            this.myVariable = this.myFrame.visibleVariableByNameInt(this.myVariableName);
            if (this.myVariable == null) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)new IncompatibleThreadStateException());
            }
        }
        return this.myVariable;
    }

    public Type getType() throws EvaluateException, ClassNotLoadedException {
        if (this.myVariableType == null) {
            this.myVariableType = this.getVariable().type();
        }
        return this.myVariableType;
    }

    public StackFrameProxyImpl getFrame() {
        return this.myFrame;
    }

    public int hashCode() {
        return 31 * this.myFrame.hashCode() + this.myVariableName.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof LocalVariableProxyImpl) {
            LocalVariableProxyImpl proxy = (LocalVariableProxyImpl)o;
            return Comparing.equal((Object)proxy.myFrame, (Object)this.myFrame) && this.myVariableName.equals(proxy.myVariableName);
        }
        return false;
    }

    public String name() {
        return this.myVariableName;
    }

    public String typeName() {
        return this.myTypeName;
    }

    public String toString() {
        return this.myVariableName;
    }
}

