/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.ReferringObject;
import com.intellij.debugger.engine.SimpleReferringObject;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ObjectReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ReferringObjectsInfo {
    private static final Logger LOG = Logger.getInstance(ReferringObjectsInfo.class);
    private final Map<ObjectReference, Integer> myReversedMap;
    private final List<? extends ObjectReference> myDirectMap;
    private final List<? extends List<Integer>> myReferrers;

    public ReferringObjectsInfo(@NotNull List<? extends ObjectReference> values, @NotNull List<? extends List<Integer>> referrers) {
        if (values == null) {
            ReferringObjectsInfo.$$$reportNull$$$0(0);
        }
        if (referrers == null) {
            ReferringObjectsInfo.$$$reportNull$$$0(1);
        }
        this.myReversedMap = new HashMap<ObjectReference, Integer>();
        this.myDirectMap = values;
        for (int i = 0; i < values.size(); ++i) {
            this.myReversedMap.put(values.get(i), i);
        }
        this.myReferrers = referrers;
    }

    public boolean hasReferringObjectsFor(@NotNull ObjectReference reference) {
        if (reference == null) {
            ReferringObjectsInfo.$$$reportNull$$$0(2);
        }
        return this.myReversedMap.containsKey(reference);
    }

    @NotNull
    public List<ObjectReference> getAllReferrers(@NotNull ObjectReference value2) {
        if (value2 == null) {
            ReferringObjectsInfo.$$$reportNull$$$0(3);
        }
        List<ObjectReference> list = this.myReferrers.get(this.myReversedMap.get(value2)).stream().distinct().map(ix -> this.myDirectMap.get((int)ix)).collect(Collectors.toList());
        if (list == null) {
            ReferringObjectsInfo.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<ReferringObject> getReferringObjects(@NotNull ObjectReference value2, long limit) {
        Integer index;
        if (value2 == null) {
            ReferringObjectsInfo.$$$reportNull$$$0(5);
        }
        if ((index = this.myReversedMap.get(value2)) == null) {
            LOG.error("Could not find referring object for reference " + value2.toString());
            List<ReferringObject> list = Collections.emptyList();
            if (list == null) {
                ReferringObjectsInfo.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<ReferringObject> list = this.myReferrers.get(index).stream().distinct().limit(limit).map(ix -> this.myDirectMap.get((int)ix)).map(SimpleReferringObject::new).collect(Collectors.toList());
        if (list == null) {
            ReferringObjectsInfo.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referrers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/agent/ReferringObjectsInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/agent/ReferringObjectsInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllReferrers";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferringObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasReferringObjectsFor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllReferrers";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReferringObjects";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

