/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DesignerEditorState
implements FileEditorState {
    private static final String DESIGNER_ZOOM = "ui-designer-zoom";
    private final long myModificationStamp;
    private final double myZoom;

    public DesignerEditorState(VirtualFile file, double zoom) {
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        this.myModificationStamp = document != null ? document.getModificationStamp() : file.getModificationStamp();
        this.myZoom = zoom;
    }

    public double getZoom() {
        return this.myZoom;
    }

    public int hashCode() {
        int A = (int)(this.myModificationStamp ^ this.myModificationStamp >>> 32);
        long B = Double.doubleToLongBits(this.myZoom);
        return 31 * A + (int)(B ^ B >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DesignerEditorState) {
            DesignerEditorState state = (DesignerEditorState)object;
            return this.myModificationStamp == state.myModificationStamp && this.myZoom == state.myZoom;
        }
        return false;
    }

    public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
        return otherState instanceof DesignerEditorState;
    }

    @NotNull
    public static FileEditorState readState(@Nullable Element sourceElement, @NotNull VirtualFile file, double defaultZoom) {
        if (file == null) {
            DesignerEditorState.$$$reportNull$$$0(0);
        }
        double zoom = defaultZoom;
        if (sourceElement != null) {
            try {
                zoom = Double.parseDouble(sourceElement.getAttributeValue(DESIGNER_ZOOM));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new DesignerEditorState(file, zoom);
    }

    public static void writeState(@NotNull FileEditorState state, @NotNull Element targetElement) {
        if (state == null) {
            DesignerEditorState.$$$reportNull$$$0(1);
        }
        if (targetElement == null) {
            DesignerEditorState.$$$reportNull$$$0(2);
        }
        targetElement.setAttribute(DESIGNER_ZOOM, Double.toString(((DesignerEditorState)state).getZoom()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/designer/DesignerEditorState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readState";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "writeState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

