/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.palette;

import com.intellij.designer.AbstractToolWindowManager;
import com.intellij.designer.DesignerCustomizations;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindow;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.palette.PalettePanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaletteToolWindowManager
extends AbstractToolWindowManager {
    private PalettePanel myToolWindowPanel;

    public PaletteToolWindowManager(Project project) {
        super(project);
    }

    public static PalettePanel getInstance(DesignerEditorPanel designer) {
        PaletteToolWindowManager manager = PaletteToolWindowManager.getInstance(designer.getProject());
        if (manager.isEditorMode()) {
            return (PalettePanel)manager.getContent(designer);
        }
        return manager.myToolWindowPanel;
    }

    public static PaletteToolWindowManager getInstance(Project project) {
        return (PaletteToolWindowManager)((Object)project.getComponent(PaletteToolWindowManager.class));
    }

    protected void initToolWindow() {
        if (this.myToolWindowPanel == null) {
            this.myToolWindowPanel = new PalettePanel();
            Disposer.register((Disposable)this, () -> this.myToolWindowPanel.dispose());
        }
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow("Palette\t", false, this.getAnchor(), (Disposable)this.myProject, true);
        this.myToolWindow.setIcon(AllIcons.Toolwindows.ToolWindowPalette);
        this.initGearActions();
        ContentManager contentManager = this.myToolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent((JComponent)this.myToolWindowPanel, null, false);
        content.setCloseable(false);
        content.setPreferredFocusableComponent((JComponent)this.myToolWindowPanel);
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
        this.myToolWindow.setAvailable(false);
    }

    protected ToolWindowAnchor getAnchor() {
        DesignerCustomizations customization = PaletteToolWindowManager.getCustomizations();
        return customization != null ? customization.getPaletteAnchor() : ToolWindowAnchor.RIGHT;
    }

    protected void updateToolWindow(@Nullable DesignerEditorPanelFacade designer) {
        this.myToolWindowPanel.loadPalette((DesignerEditorPanel)designer);
        if (designer == null) {
            this.myToolWindow.setAvailable(false);
        } else {
            this.myToolWindow.setAvailable(true);
            this.myToolWindow.show(null);
        }
    }

    @NotNull
    public String getComponentName() {
        return "PaletteToolWindowManager";
    }

    protected LightToolWindow createContent(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            PaletteToolWindowManager.$$$reportNull$$$0(0);
        }
        PalettePanel palettePanel = new PalettePanel();
        palettePanel.loadPalette((DesignerEditorPanel)designer);
        return this.createContent(designer, palettePanel, "Palette", AllIcons.Toolwindows.ToolWindowPalette, palettePanel, palettePanel, 180, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/intellij/designer/palette/PaletteToolWindowManager", "createContent"));
    }
}

