/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.JrePathEditor;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.StatusText;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.jetbrains.annotations.NotNull;

class JreComboboxEditor
extends BasicComboBoxEditor {
    public static final TextComponentAccessor<ComboBox<JrePathEditor.JreComboBoxItem>> TEXT_COMPONENT_ACCESSOR = new JreComboBoxTextComponentAccessor();
    private final SortedComboBoxModel<JrePathEditor.JreComboBoxItem> myComboBoxModel;

    JreComboboxEditor(SortedComboBoxModel<JrePathEditor.JreComboBoxItem> comboBoxModel) {
        this.myComboBoxModel = comboBoxModel;
    }

    @Override
    public void setItem(Object anObject) {
        this.editor.setText(anObject == null ? "" : ((JrePathEditor.JreComboBoxItem)anObject).getPresentableText());
    }

    @Override
    public Object getItem() {
        String text2 = this.editor.getText().trim();
        for (JrePathEditor.JreComboBoxItem item : this.myComboBoxModel.getItems()) {
            if (!item.getPresentableText().equals(text2)) continue;
            return item;
        }
        return new JrePathEditor.CustomJreItem(FileUtil.toSystemIndependentName((String)text2));
    }

    public StatusText getEmptyText() {
        return this.getEditorComponent().getEmptyText();
    }

    public JBTextField getEditorComponent() {
        return (JBTextField)super.getEditorComponent();
    }

    private static class JreComboBoxTextComponentAccessor
    implements TextComponentAccessor<ComboBox<JrePathEditor.JreComboBoxItem>> {
        private JreComboBoxTextComponentAccessor() {
        }

        public String getText(ComboBox<JrePathEditor.JreComboBoxItem> component) {
            Object item = component.getEditor().getItem();
            return item != null ? ((JrePathEditor.JreComboBoxItem)item).getPresentableText() : "";
        }

        public void setText(ComboBox<JrePathEditor.JreComboBoxItem> component, @NotNull String text2) {
            if (text2 == null) {
                JreComboBoxTextComponentAccessor.$$$reportNull$$$0(0);
            }
            component.getEditor().setItem(new JrePathEditor.CustomJreItem(FileUtil.toSystemIndependentName((String)text2)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/ui/JreComboboxEditor$JreComboBoxTextComponentAccessor", "setText"));
        }
    }
}

