/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalSystem;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.externalSystem.JavaProjectData;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.pom.java.LanguageLevel;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J6\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/externalSystem/JavaProjectDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/externalSystem/JavaProjectData;", "Lcom/intellij/openapi/project/Project;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "importData", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "importLanguageLevel", "javaProjectData", "importProjectSdk", "importTargetBytecodeVersion", "intellij.java.impl"})
public final class JavaProjectDataService
extends AbstractProjectDataService<JavaProjectData, Project> {
    @NotNull
    public Key<JavaProjectData> getTargetDataKey() {
        Key<JavaProjectData> key2 = JavaProjectData.KEY;
        Intrinsics.checkExpressionValueIsNotNull(key2, (String)"JavaProjectData.KEY");
        return key2;
    }

    public void importData(@NotNull Collection<? extends DataNode<JavaProjectData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkParameterIsNotNull(toImport, (String)"toImport");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        if (toImport.isEmpty() || projectData == null) {
            return;
        }
        boolean bl = toImport.size() == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Expected to get a single project but got %d: %s";
            Object[] objectArray = new Object[]{toImport.size(), toImport};
            boolean bl5 = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        if (!ExternalSystemApiUtil.isOneToOneMapping((Project)project, (ProjectData)projectData, (Module[])modelsProvider.getModules())) {
            return;
        }
        Object object = ((DataNode)CollectionsKt.first((Iterable)toImport)).getData();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"toImport.first().data");
        JavaProjectData javaProjectData = (JavaProjectData)((Object)object);
        ExternalSystemApiUtil.executeProjectChangeAction((DisposeAwareProjectChange)new DisposeAwareProjectChange(this, project, javaProjectData, (ComponentManager)project){
            final /* synthetic */ JavaProjectDataService this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ JavaProjectData $javaProjectData;

            public void execute() {
                JavaProjectDataService.access$importProjectSdk(this.this$0, this.$project, this.$javaProjectData);
                JavaProjectDataService.access$importLanguageLevel(this.this$0, this.$project, this.$javaProjectData);
                JavaProjectDataService.access$importTargetBytecodeVersion(this.this$0, this.$project, this.$javaProjectData);
            }
            {
                this.this$0 = $outer;
                this.$project = $captured_local_variable$1;
                this.$javaProjectData = $captured_local_variable$2;
                super($super_call_param$3);
            }
        });
    }

    private final void importProjectSdk(Project project, JavaProjectData javaProjectData) {
        ProjectRootManager projectRootManager;
        if (!javaProjectData.isSetJdkVersion()) {
            return;
        }
        JavaSdkVersion javaSdkVersion = javaProjectData.getJdkVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)javaSdkVersion, (String)"javaProjectData.jdkVersion");
        JavaSdkVersion jdkVersion = javaSdkVersion;
        Sdk sdk = JavaSdkVersionUtil.findJdkByVersion((JavaSdkVersion)jdkVersion);
        ProjectRootManager projectRootManager2 = projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager2, (String)"projectRootManager");
        Sdk projectSdk = projectRootManager2.getProjectSdk();
        if (projectSdk == null) {
            projectRootManager.setProjectSdk(sdk);
        }
    }

    private final void importLanguageLevel(Project project, JavaProjectData javaProjectData) {
        LanguageLevelProjectExtension languageLevelProjectExtension;
        JavaSdkVersion projectSdkVersion;
        ProjectRootManager projectRootManager;
        ProjectRootManager projectRootManager2 = projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager2, (String)"projectRootManager");
        Sdk projectSdk = projectRootManager2.getProjectSdk();
        JavaSdkVersion javaSdkVersion = projectSdkVersion = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)projectSdk);
        LanguageLevel projectSdkLanguageLevel = javaSdkVersion != null ? javaSdkVersion.getMaxLanguageLevel() : null;
        LanguageLevel languageLevel = javaProjectData.getLanguageLevel();
        Intrinsics.checkExpressionValueIsNotNull((Object)languageLevel, (String)"javaProjectData.languageLevel");
        LanguageLevel languageLevel2 = languageLevel;
        LanguageLevelProjectExtension languageLevelProjectExtension2 = languageLevelProjectExtension = LanguageLevelProjectExtension.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)languageLevelProjectExtension2, (String)"languageLevelProjectExtension");
        languageLevelProjectExtension2.setLanguageLevel(languageLevel2);
        languageLevelProjectExtension.setDefault(Boolean.valueOf(languageLevel2 == projectSdkLanguageLevel));
    }

    private final void importTargetBytecodeVersion(Project project, JavaProjectData javaProjectData) {
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)project);
        String targetBytecodeVersion = javaProjectData.getTargetBytecodeVersion();
        CompilerConfiguration compilerConfiguration2 = compilerConfiguration;
        Intrinsics.checkExpressionValueIsNotNull((Object)compilerConfiguration2, (String)"compilerConfiguration");
        compilerConfiguration2.setProjectBytecodeTarget(targetBytecodeVersion);
    }

    public static final /* synthetic */ void access$importProjectSdk(JavaProjectDataService $this, Project project, JavaProjectData javaProjectData) {
        $this.importProjectSdk(project, javaProjectData);
    }

    public static final /* synthetic */ void access$importLanguageLevel(JavaProjectDataService $this, Project project, JavaProjectData javaProjectData) {
        $this.importLanguageLevel(project, javaProjectData);
    }

    public static final /* synthetic */ void access$importTargetBytecodeVersion(JavaProjectDataService $this, Project project, JavaProjectData javaProjectData) {
        $this.importTargetBytecodeVersion(project, javaProjectData);
    }
}

