/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesDialog;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.StateRestoringCheckBox;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FindClassUsagesDialog
extends JavaFindUsagesDialog<JavaClassFindUsagesOptions> {
    private StateRestoringCheckBox myCbUsages;
    private StateRestoringCheckBox myCbMethodsUsages;
    private StateRestoringCheckBox myCbFieldsUsages;
    private StateRestoringCheckBox myCbImplementingClasses;
    private StateRestoringCheckBox myCbDerivedInterfaces;
    private StateRestoringCheckBox myCbDerivedClasses;

    public FindClassUsagesDialog(PsiElement element, Project project, FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler) {
        super(element, project, findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler);
    }

    public JComponent getPreferredFocusedControl() {
        return this.myCbUsages;
    }

    @Override
    public void calcFindUsagesOptions(JavaClassFindUsagesOptions options) {
        super.calcFindUsagesOptions(options);
        if (FindClassUsagesDialog.isToChange((JCheckBox)this.myCbUsages)) {
            options.isUsages = FindClassUsagesDialog.isSelected((JCheckBox)this.myCbUsages);
        }
        if (FindClassUsagesDialog.isToChange((JCheckBox)this.myCbMethodsUsages)) {
            options.isMethodsUsages = FindClassUsagesDialog.isSelected((JCheckBox)this.myCbMethodsUsages);
        }
        if (FindClassUsagesDialog.isToChange((JCheckBox)this.myCbFieldsUsages)) {
            options.isFieldsUsages = FindClassUsagesDialog.isSelected((JCheckBox)this.myCbFieldsUsages);
        }
        if (FindClassUsagesDialog.isToChange((JCheckBox)this.myCbDerivedClasses)) {
            options.isDerivedClasses = FindClassUsagesDialog.isSelected((JCheckBox)this.myCbDerivedClasses);
        }
        if (FindClassUsagesDialog.isToChange((JCheckBox)this.myCbImplementingClasses)) {
            options.isImplementingClasses = FindClassUsagesDialog.isSelected((JCheckBox)this.myCbImplementingClasses);
        }
        if (FindClassUsagesDialog.isToChange((JCheckBox)this.myCbDerivedInterfaces)) {
            options.isDerivedInterfaces = FindClassUsagesDialog.isSelected((JCheckBox)this.myCbDerivedInterfaces);
        }
        options.isSkipImportStatements = false;
        options.isCheckDeepInheritance = true;
        options.isIncludeInherited = false;
        FUCounterUsageLogger.getInstance().logEvent("java.find.usages", "find.class.started", this.createFeatureUsageData(options));
    }

    @Override
    protected FeatureUsageData createFeatureUsageData(JavaClassFindUsagesOptions options) {
        FeatureUsageData data = super.createFeatureUsageData(options);
        data.addData("methodUsages", options.isMethodsUsages);
        data.addData("fieldUsages", options.isFieldsUsages);
        data.addData("derivedUsages", options.isDerivedClasses);
        data.addData("implementingClasses", options.isImplementingClasses);
        data.addData("derivedInterfaces", options.isDerivedInterfaces);
        return data;
    }

    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = new JPanel();
        findWhatPanel.setBorder(IdeBorderFactory.createTitledBorder((String)JavaBundle.message((String)"find.what.group", (Object[])new Object[0])));
        findWhatPanel.setLayout(new BoxLayout(findWhatPanel, 1));
        this.myCbUsages = this.addCheckboxToPanel(JavaBundle.message((String)"find.what.usages.checkbox", (Object[])new Object[0]), ((JavaClassFindUsagesOptions)((Object)this.getFindUsagesOptions())).isUsages, findWhatPanel, true);
        PsiClass psiClass = (PsiClass)this.getPsiElement();
        this.myCbMethodsUsages = this.addCheckboxToPanel(JavaBundle.message((String)"find.what.methods.usages.checkbox", (Object[])new Object[0]), ((JavaClassFindUsagesOptions)((Object)this.getFindUsagesOptions())).isMethodsUsages, findWhatPanel, true);
        if (!psiClass.isAnnotationType()) {
            this.myCbFieldsUsages = this.addCheckboxToPanel(JavaBundle.message((String)"find.what.fields.usages.checkbox", (Object[])new Object[0]), ((JavaClassFindUsagesOptions)((Object)this.getFindUsagesOptions())).isFieldsUsages, findWhatPanel, true);
            if (psiClass.isInterface()) {
                this.myCbImplementingClasses = this.addCheckboxToPanel(JavaBundle.message((String)"find.what.implementing.classes.checkbox", (Object[])new Object[0]), ((JavaClassFindUsagesOptions)((Object)this.getFindUsagesOptions())).isImplementingClasses, findWhatPanel, true);
                this.myCbDerivedInterfaces = this.addCheckboxToPanel(JavaBundle.message((String)"find.what.derived.interfaces.checkbox", (Object[])new Object[0]), ((JavaClassFindUsagesOptions)((Object)this.getFindUsagesOptions())).isDerivedInterfaces, findWhatPanel, true);
            } else if (!psiClass.hasModifierProperty("final")) {
                this.myCbDerivedClasses = this.addCheckboxToPanel(JavaBundle.message((String)"find.what.derived.classes.checkbox", (Object[])new Object[0]), ((JavaClassFindUsagesOptions)((Object)this.getFindUsagesOptions())).isDerivedClasses, findWhatPanel, true);
            }
        }
        return findWhatPanel;
    }

    protected void update() {
        if (this.myCbToSearchForTextOccurrences != null) {
            if (FindClassUsagesDialog.isSelected((JCheckBox)this.myCbUsages)) {
                this.myCbToSearchForTextOccurrences.makeSelectable();
            } else {
                this.myCbToSearchForTextOccurrences.makeUnselectable(false);
            }
        }
        boolean hasSelected = FindClassUsagesDialog.isSelected((JCheckBox)this.myCbUsages) || FindClassUsagesDialog.isSelected((JCheckBox)this.myCbFieldsUsages) || FindClassUsagesDialog.isSelected((JCheckBox)this.myCbMethodsUsages) || FindClassUsagesDialog.isSelected((JCheckBox)this.myCbImplementingClasses) || FindClassUsagesDialog.isSelected((JCheckBox)this.myCbDerivedInterfaces) || FindClassUsagesDialog.isSelected((JCheckBox)this.myCbDerivedClasses);
        this.setOKActionEnabled(hasSelected);
    }
}

