/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class OutputPathMacro
extends Macro {
    @NotNull
    public String getName() {
        return "OutputPath";
    }

    @NotNull
    public String getDescription() {
        String string = JavaCompilerBundle.message((String)"macro.output.path", (Object[])new Object[0]);
        if (string == null) {
            OutputPathMacro.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String expand(@NotNull DataContext dataContext) {
        ProjectFileIndex projectFileIndex;
        Module module;
        Project project;
        if (dataContext == null) {
            OutputPathMacro.$$$reportNull$$$0(1);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return null;
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file != null && (module = (projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex()).getModuleForFile(file)) != null) {
            String outputPathUrl;
            boolean isTest = projectFileIndex.isInTestSourceContent(file);
            String string = outputPathUrl = isTest ? CompilerModuleExtension.getInstance((Module)module).getCompilerOutputUrlForTests() : CompilerModuleExtension.getInstance((Module)module).getCompilerOutputUrl();
            if (outputPathUrl == null) {
                return null;
            }
            return VirtualFileManager.extractPath((String)outputPathUrl).replace('/', File.separatorChar);
        }
        Module[] allModules = ModuleManager.getInstance((Project)project).getSortedModules();
        if (allModules.length == 0) {
            return null;
        }
        String[] paths = CompilerPaths.getOutputPaths((Module[])allModules);
        StringBuilder outputPath = new StringBuilder();
        for (int idx = 0; idx < paths.length; ++idx) {
            String path = paths[idx];
            if (idx > 0) {
                outputPath.append(File.pathSeparator);
            }
            outputPath.append(path);
        }
        return outputPath.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/macro/OutputPathMacro";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/macro/OutputPathMacro";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

