/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard.impl;

import com.intellij.facet.impl.ui.libraries.FrameworkLibraryProvider;
import com.intellij.framework.FrameworkVersion;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.framework.addSupport.FrameworkVersionListener;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModelListener;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportNode;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportNodeBase;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportOptionsComponent;
import com.intellij.ide.util.newProjectWizard.OldFrameworkSupportProviderWrapper;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkSupportModelBase
extends UserDataHolderBase
implements FrameworkSupportModel {
    private final Project myProject;
    private final ModuleBuilder myModuleBuilder;
    private final LibrariesContainer myLibrariesContainer;
    private final EventDispatcher<FrameworkSupportModelListener> myDispatcher;
    private final EventDispatcher<FrameworkVersionListener> myVersionEventDispatcher;
    private final Map<String, FrameworkSupportNode> mySettingsMap;
    private final Map<String, FrameworkSupportOptionsComponent> myOptionsComponentsMap;
    private final Map<String, FrameworkVersion> mySelectedVersions;
    private final Map<String, String> myFrameworkVersions;
    private FrameworkLibraryProvider myLibraryProvider;

    public FrameworkSupportModelBase(@Nullable Project project, @Nullable ModuleBuilder builder, @NotNull LibrariesContainer librariesContainer) {
        if (librariesContainer == null) {
            FrameworkSupportModelBase.$$$reportNull$$$0(0);
        }
        this.myDispatcher = EventDispatcher.create(FrameworkSupportModelListener.class);
        this.myVersionEventDispatcher = EventDispatcher.create(FrameworkVersionListener.class);
        this.mySettingsMap = new HashMap<String, FrameworkSupportNode>();
        this.myOptionsComponentsMap = new HashMap<String, FrameworkSupportOptionsComponent>();
        this.mySelectedVersions = new HashMap<String, FrameworkVersion>();
        this.myFrameworkVersions = new HashMap<String, String>();
        this.myProject = project;
        this.myModuleBuilder = builder;
        this.myLibrariesContainer = librariesContainer;
    }

    @NotNull
    public abstract String getBaseDirectoryForLibrariesPath();

    public void registerComponent(@NotNull FrameworkSupportInModuleProvider provider, @NotNull FrameworkSupportNode node) {
        if (provider == null) {
            FrameworkSupportModelBase.$$$reportNull$$$0(1);
        }
        if (node == null) {
            FrameworkSupportModelBase.$$$reportNull$$$0(2);
        }
        this.mySettingsMap.put(provider.getFrameworkType().getId(), node);
    }

    public void registerOptionsComponent(FrameworkSupportInModuleProvider provider, FrameworkSupportOptionsComponent component) {
        this.myOptionsComponentsMap.put(provider.getFrameworkType().getId(), component);
    }

    public Project getProject() {
        return this.myProject;
    }

    public ModuleBuilder getModuleBuilder() {
        return this.myModuleBuilder;
    }

    public boolean isFrameworkSelected(@NotNull @NonNls String providerId) {
        FrameworkSupportNode node;
        if (providerId == null) {
            FrameworkSupportModelBase.$$$reportNull$$$0(3);
        }
        return (node = this.mySettingsMap.get(providerId)) != null && node.isChecked();
    }

    public void addFrameworkListener(@NotNull FrameworkSupportModelListener listener) {
        if (listener == null) {
            FrameworkSupportModelBase.$$$reportNull$$$0(4);
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void addFrameworkListener(@NotNull FrameworkSupportModelListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            FrameworkSupportModelBase.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            FrameworkSupportModelBase.$$$reportNull$$$0(6);
        }
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public void addFrameworkVersionListener(@NotNull FrameworkVersionListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            FrameworkSupportModelBase.$$$reportNull$$$0(7);
        }
        if (parentDisposable == null) {
            FrameworkSupportModelBase.$$$reportNull$$$0(8);
        }
        this.myVersionEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public void removeFrameworkListener(@NotNull FrameworkSupportModelListener listener) {
        if (listener == null) {
            FrameworkSupportModelBase.$$$reportNull$$$0(9);
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public void setFrameworkComponentEnabled(@NotNull @NonNls String providerId, boolean enable) {
        FrameworkSupportNode node;
        if (providerId == null) {
            FrameworkSupportModelBase.$$$reportNull$$$0(10);
        }
        if ((node = this.mySettingsMap.get(providerId)) != null && enable != node.isChecked()) {
            node.setChecked(enable);
            node.getConfigurable();
            if (this.myFrameworkVersions.get(providerId) == null) {
                for (FrameworkVersion version : ((FrameworkSupportInModuleProvider)node.getUserObject()).getFrameworkType().getVersions()) {
                    if (!version.getAvailabilityCondition().isAvailableFor((FrameworkSupportModel)this)) continue;
                    this.setSelectedVersion(providerId, version);
                }
            }
        }
    }

    public void updateFrameworkLibraryComponent(@NotNull String providerId) {
        FrameworkSupportOptionsComponent component;
        if (providerId == null) {
            FrameworkSupportModelBase.$$$reportNull$$$0(11);
        }
        if ((component = this.myOptionsComponentsMap.get(providerId)) != null) {
            component.updateLibrariesPanel();
        }
    }

    public FrameworkSupportConfigurable getFrameworkConfigurable(@NotNull @NonNls String providerId) {
        FrameworkSupportConfigurable configurable;
        if (providerId == null) {
            FrameworkSupportModelBase.$$$reportNull$$$0(12);
        }
        if ((configurable = this.findFrameworkConfigurable(providerId)) == null) {
            throw new IllegalArgumentException("provider '" + providerId + "' not found");
        }
        return configurable;
    }

    @Nullable
    public FrameworkSupportConfigurable findFrameworkConfigurable(@NotNull @NonNls String providerId) {
        FrameworkSupportNode node;
        if (providerId == null) {
            FrameworkSupportModelBase.$$$reportNull$$$0(13);
        }
        if ((node = this.mySettingsMap.get(providerId)) == null) {
            return null;
        }
        return ((OldFrameworkSupportProviderWrapper.FrameworkSupportConfigurableWrapper)node.getConfigurable()).getConfigurable();
    }

    public void setSelectedVersion(@NotNull String frameworkOrGroupId, @NotNull FrameworkVersion version) {
        FrameworkVersion oldVersion;
        if (frameworkOrGroupId == null) {
            FrameworkSupportModelBase.$$$reportNull$$$0(14);
        }
        if (version == null) {
            FrameworkSupportModelBase.$$$reportNull$$$0(15);
        }
        if (!Comparing.equal((Object)(oldVersion = this.mySelectedVersions.put(frameworkOrGroupId, version)), (Object)version)) {
            for (Map.Entry<String, FrameworkSupportNode> entry : this.mySettingsMap.entrySet()) {
                FrameworkSupportOptionsComponent component;
                if (!FrameworkSupportModelBase.hasParentWithId(entry.getValue(), frameworkOrGroupId)) continue;
                if (!entry.getValue().getId().equals(frameworkOrGroupId) && (component = this.myOptionsComponentsMap.get(entry.getKey())) != null) {
                    component.updateVersionsComponent();
                }
                this.updateFrameworkLibraryComponent(entry.getKey());
            }
        }
        ((FrameworkVersionListener)this.myVersionEventDispatcher.getMulticaster()).versionChanged(version);
    }

    private static boolean hasParentWithId(FrameworkSupportNode node, @NotNull String frameworkOrGroupId) {
        if (frameworkOrGroupId == null) {
            FrameworkSupportModelBase.$$$reportNull$$$0(16);
        }
        for (FrameworkSupportNodeBase current = node; current != null; current = current.getParentNode()) {
            if (!current.getId().equals(frameworkOrGroupId)) continue;
            return true;
        }
        return false;
    }

    public FrameworkLibraryProvider getLibraryProvider() {
        return this.myLibraryProvider;
    }

    public void setLibraryProvider(@Nullable FrameworkLibraryProvider libraryProvider) {
        this.myLibraryProvider = libraryProvider;
        for (FrameworkSupportOptionsComponent optionsComponent : this.myOptionsComponentsMap.values()) {
            optionsComponent.updateLibrariesPanel();
        }
    }

    @Nullable
    public <V extends FrameworkVersion> V getSelectedVersion(@NotNull String frameworkOrGroupId) {
        if (frameworkOrGroupId == null) {
            FrameworkSupportModelBase.$$$reportNull$$$0(17);
        }
        return (V)this.mySelectedVersions.get(frameworkOrGroupId);
    }

    public void onFrameworkSelectionChanged(FrameworkSupportNode node) {
        FrameworkSupportInModuleProvider provider = (FrameworkSupportInModuleProvider)node.getUserObject();
        boolean checked = node.isChecked();
        if (provider instanceof OldFrameworkSupportProviderWrapper) {
            FrameworkSupportProvider oldProvider = ((OldFrameworkSupportProviderWrapper)provider).getProvider();
            this.selectFramework(oldProvider, checked);
        }
        for (FrameworkSupportInModuleProvider.FrameworkDependency dependency : provider.getDependenciesFrameworkIds()) {
            if (dependency.isOptional()) continue;
            String id = dependency.getFrameworkId();
            this.setFrameworkComponentEnabled(id, true);
        }
    }

    public void selectFramework(FrameworkSupportProvider provider, boolean checked) {
        FrameworkSupportModelListener multicaster = (FrameworkSupportModelListener)this.myDispatcher.getMulticaster();
        if (checked) {
            multicaster.frameworkSelected(provider);
        } else {
            multicaster.frameworkUnselected(provider);
        }
    }

    public void fireWizardStepUpdated() {
        ((FrameworkSupportModelListener)this.myDispatcher.getMulticaster()).wizardStepUpdated();
    }

    @NotNull
    public LibrariesContainer getLibrariesContainer() {
        LibrariesContainer librariesContainer = this.myLibrariesContainer;
        if (librariesContainer == null) {
            FrameworkSupportModelBase.$$$reportNull$$$0(18);
        }
        return librariesContainer;
    }

    public void setSelectedLibraryVersion(String id, String version) {
        this.myFrameworkVersions.put(id, version);
        ((FrameworkVersionListener)this.myVersionEventDispatcher.getMulticaster()).versionChanged((FrameworkVersion)this.getSelectedVersion(id));
    }

    public String getFrameworkVersion(String id) {
        FrameworkVersion version = this.mySelectedVersions.get(id);
        return version == null ? this.myFrameworkVersions.get(id) : version.getVersionNumber();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "librariesContainer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerId";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkOrGroupId";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/newProjectWizard/impl/FrameworkSupportModelBase";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrariesContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isFrameworkSelected";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addFrameworkListener";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addFrameworkVersionListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeFrameworkListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setFrameworkComponentEnabled";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateFrameworkLibraryComponent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkConfigurable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findFrameworkConfigurable";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedVersion";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasParentWithId";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedVersion";
                break;
            }
            case 18: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

