/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources;

import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModuleSourceRoot
extends DetectedSourceRoot {
    private final List<String> myLanguages;
    private final boolean myWithModuleInfoFile;

    public JavaModuleSourceRoot(File directory, @Nullable String packagePrefix, @NotNull String language) {
        if (language == null) {
            JavaModuleSourceRoot.$$$reportNull$$$0(0);
        }
        super(directory, packagePrefix);
        this.myLanguages = new ArrayList<String>();
        this.myLanguages.add(language);
        this.myWithModuleInfoFile = false;
    }

    public JavaModuleSourceRoot(File directory, @NotNull String language, boolean withModuleInfoFile) {
        if (language == null) {
            JavaModuleSourceRoot.$$$reportNull$$$0(1);
        }
        super(directory, "");
        this.myLanguages = new ArrayList<String>();
        this.myLanguages.add(language);
        this.myWithModuleInfoFile = withModuleInfoFile;
    }

    private JavaModuleSourceRoot(File directory, String packagePrefix, List<String> languages) {
        super(directory, packagePrefix);
        this.myLanguages = languages;
        this.myWithModuleInfoFile = false;
    }

    @Override
    @NotNull
    public String getRootTypeName() {
        String string = StringUtil.join(this.myLanguages, (String)", ");
        if (string == null) {
            JavaModuleSourceRoot.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public DetectedProjectRoot combineWith(@NotNull DetectedProjectRoot root) {
        if (root == null) {
            JavaModuleSourceRoot.$$$reportNull$$$0(3);
        }
        if (root instanceof JavaModuleSourceRoot) {
            return this.combineWith((JavaModuleSourceRoot)root);
        }
        return null;
    }

    @NotNull
    public JavaModuleSourceRoot combineWith(@NotNull JavaModuleSourceRoot root) {
        if (root == null) {
            JavaModuleSourceRoot.$$$reportNull$$$0(4);
        }
        ArrayList<String> union = new ArrayList<String>(this.myLanguages.size() + root.myLanguages.size());
        union.addAll(this.myLanguages);
        union.addAll(root.myLanguages);
        ContainerUtil.removeDuplicates(union);
        return new JavaModuleSourceRoot(this.getDirectory(), this.getPackagePrefix(), union);
    }

    public boolean isWithModuleInfoFile() {
        return this.myWithModuleInfoFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/projectWizard/importSources/JavaModuleSourceRoot";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/projectWizard/importSources/JavaModuleSourceRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "combineWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

