/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExpressionStatisticsAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ExpressionStatisticsAction.$$$reportNull$$$0(0);
        }
        final Project project = e.getProject();
        assert (project != null);
        final Data topLevelData = new Data();
        final Data subData = new Data();
        VirtualFile dir = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        assert (dir != null);
        final List<VirtualFile> javaFiles = ExpressionStatisticsAction.collectJavaFiles(dir, project);
        if (!ApplicationManagerEx.getApplicationEx().runProcessWithProgressSynchronouslyInReadAction(project, "Traversing PSI", true, "Cancel", null, new Runnable(){

            @Override
            public void run() {
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                indicator.setIndeterminate(false);
                for (int i = 0; i < javaFiles.size(); ++i) {
                    VirtualFile file = (VirtualFile)javaFiles.get(i);
                    indicator.setText2(file.getPath());
                    indicator.setFraction((double)i / (double)javaFiles.size());
                    PsiFile psiFile = psiManager.findFile(file);
                    if (!(psiFile instanceof PsiJavaFile)) continue;
                    psiFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitElement(@NotNull PsiElement element) {
                            if (element == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (element instanceof PsiIdentifier) {
                                int offset = element.getTextRange().getStartOffset();
                                PsiExpression minExpression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class);
                                if (minExpression != null && minExpression.getTextRange().getStartOffset() == offset) {
                                    PsiExpression nextExpression;
                                    PsiExpression maxExpression = minExpression;
                                    while ((nextExpression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)maxExpression, PsiExpression.class, (boolean)true)) != null && nextExpression.getTextRange().getStartOffset() == offset) {
                                        maxExpression = nextExpression;
                                    }
                                    ExpressionStatisticsAction.collectExpressionData(minExpression, maxExpression, topLevelData, subData);
                                }
                            }
                            super.visitElement(element);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/internal/ExpressionStatisticsAction$1$1", "visitElement"));
                        }
                    });
                }
            }
        })) {
            return;
        }
        Messages.showMessageDialog((String)("Top-level: " + topLevelData.toString() + "\n\nSub-expressions: " + subData.toString()), (String)"Expression Statistics", null);
    }

    @NotNull
    private static List<VirtualFile> collectJavaFiles(VirtualFile dir, Project project) {
        ArrayList<VirtualFile> javaFiles = new ArrayList<VirtualFile>();
        ProjectFileIndex.SERVICE.getInstance((Project)project).iterateContentUnderDirectory(dir, file -> {
            if (file.getName().endsWith(".java")) {
                javaFiles.add(file);
            }
            return true;
        });
        ArrayList<VirtualFile> arrayList = javaFiles;
        if (arrayList == null) {
            ExpressionStatisticsAction.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static void collectExpressionData(PsiExpression minExpression, PsiExpression maxExpression, Data topLevelData, Data subExpressionData) {
        Data data = minExpression == maxExpression || maxExpression instanceof PsiMethodCallExpression && minExpression == ((PsiMethodCallExpression)maxExpression).getMethodExpression() ? topLevelData : subExpressionData;
        if (minExpression instanceof PsiClassObjectAccessExpression || minExpression instanceof PsiThisExpression || minExpression instanceof PsiSuperExpression) {
            ++data.classes;
            return;
        }
        if (!(minExpression instanceof PsiJavaCodeReferenceElement)) {
            ++data.other;
            return;
        }
        ExpressionStatisticsAction.classifyTarget(data, ((PsiJavaCodeReferenceElement)minExpression).resolve());
    }

    private static void classifyTarget(Data data, PsiElement target) {
        if (target instanceof PsiLocalVariable) {
            ++data.localVars;
        } else if (target instanceof PsiParameter) {
            ++data.parameters;
        } else if (target instanceof PsiMethod) {
            ++data.methods;
        } else if (target instanceof PsiClass) {
            ++data.classes;
        } else if (target instanceof PsiPackage) {
            ++data.packages;
        } else if (target instanceof PsiField) {
            if (((PsiField)target).hasModifierProperty("static") && ((PsiField)target).hasModifierProperty("final")) {
                ++data.constants;
            } else {
                ++data.fields;
            }
        } else {
            ++data.other;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/ExpressionStatisticsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/ExpressionStatisticsAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectJavaFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Data {
        int localVars;
        int parameters;
        int methods;
        int classes;
        int fields;
        int constants;
        int packages;
        int other;

        private Data() {
        }

        public String toString() {
            return "localVars=" + this.localVars + "\nparameters=" + this.parameters + "\nmethods=" + this.methods + "\nconstants=" + this.constants + "\nfields=" + this.fields + "\nclasses=" + this.classes + "\npackages=" + this.packages + "\nother=" + this.other + "\ntotal=" + (this.localVars + this.parameters + this.methods + this.constants + this.fields + this.classes + this.packages + this.other);
        }
    }
}

