/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.services;

import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MavenRepositoryService {
    @NotNull
    public abstract String getDisplayName();

    @NotNull
    public abstract List<RemoteRepositoryDescription> getRepositories(@NotNull String var1) throws IOException;

    @NotNull
    public abstract List<RepositoryArtifactDescription> findArtifacts(@NotNull String var1, @NotNull RepositoryArtifactDescription var2) throws IOException;

    public final String toString() {
        return this.getDisplayName();
    }

    @NotNull
    protected String mapToParamString(@NotNull Map<String, String> params) {
        if (params == null) {
            MavenRepositoryService.$$$reportNull$$$0(0);
        }
        String string = StringUtil.join(params.entrySet(), entry -> {
            if (entry.getValue() == null) {
                return null;
            }
            try {
                return (String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException ignore) {
                return null;
            }
        }, (String)"&");
        if (string == null) {
            MavenRepositoryService.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected Url toUrl(@NotNull String base, @NotNull String path) throws MalformedURLException {
        if (base == null) {
            MavenRepositoryService.$$$reportNull$$$0(2);
        }
        if (path == null) {
            MavenRepositoryService.$$$reportNull$$$0(3);
        }
        return this.toUrl(base, path, null);
    }

    protected Url toUrl(@NotNull String base, @NotNull String path, @Nullable String parameters2) throws MalformedURLException {
        Url baseUrl;
        if (base == null) {
            MavenRepositoryService.$$$reportNull$$$0(4);
        }
        if (path == null) {
            MavenRepositoryService.$$$reportNull$$$0(5);
        }
        if ((baseUrl = Urls.parse((String)base, (boolean)false)) == null || baseUrl.getScheme() == null || baseUrl.getAuthority() == null) {
            throw new MalformedURLException("cannot parse " + base);
        }
        String newPath = baseUrl.getPath().endsWith("/") ? baseUrl.getPath() + path : baseUrl.getPath() + "/" + path;
        return Urls.newUrl((String)baseUrl.getScheme(), (String)baseUrl.getAuthority(), (String)newPath, parameters2 == null ? null : "?" + parameters2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/services/MavenRepositoryService";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/services/MavenRepositoryService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToParamString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mapToParamString";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

