/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.services.bintray;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.services.bintray.BintrayModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.DoubleConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BintrayEndpoint {
    public static final String BINTRAY_API_URL = "https://bintray.com/api/v1/";
    private final Gson gson = new Gson();

    @Nullable
    public RemoteRepositoryDescription getRepository(@NotNull String subject, @NotNull String repo) throws IOException {
        if (subject == null) {
            BintrayEndpoint.$$$reportNull$$$0(0);
        }
        if (repo == null) {
            BintrayEndpoint.$$$reportNull$$$0(1);
        }
        String url = BintrayModel.Repository.getUrl(subject, repo);
        return (RemoteRepositoryDescription)HttpRequests.request((String)url).accept("application/xml").connect(request -> {
            try {
                request.getConnection();
            }
            catch (HttpRequests.HttpStatusException e) {
                if (e.getStatusCode() == 404) {
                    return null;
                }
                throw e;
            }
            return BintrayEndpoint.toRepositoryDescription(new BintrayModel.Repository(subject, repo));
        });
    }

    @NotNull
    public List<RemoteRepositoryDescription> getRepositories(@NotNull String subject) throws IOException {
        if (subject == null) {
            BintrayEndpoint.$$$reportNull$$$0(2);
        }
        String url = BintrayModel.Repository.getUrl(subject, null);
        List list = (List)HttpRequests.request((String)url).accept("application/xml").connect(request -> {
            try {
                String response = request.readString(null);
                Pattern extractRepoNamePattern = Pattern.compile("<a\\shref=\"([^/]+)/\">\\1/</a>");
                ArrayList<RemoteRepositoryDescription> result = new ArrayList<RemoteRepositoryDescription>();
                Matcher matcher = extractRepoNamePattern.matcher(response);
                while (matcher.find()) {
                    result.add(BintrayEndpoint.toRepositoryDescription(new BintrayModel.Repository(subject, matcher.group(1))));
                }
                return result;
            }
            catch (HttpRequests.HttpStatusException e) {
                if (e.getStatusCode() == 401) {
                    return Collections.emptyList();
                }
                throw e;
            }
        });
        if (list == null) {
            BintrayEndpoint.$$$reportNull$$$0(3);
        }
        return list;
    }

    public List<RepositoryArtifactDescription> getArtifacts(@NotNull String subject, @Nullable String repo, @NotNull String className2) {
        if (subject == null) {
            BintrayEndpoint.$$$reportNull$$$0(4);
        }
        if (className2 == null) {
            BintrayEndpoint.$$$reportNull$$$0(5);
        }
        return Collections.emptyList();
    }

    public List<RepositoryArtifactDescription> getArtifacts(@NotNull String subject, @Nullable String repo, @Nullable String groupIdTemplate, @Nullable String artifactIdTemplate) throws IOException {
        if (subject == null) {
            BintrayEndpoint.$$$reportNull$$$0(6);
        }
        StringBuilder urlBuilder = new StringBuilder("https://bintray.com/api/v1/search/packages/maven?subject=").append(subject);
        if (StringUtil.isNotEmpty((String)repo)) {
            urlBuilder.append("&repo=").append(repo);
        }
        if (StringUtil.isEmpty((String)groupIdTemplate) && StringUtil.isEmpty((String)artifactIdTemplate)) {
            return Collections.emptyList();
        }
        urlBuilder.append("&q=*").append(StringUtil.join(Arrays.asList(groupIdTemplate, artifactIdTemplate), (String)":")).append("*");
        ArrayList<RepositoryArtifactDescription> artifacts = new ArrayList<RepositoryArtifactDescription>();
        this.executeRequest(urlBuilder.toString(), BintrayModel.Package[].class, packages -> {
            for (BintrayModel.Package p : packages) {
                for (String groupAndArtifactId : p.system_ids) {
                    List list = StringUtil.split((String)groupAndArtifactId, (String)":");
                    if (list.size() != 2) continue;
                    String groupId = (String)list.get(0);
                    String artifactId = (String)list.get(1);
                    for (String version : p.versions) {
                        RepositoryArtifactDescription artifact = new RepositoryArtifactDescription(groupId, artifactId, version, "jar", null, null, BintrayEndpoint.getRepositoryId(p.owner, p.repo));
                        artifacts.add(artifact);
                    }
                }
            }
        }, BintrayEndpoint::defaultExceptionHandler, null);
        return artifacts;
    }

    private static String getRepositoryId(String subject, String repo) {
        return "bintray/" + subject + "/" + repo;
    }

    private static RemoteRepositoryDescription toRepositoryDescription(BintrayModel.Repository r) {
        return new RemoteRepositoryDescription(BintrayEndpoint.getRepositoryId(r.subject, r.repo), r.repo, r.getUrl());
    }

    public <Data, E extends Throwable> void executeRequest(@NotNull String url, @NotNull Class<Data> responseDataClass, @NotNull ThrowableConsumer<Data, IOException> responseHandler, @NotNull ExceptionHandler<E> exceptionHandler, @Nullable DoubleConsumer progressHandler) throws IOException, E {
        if (url == null) {
            BintrayEndpoint.$$$reportNull$$$0(7);
        }
        if (responseDataClass == null) {
            BintrayEndpoint.$$$reportNull$$$0(8);
        }
        if (responseHandler == null) {
            BintrayEndpoint.$$$reportNull$$$0(9);
        }
        if (exceptionHandler == null) {
            BintrayEndpoint.$$$reportNull$$$0(10);
        }
        AtomicReference exception = new AtomicReference();
        HttpRequests.request((String)url).accept("application/json").connect(request -> {
            URLConnection urlConnection = request.getConnection();
            this.handleRequest(request, responseDataClass, responseHandler);
            int endPos = urlConnection.getHeaderFieldInt("X-RangeLimit-EndPos", Integer.MAX_VALUE);
            int totalEntries = urlConnection.getHeaderFieldInt("X-RangeLimit-Total", -1);
            if (endPos >= totalEntries) {
                if (progressHandler != null) {
                    progressHandler.accept(1.0);
                }
            } else {
                int totalIterations = 1 + (totalEntries - 1) / endPos;
                int threadsCount = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
                boolean useThreadPool = threadsCount > 1 && totalIterations >= 10;
                CountDownLatch cdl = useThreadPool ? new CountDownLatch(threadsCount) : null;
                AtomicInteger iterationsCounter = new AtomicInteger(0);
                AtomicInteger finishedIterations = new AtomicInteger(1);
                if (progressHandler != null) {
                    progressHandler.accept(1.0 / (double)totalIterations);
                }
                Runnable task = () -> {
                    try {
                        do {
                            int i;
                            if ((i = iterationsCounter.incrementAndGet()) >= totalIterations) {
                                break;
                            }
                            try {
                                HttpRequests.request((String)(url + "&start_pos=" + i * endPos)).accept("application/json").connect(r -> {
                                    this.handleRequest(r, responseDataClass, responseHandler);
                                    if (progressHandler != null) {
                                        progressHandler.accept(1.0 * (double)finishedIterations.incrementAndGet() / (double)totalIterations);
                                    }
                                    return null;
                                });
                            }
                            catch (Throwable e) {
                                exception.set(e);
                            }
                        } while (exception.get() == null);
                    }
                    finally {
                        if (useThreadPool) {
                            cdl.countDown();
                        }
                    }
                };
                if (useThreadPool) {
                    ExecutorService executorService = Executors.newFixedThreadPool(threadsCount);
                    for (int i = 0; i < threadsCount; ++i) {
                        executorService.execute(task);
                    }
                    try {
                        cdl.await();
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    task.run();
                }
            }
            return null;
        });
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            exceptionHandler.handle(t);
        }
    }

    private <Data> void handleRequest(HttpRequests.Request request, Class<Data> responseDataClass, ThrowableConsumer<Data, IOException> responseHandler) throws IOException {
        try (InputStream in = request.getInputStream();
             InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            Object data = this.gson.fromJson((Reader)reader, responseDataClass);
            responseHandler.consume(data);
        }
        catch (JsonParseException jsonException) {
            throw new IOException("Unexpected response format", jsonException);
        }
    }

    private static void defaultExceptionHandler(Throwable throwable) throws IOException {
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        throw new IOException(throwable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/services/bintray/BintrayEndpoint";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseDataClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseHandler";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/services/bintray/BintrayEndpoint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRepository";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRepositories";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getArtifacts";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface ExceptionHandler<E extends Throwable> {
        public void handle(Throwable var1) throws IOException, E;
    }
}

