/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.usageView.UsageViewShortNameLocation;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaBreadcrumbsInfoProvider
implements BreadcrumbsProvider {
    private static final Language[] ourLanguages = new Language[]{JavaLanguage.INSTANCE};

    public Language[] getLanguages() {
        return ourLanguages;
    }

    public boolean acceptElement(@NotNull PsiElement e) {
        if (e == null) {
            JavaBreadcrumbsInfoProvider.$$$reportNull$$$0(0);
        }
        return e instanceof PsiMember || e instanceof PsiLambdaExpression;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        if (e == null) {
            JavaBreadcrumbsInfoProvider.$$$reportNull$$$0(1);
        }
        if (e instanceof PsiLambdaExpression) {
            String string = PsiExpressionTrimRenderer.render((PsiExpression)((PsiExpression)e));
            if (string == null) {
                JavaBreadcrumbsInfoProvider.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (e instanceof PsiAnonymousClass) {
            String name2 = ((PsiAnonymousClass)e).getBaseClassReference().getReferenceName();
            String string = "new " + StringUtil.notNullize((String)name2, (String)"class");
            if (string == null) {
                JavaBreadcrumbsInfoProvider.$$$reportNull$$$0(3);
            }
            return string;
        }
        String description = ElementDescriptionUtil.getElementDescription((PsiElement)e, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
        String suffix = e instanceof PsiParameterListOwner ? "()" : null;
        String string = suffix != null ? description + suffix : description;
        if (string == null) {
            JavaBreadcrumbsInfoProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public Icon getElementIcon(@NotNull PsiElement element) {
        if (element == null) {
            JavaBreadcrumbsInfoProvider.$$$reportNull$$$0(5);
        }
        return Registry.is((String)"editor.breadcrumbs.java.icon") ? element.getIcon(0) : null;
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement e) {
        if (e == null) {
            JavaBreadcrumbsInfoProvider.$$$reportNull$$$0(6);
        }
        if (e instanceof PsiLambdaExpression) {
            return JavaBreadcrumbsInfoProvider.getLambdaDescription((PsiLambdaExpression)e);
        }
        if (e instanceof PsiMethod) {
            return JavaBreadcrumbsInfoProvider.getMethodPresentableText((PsiMethod)e);
        }
        return ElementDescriptionUtil.getElementDescription((PsiElement)e, (ElementDescriptionLocation)RefactoringDescriptionLocation.WITH_PARENT);
    }

    @NotNull
    private static String getMethodPresentableText(PsiMethod e) {
        boolean isDumb = DumbService.isDumb((Project)e.getProject());
        StringBuilder sb = new StringBuilder(e.isConstructor() ? "constructor" : "method");
        PsiType type2 = e.getReturnType();
        if (type2 != null) {
            sb.append(" ").append(StringUtil.htmlEmphasize((String)JavaBreadcrumbsInfoProvider.getTypeText(type2, isDumb)));
        }
        sb.append(" ").append(StringUtil.htmlEmphasize((String)e.getName()));
        JavaBreadcrumbsInfoProvider.appendParameters((PsiParameterListOwner)e, sb, false, isDumb);
        String string = sb.toString();
        if (string == null) {
            JavaBreadcrumbsInfoProvider.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String getLambdaDescription(@NotNull PsiLambdaExpression e) {
        PsiType functionalInterfaceType;
        if (e == null) {
            JavaBreadcrumbsInfoProvider.$$$reportNull$$$0(8);
        }
        boolean isDumb = DumbService.isDumb((Project)e.getProject());
        StringBuilder sb = new StringBuilder("lambda");
        PsiType psiType = functionalInterfaceType = isDumb ? null : e.getFunctionalInterfaceType();
        if (functionalInterfaceType != null) {
            sb.append(" ").append(StringUtil.htmlEmphasize((String)JavaBreadcrumbsInfoProvider.getTypeText(functionalInterfaceType, false)));
        }
        JavaBreadcrumbsInfoProvider.appendParameters((PsiParameterListOwner)e, sb, true, isDumb);
        String string = sb.toString();
        if (string == null) {
            JavaBreadcrumbsInfoProvider.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static void appendParameters(@NotNull PsiParameterListOwner e, StringBuilder sb, boolean skipIfEmpty, boolean isDumb) {
        PsiParameter[] parameters2;
        if (e == null) {
            JavaBreadcrumbsInfoProvider.$$$reportNull$$$0(10);
        }
        if ((parameters2 = e.getParameterList().getParameters()).length == 0 && skipIfEmpty) {
            return;
        }
        if (skipIfEmpty) {
            sb.append(" ");
        }
        sb.append("(");
        for (int i = 0; i < parameters2.length; ++i) {
            PsiTypeElement typeElement;
            if (i > 0) {
                sb.append(", ");
            }
            String typeStr = isDumb ? ((typeElement = parameters2[i].getTypeElement()) == null ? "" : PsiNameHelper.getShortClassName((String)typeElement.getText())) : JavaBreadcrumbsInfoProvider.getTypeText(parameters2[i].getType(), false);
            String str = StringUtil.isEmpty((String)typeStr) ? parameters2[i].getName() : PsiNameHelper.getShortClassName((String)typeStr);
            sb.append(StringUtil.htmlEmphasize((String)str));
        }
        sb.append(")");
    }

    @NotNull
    private static String getTypeText(@Nullable PsiType type2, boolean isDumb) {
        String result = type2 == null ? "" : (!isDumb || type2 instanceof PsiPrimitiveType ? type2.getCanonicalText(false) : (type2 instanceof PsiClassReferenceType ? ((PsiClassReferenceType)type2).getReference().getReferenceName() : ""));
        String string = PsiNameHelper.getShortClassName((String)StringUtil.notNullize((String)result));
        if (string == null) {
            JavaBreadcrumbsInfoProvider.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean isShownByDefault() {
        return !UISettings.getInstance().getShowMembersInNavigationBar();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/JavaBreadcrumbsInfoProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/JavaBreadcrumbsInfoProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodPresentableText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLambdaDescription";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementIcon";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementTooltip";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaDescription";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

