/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.lang.PsiElementExternalizer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiElementExternalizer
implements PsiElementExternalizer {
    public String getQualifiedName(PsiElement element) {
        if (element instanceof PsiClass) {
            return ((PsiClass)element).getQualifiedName();
        }
        if (element instanceof PsiMember) {
            String name2 = this.getQualifiedName((PsiElement)((PsiMember)element).getContainingClass());
            return name2 + "#" + ((PsiMember)element).getName();
        }
        return null;
    }

    @Nullable
    public PsiElement findByQualifiedName(Project project, @NotNull String qualifiedName) {
        String[] parts;
        if (qualifiedName == null) {
            JavaPsiElementExternalizer.$$$reportNull$$$0(0);
        }
        if ((parts = qualifiedName.split("#")).length > 0) {
            String fqn = parts[0];
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.projectScope((Project)project));
            if (psiClass != null) {
                if (parts.length == 2) {
                    String memberName = parts[1];
                    PsiField field = psiClass.findFieldByName(memberName, false);
                    if (field != null) {
                        return field;
                    }
                    PsiMethod[] methods = psiClass.findMethodsByName(memberName, false);
                    if (methods.length > 0) {
                        return methods[0];
                    }
                }
                return psiClass;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/lang/java/JavaPsiElementExternalizer", "findByQualifiedName"));
    }
}

