/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.util.Key;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavadocParser {
    private static final TokenSet TAG_VALUES_SET = TokenSet.create((IElementType[])new IElementType[]{JavaDocTokenType.DOC_TAG_VALUE_TOKEN, JavaDocTokenType.DOC_TAG_VALUE_COMMA, JavaDocTokenType.DOC_TAG_VALUE_DOT, JavaDocTokenType.DOC_TAG_VALUE_LPAREN, JavaDocTokenType.DOC_TAG_VALUE_RPAREN, JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN, JavaDocTokenType.DOC_TAG_VALUE_LT, JavaDocTokenType.DOC_TAG_VALUE_GT});
    private static final TokenSet INLINE_TAG_BORDERS_SET = TokenSet.create((IElementType[])new IElementType[]{JavaDocTokenType.DOC_INLINE_TAG_START, JavaDocTokenType.DOC_INLINE_TAG_END});
    private static final TokenSet SKIP_TOKENS = TokenSet.create((IElementType[])new IElementType[]{JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS});
    private static final String SEE_TAG = "@see";
    private static final String LINK_TAG = "@link";
    private static final String LINK_PLAIN_TAG = "@linkplain";
    private static final String PARAM_TAG = "@param";
    private static final String VALUE_TAG = "@value";
    private static final Set<String> REFERENCE_TAGS = ContainerUtil.set((Object[])new String[]{"@throws", "@exception", "@provides", "@uses"});
    private static final Key<Integer> BRACE_SCOPE_KEY = Key.create((String)"Javadoc.Parser.Brace.Scope");

    private JavadocParser() {
    }

    public static void parseJavadocReference(@NotNull PsiBuilder builder) {
        if (builder == null) {
            JavadocParser.$$$reportNull$$$0(0);
        }
        JavaParser.INSTANCE.getReferenceParser().parseJavaCodeReference(builder, true, true, false, false);
        JavadocParser.swallowTokens(builder);
    }

    public static void parseJavadocType(@NotNull PsiBuilder builder) {
        if (builder == null) {
            JavadocParser.$$$reportNull$$$0(1);
        }
        JavaParser.INSTANCE.getReferenceParser().parseType(builder, 7);
        JavadocParser.swallowTokens(builder);
    }

    private static void swallowTokens(PsiBuilder builder) {
        while (!builder.eof()) {
            builder.advanceLexer();
        }
    }

    public static void parseDocCommentText(@NotNull PsiBuilder builder) {
        if (builder == null) {
            JavadocParser.$$$reportNull$$$0(2);
        }
        builder.enforceCommentTokens(SKIP_TOKENS);
        while (!builder.eof()) {
            IElementType tokenType = JavadocParser.getTokenType(builder);
            if (tokenType == JavaDocTokenType.DOC_TAG_NAME) {
                JavadocParser.parseTag(builder);
                continue;
            }
            JavadocParser.parseDataItem(builder, null, false);
        }
    }

    private static void parseTag(PsiBuilder builder) {
        IElementType tokenType;
        String tagName = builder.getTokenText();
        PsiBuilder.Marker tag = builder.mark();
        builder.advanceLexer();
        while ((tokenType = JavadocParser.getTokenType(builder)) != null && tokenType != JavaDocTokenType.DOC_TAG_NAME && tokenType != JavaDocTokenType.DOC_COMMENT_END) {
            JavadocParser.parseDataItem(builder, tagName, false);
        }
        tag.done(JavaDocElementType.DOC_TAG);
    }

    private static void parseDataItem(PsiBuilder builder, @Nullable String tagName, boolean isInline) {
        IElementType tokenType = JavadocParser.getTokenType(builder);
        if (tokenType == JavaDocTokenType.DOC_INLINE_TAG_START) {
            int braceScope = JavadocParser.getBraceScope(builder);
            if (braceScope > 0) {
                JavadocParser.setBraceScope(builder, braceScope + 1);
                builder.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
                builder.advanceLexer();
                return;
            }
            PsiBuilder.Marker tag = builder.mark();
            builder.advanceLexer();
            tokenType = JavadocParser.getTokenType(builder);
            if (tokenType != JavaDocTokenType.DOC_TAG_NAME && tokenType != JavaDocTokenType.DOC_COMMENT_BAD_CHARACTER) {
                tag.rollbackTo();
                builder.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
                builder.advanceLexer();
                return;
            }
            JavadocParser.setBraceScope(builder, braceScope + 1);
            String inlineTagName = "";
            while (true) {
                if ((tokenType = JavadocParser.getTokenType(builder)) == JavaDocTokenType.DOC_TAG_NAME) {
                    inlineTagName = builder.getTokenText();
                } else if (tokenType == null || tokenType == JavaDocTokenType.DOC_COMMENT_END) break;
                JavadocParser.parseDataItem(builder, inlineTagName, true);
                if (tokenType != JavaDocTokenType.DOC_INLINE_TAG_END) continue;
                braceScope = JavadocParser.getBraceScope(builder);
                if (braceScope > 0) {
                    JavadocParser.setBraceScope(builder, --braceScope);
                }
                if (braceScope == 0) break;
            }
            tag.done(JavaDocElementType.DOC_INLINE_TAG);
        } else if (TAG_VALUES_SET.contains(tokenType)) {
            if (SEE_TAG.equals(tagName) && !isInline || LINK_TAG.equals(tagName) && isInline || JavaParserUtil.getLanguageLevel(builder).isAtLeast(LanguageLevel.JDK_1_4) && LINK_PLAIN_TAG.equals(tagName) && isInline) {
                JavadocParser.parseSeeTagValue(builder, false);
            } else if (!isInline && REFERENCE_TAGS.contains(tagName)) {
                PsiBuilder.Marker tagValue = builder.mark();
                builder.remapCurrentToken((IElementType)JavaDocElementType.DOC_REFERENCE_HOLDER);
                builder.advanceLexer();
                tagValue.done(JavaDocElementType.DOC_TAG_VALUE_ELEMENT);
            } else if (!isInline && PARAM_TAG.equals(tagName)) {
                JavadocParser.parseParameterRef(builder);
            } else if (JavaParserUtil.getLanguageLevel(builder).isAtLeast(LanguageLevel.JDK_1_5) && VALUE_TAG.equals(tagName) && isInline) {
                JavadocParser.parseSeeTagValue(builder, true);
            } else {
                JavadocParser.parseSimpleTagValue(builder);
            }
        } else {
            JavadocParser.remapAndAdvance(builder);
        }
    }

    private static void parseSeeTagValue(PsiBuilder builder, boolean allowBareFieldReference) {
        IElementType tokenType = JavadocParser.getTokenType(builder);
        if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            JavadocParser.parseMethodRef(builder, builder.mark());
        } else if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            PsiBuilder.Marker refStart = builder.mark();
            builder.remapCurrentToken((IElementType)JavaDocElementType.DOC_REFERENCE_HOLDER);
            builder.advanceLexer();
            if (JavadocParser.getTokenType(builder) == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
                JavadocParser.parseMethodRef(builder, refStart);
            } else if (allowBareFieldReference) {
                refStart.rollbackTo();
                builder.remapCurrentToken(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
                JavadocParser.parseMethodRef(builder, builder.mark());
            } else {
                refStart.drop();
            }
        } else {
            PsiBuilder.Marker tagValue = builder.mark();
            builder.advanceLexer();
            tagValue.done(JavaDocElementType.DOC_TAG_VALUE_ELEMENT);
        }
    }

    private static void parseMethodRef(PsiBuilder builder, PsiBuilder.Marker refStart) {
        if (JavadocParser.getTokenType(builder) == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            builder.advanceLexer();
        }
        if (JavadocParser.getTokenType(builder) != JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            refStart.done(JavaDocElementType.DOC_METHOD_OR_FIELD_REF);
            return;
        }
        builder.advanceLexer();
        if (JavadocParser.getTokenType(builder) == JavaDocTokenType.DOC_TAG_VALUE_LPAREN) {
            IElementType tokenType;
            builder.advanceLexer();
            PsiBuilder.Marker subValue = builder.mark();
            while (TAG_VALUES_SET.contains(tokenType = JavadocParser.getTokenType(builder))) {
                if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                    builder.remapCurrentToken((IElementType)JavaDocElementType.DOC_TYPE_HOLDER);
                    builder.advanceLexer();
                    while (TAG_VALUES_SET.contains(tokenType = JavadocParser.getTokenType(builder)) && tokenType != JavaDocTokenType.DOC_TAG_VALUE_COMMA && tokenType != JavaDocTokenType.DOC_TAG_VALUE_RPAREN) {
                        builder.advanceLexer();
                    }
                    continue;
                }
                if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_RPAREN) {
                    subValue.done(JavaDocElementType.DOC_TAG_VALUE_ELEMENT);
                    builder.advanceLexer();
                    refStart.done(JavaDocElementType.DOC_METHOD_OR_FIELD_REF);
                    return;
                }
                builder.advanceLexer();
            }
            subValue.done(JavaDocElementType.DOC_TAG_VALUE_ELEMENT);
        }
        refStart.done(JavaDocElementType.DOC_METHOD_OR_FIELD_REF);
    }

    private static void parseParameterRef(PsiBuilder builder) {
        PsiBuilder.Marker tagValue = builder.mark();
        while (TAG_VALUES_SET.contains(JavadocParser.getTokenType(builder))) {
            builder.advanceLexer();
        }
        tagValue.done(JavaDocElementType.DOC_PARAMETER_REF);
    }

    private static void parseSimpleTagValue(PsiBuilder builder) {
        PsiBuilder.Marker tagData = builder.mark();
        while (true) {
            IElementType tokenType;
            if ((tokenType = JavadocParser.getTokenType(builder)) == JavaDocTokenType.DOC_COMMENT_BAD_CHARACTER) {
                builder.remapCurrentToken(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
            } else if (!TAG_VALUES_SET.contains(tokenType)) break;
            builder.advanceLexer();
        }
        tagData.done(JavaDocElementType.DOC_TAG_VALUE_ELEMENT);
    }

    @Nullable
    private static IElementType getTokenType(PsiBuilder builder) {
        IElementType tokenType;
        while ((tokenType = builder.getTokenType()) == JavaDocTokenType.DOC_SPACE) {
            builder.remapCurrentToken(TokenType.WHITE_SPACE);
            builder.advanceLexer();
        }
        return tokenType;
    }

    private static int getBraceScope(PsiBuilder builder) {
        Integer braceScope = (Integer)builder.getUserData(BRACE_SCOPE_KEY);
        return braceScope != null ? braceScope : 0;
    }

    private static void setBraceScope(PsiBuilder builder, int braceScope) {
        builder.putUserData(BRACE_SCOPE_KEY, (Object)braceScope);
    }

    private static void remapAndAdvance(PsiBuilder builder) {
        if (INLINE_TAG_BORDERS_SET.contains(builder.getTokenType()) && JavadocParser.getBraceScope(builder) != 1) {
            builder.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
        }
        builder.advanceLexer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "builder";
        objectArray2[1] = "com/intellij/lang/java/parser/JavadocParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseJavadocReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseJavadocType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDocCommentText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

