/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.icons.AllIcons;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.wizard.AbstractExternalProjectImportProvider;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.projectImport.ProjectImportProvider;
import org.jetbrains.annotations.NotNull;

public class AttachExternalProjectAction
extends DumbAwareAction {
    public AttachExternalProjectAction() {
        this.getTemplatePresentation().setText(JavaUiBundle.messagePointer("action.attach.external.project.text", "External"));
        this.getTemplatePresentation().setDescription(JavaUiBundle.messagePointer("action.attach.external.project.description", "external"));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AttachExternalProjectAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        ProjectSystemId externalSystemId = (ProjectSystemId)e.getData(ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID);
        if (externalSystemId != null) {
            String name2 = externalSystemId.getReadableName();
            presentation.setText(JavaUiBundle.messagePointer("action.attach.external.project.text", name2));
            presentation.setDescription(JavaUiBundle.messagePointer("action.attach.external.project.description", name2));
        }
        presentation.setIcon(AllIcons.General.Add);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ProjectSystemId externalSystemId;
        if (e == null) {
            AttachExternalProjectAction.$$$reportNull$$$0(1);
        }
        if ((externalSystemId = (ProjectSystemId)e.getData(ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID)) == null) {
            return;
        }
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        if (manager == null) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        ExternalSystemActionsCollector.trigger((Project)project, (ProjectSystemId)externalSystemId, (AnAction)this, (AnActionEvent)e);
        ProjectImportProvider[] projectImportProviders = new ProjectImportProvider[1];
        for (ProjectImportProvider provider : (ProjectImportProvider[])ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensions()) {
            if (!(provider instanceof AbstractExternalProjectImportProvider) || !externalSystemId.equals((Object)((AbstractExternalProjectImportProvider)provider).getExternalSystemId())) continue;
            projectImportProviders[0] = provider;
            break;
        }
        if (projectImportProviders[0] == null) {
            return;
        }
        AddModuleWizard wizard = ImportModuleAction.selectFileAndCreateWizard(project, null, manager.getExternalProjectDescriptor(), projectImportProviders);
        if (wizard != null && (wizard.getStepCount() <= 0 || wizard.showAndGet())) {
            ImportModuleAction.createFromWizard(project, wizard);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/externalSystem/action/AttachExternalProjectAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

