/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;

final class DefaultJdkConfigurator {
    DefaultJdkConfigurator() {
        String suggestedName;
        Collection homePaths;
        String homePath;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        if (propertiesComponent.getBoolean("defaultJdkConfigured", false)) {
            return;
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        List jdks = projectJdkTable.getSdksOfType((SdkTypeId)javaSdk);
        if (jdks.isEmpty() && (homePath = (String)ContainerUtil.getFirstItem((Collection)(homePaths = javaSdk.suggestHomePaths()))) != null && javaSdk.isValidSdkHome(homePath) && (suggestedName = JdkUtil.suggestJdkName((String)javaSdk.getVersionString(homePath))) != null) {
            ApplicationManager.getApplication().runWriteAction(() -> projectJdkTable.addJdk(javaSdk.createJdk(suggestedName, homePath, false)));
        }
        propertiesComponent.setValue("defaultJdkConfigured", true);
    }
}

