/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ui;

import com.intellij.ide.DataManager;
import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.ProjectJdksConfigurable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectJdksEditor
extends DialogWrapper {
    private ProjectJdksConfigurable myConfigurable;
    private Sdk myProjectJdk;

    public ProjectJdksEditor(@Nullable Sdk jdk, @NotNull Project project, @NotNull Component parent) {
        if (project == null) {
            ProjectJdksEditor.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            ProjectJdksEditor.$$$reportNull$$$0(1);
        }
        this(jdk, parent, new ProjectJdksConfigurable(project));
    }

    public ProjectJdksEditor(@Nullable Sdk jdk, @NotNull Component parent, @NotNull ProjectJdksConfigurable configurable) {
        if (parent == null) {
            ProjectJdksEditor.$$$reportNull$$$0(2);
        }
        if (configurable == null) {
            ProjectJdksEditor.$$$reportNull$$$0(3);
        }
        super(parent, true);
        this.myConfigurable = configurable;
        SwingUtilities.invokeLater(() -> this.myConfigurable.selectNodeInTree(jdk != null ? jdk.getName() : null));
        this.setTitle(JavaUiBundle.message("sdk.configure.title", new Object[0]));
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                if (ProjectJdksEditor.this.myConfigurable != null) {
                    ProjectJdksEditor.this.myConfigurable.disposeUIResources();
                    ProjectJdksEditor.this.myConfigurable = null;
                }
            }
        });
        this.init();
    }

    public ProjectJdksEditor(Sdk jdk, Component parent) {
        this(jdk, (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext()), parent);
    }

    protected JComponent createCenterPanel() {
        this.myConfigurable.reset();
        return this.myConfigurable.createComponent();
    }

    protected void doOKAction() {
        try {
            this.myProjectJdk = this.myConfigurable.getSelectedJdk();
            this.myConfigurable.apply();
            super.doOKAction();
        }
        catch (ConfigurationException e) {
            Messages.showMessageDialog((Component)this.getContentPane(), (String)e.getMessage(), (String)JavaUiBundle.message("sdk.configure.save.settings.error", new Object[0]), (Icon)Messages.getErrorIcon());
        }
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.openapi.projectRoots.ui.ProjectJdksEditor";
    }

    public Sdk getSelectedJdk() {
        return this.myProjectJdk;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "configurable";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/projectRoots/ui/ProjectJdksEditor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

