/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ProjectExtension;
import com.intellij.openapi.roots.WatchedRootsProvider;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class CompilerProjectExtensionImpl
extends CompilerProjectExtension {
    private static final String OUTPUT_TAG = "output";
    private static final String URL = "url";
    private VirtualFilePointer myCompilerOutput;
    private LocalFileSystem.WatchRequest myCompilerOutputWatchRequest;
    private final Project myProject;

    public CompilerProjectExtensionImpl(@NotNull Project project) {
        if (project == null) {
            CompilerProjectExtensionImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    private void readExternal(Element element) {
        Element pathElement = element.getChild(OUTPUT_TAG);
        if (pathElement != null) {
            String outputPath = pathElement.getAttributeValue(URL);
            this.myCompilerOutput = outputPath != null ? VirtualFilePointerManager.getInstance().create(outputPath, (Disposable)this.myProject, null) : null;
        }
    }

    private void writeExternal(Element element) {
        if (this.myCompilerOutput != null) {
            Element pathElement = new Element(OUTPUT_TAG);
            pathElement.setAttribute(URL, this.myCompilerOutput.getUrl());
            element.addContent(pathElement);
        }
    }

    public VirtualFile getCompilerOutput() {
        return this.myCompilerOutput != null ? this.myCompilerOutput.getFile() : null;
    }

    public String getCompilerOutputUrl() {
        return this.myCompilerOutput != null ? this.myCompilerOutput.getUrl() : null;
    }

    public VirtualFilePointer getCompilerOutputPointer() {
        return this.myCompilerOutput;
    }

    public void setCompilerOutputPointer(VirtualFilePointer pointer) {
        this.myCompilerOutput = pointer;
    }

    public void setCompilerOutputUrl(String compilerOutputUrl) {
        VirtualFilePointer pointer = VirtualFilePointerManager.getInstance().create(compilerOutputUrl, (Disposable)this.myProject, null);
        this.setCompilerOutputPointer(pointer);
        String path = VfsUtilCore.urlToPath((String)compilerOutputUrl);
        this.myCompilerOutputWatchRequest = LocalFileSystem.getInstance().replaceWatchedRoot(this.myCompilerOutputWatchRequest, path, true);
    }

    @NotNull
    private static Set<String> getRootsToWatch(Project project) {
        String compilerOutputUrl;
        HashSet<String> rootsToWatch = new HashSet<String>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            String testOutputUrl;
            CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
            if (extension == null || extension.isCompilerOutputPathInherited()) continue;
            String outputUrl = extension.getCompilerOutputUrl();
            if (!StringUtil.isEmpty((String)outputUrl)) {
                rootsToWatch.add(ProjectRootManagerImpl.extractLocalPath((String)outputUrl));
            }
            if (StringUtil.isEmpty((String)(testOutputUrl = extension.getCompilerOutputUrlForTests()))) continue;
            rootsToWatch.add(ProjectRootManagerImpl.extractLocalPath((String)testOutputUrl));
        }
        CompilerProjectExtension extension = CompilerProjectExtension.getInstance((Project)project);
        if (extension != null && (compilerOutputUrl = extension.getCompilerOutputUrl()) != null) {
            rootsToWatch.add(ProjectRootManagerImpl.extractLocalPath((String)compilerOutputUrl));
        }
        HashSet<String> hashSet = rootsToWatch;
        if (hashSet == null) {
            CompilerProjectExtensionImpl.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static CompilerProjectExtensionImpl getImpl(Project project) {
        return (CompilerProjectExtensionImpl)CompilerProjectExtension.getInstance((Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/CompilerProjectExtensionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/CompilerProjectExtensionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsToWatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyWatchedRootsProvider
    implements WatchedRootsProvider {
        private final Project myProject;

        public MyWatchedRootsProvider(Project project) {
            this.myProject = project;
        }

        @NotNull
        public Set<String> getRootsToWatch() {
            Set set = CompilerProjectExtensionImpl.getRootsToWatch(this.myProject);
            if (set == null) {
                MyWatchedRootsProvider.$$$reportNull$$$0(0);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/CompilerProjectExtensionImpl$MyWatchedRootsProvider", "getRootsToWatch"));
        }
    }

    public static class MyProjectExtension
    extends ProjectExtension {
        private final Project myProject;

        public MyProjectExtension(Project project) {
            this.myProject = project;
        }

        public void readExternal(@NotNull Element element) {
            if (element == null) {
                MyProjectExtension.$$$reportNull$$$0(0);
            }
            CompilerProjectExtensionImpl.getImpl(this.myProject).readExternal(element);
        }

        public void writeExternal(@NotNull Element element) {
            if (element == null) {
                MyProjectExtension.$$$reportNull$$$0(1);
            }
            CompilerProjectExtensionImpl.getImpl(this.myProject).writeExternal(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/openapi/roots/impl/CompilerProjectExtensionImpl$MyProjectExtension";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readExternal";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeExternal";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

