/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.compiler.ModuleSourceSet;
import com.intellij.compiler.server.impl.BuildProcessCustomPluginsConfiguration;
import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructureBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.UsageInProjectSettings;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.UsagesInUnloadedModules;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Chunk;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GeneralProjectSettingsElement
extends ProjectStructureElement {
    public GeneralProjectSettingsElement(@NotNull StructureConfigurableContext context) {
        if (context == null) {
            GeneralProjectSettingsElement.$$$reportNull$$$0(0);
        }
        super(context);
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return "Project";
    }

    @Override
    public String getPresentableName() {
        return ProjectStructureConfigurable.getInstance(this.myContext.getProject()).getProjectConfig().getProjectName();
    }

    @Override
    public String getTypeName() {
        return "Project";
    }

    @Override
    public void check(ProjectStructureProblemsHolder problemsHolder) {
        Object place;
        ProjectSdksModel model;
        Sdk sdk;
        Project project = this.myContext.getProject();
        if (this.containsModuleWithInheritedSdk() && (sdk = (model = ProjectStructureConfigurable.getInstance(project).getProjectJdksModel()).getProjectSdk()) == null) {
            place = new PlaceInProjectStructureBase(project, ProjectStructureConfigurable.getInstance(project).createProjectConfigurablePlace(), this);
            problemsHolder.registerProblem(JavaUiBundle.message("project.roots.project.jdk.problem.message", new Object[0]), null, ProjectStructureProblemType.error("project-sdk-not-defined"), (PlaceInProjectStructure)place, null);
        }
        List sourceSetCycles = ModuleCompilerUtil.computeSourceSetCycles((ModulesProvider)this.myContext.getModulesConfigurator());
        ArrayList<String> cycles = new ArrayList<String>();
        for (Chunk chunk : sourceSetCycles) {
            Set sourceSets = chunk.getNodes();
            ArrayList<String> names2 = new ArrayList<String>();
            for (ModuleSourceSet sourceSet : sourceSets) {
                String name2 = sourceSet.getDisplayName();
                names2.add(names2.isEmpty() ? name2 : StringUtil.decapitalize((String)name2));
            }
            cycles.add(StringUtil.join(names2, (String)", "));
        }
        if (!cycles.isEmpty()) {
            String description;
            String message2;
            place = new PlaceInProjectStructureBase(project, ProjectStructureConfigurable.getInstance(project).createModulesPlace(), this);
            if (cycles.size() > 1) {
                message2 = "Circular dependencies";
                String br = "<br>&nbsp;&nbsp;&nbsp;&nbsp;";
                StringBuilder cyclesString = new StringBuilder();
                for (int i = 0; i < cycles.size(); ++i) {
                    cyclesString.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;").append(i + 1).append(". ").append((String)cycles.get(i));
                }
                description = JavaUiBundle.message("module.circular.dependency.warning.description", cyclesString);
            } else {
                message2 = JavaUiBundle.message("module.circular.dependency.warning.short", StringUtil.decapitalize((String)((String)cycles.get(0))));
                description = null;
            }
            problemsHolder.registerProblem(new ProjectStructureProblemDescription(message2, description, (PlaceInProjectStructure)place, ProjectStructureProblemType.warning("module-circular-dependency"), Collections.emptyList()));
        }
    }

    private boolean containsModuleWithInheritedSdk() {
        for (Module module : this.myContext.getModules()) {
            ModuleRootModel rootModel = this.myContext.getModulesConfigurator().getRootModel(module);
            if (!rootModel.isSdkInherited()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ProjectStructureElementUsage> getUsagesInElement() {
        ArrayList<ProjectStructureElementUsage> usages = new ArrayList<ProjectStructureElementUsage>();
        Collection unloadedModules = ModuleManager.getInstance((Project)this.myContext.getProject()).getUnloadedModuleDescriptions();
        if (!unloadedModules.isEmpty()) {
            MultiMap dependenciesInUnloadedModules = new MultiMap();
            for (UnloadedModuleDescription unloaded : unloadedModules) {
                for (String moduleName : unloaded.getDependencyModuleNames()) {
                    Module depModule = this.myContext.getModulesConfigurator().getModuleModel().findModuleByName(moduleName);
                    if (depModule == null) continue;
                    dependenciesInUnloadedModules.putValue((Object)depModule, (Object)unloaded);
                }
            }
            for (Map.Entry entry : dependenciesInUnloadedModules.entrySet()) {
                usages.add(new UsagesInUnloadedModules(this.myContext, this, new ModuleProjectStructureElement(this.myContext, (Module)entry.getKey()), (Collection)entry.getValue()));
            }
            for (Library library : this.myContext.getProjectLibrariesProvider().getModifiableModel().getLibraries()) {
                usages.add(new UsagesInUnloadedModules(this.myContext, this, new LibraryProjectStructureElement(this.myContext, library), unloadedModules));
            }
        }
        for (String libraryName : BuildProcessCustomPluginsConfiguration.getInstance(this.myContext.getProject()).getProjectLibraries()) {
            Library library = this.myContext.getProjectLibrariesProvider().getModifiableModel().getLibraryByName(libraryName);
            if (library == null) continue;
            usages.add(new UsageInProjectSettings(this.myContext, new LibraryProjectStructureElement(this.myContext, library), "Build process configuration"));
        }
        return usages;
    }

    @Override
    public String getId() {
        return "project:general";
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof GeneralProjectSettingsElement;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/roots/ui/configuration/GeneralProjectSettingsElement", "<init>"));
    }
}

