/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.SdkComboBoxBase;
import com.intellij.openapi.roots.ui.configuration.SdkListItem;
import com.intellij.openapi.roots.ui.configuration.SdkListModel;
import com.intellij.openapi.roots.ui.configuration.SdkListModelBuilder;
import com.intellij.openapi.roots.ui.configuration.SdkListPresenter;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.ComboBoxPopupState;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkComboBox
extends SdkComboBoxBase<JdkComboBoxItem> {
    private static final Logger LOG = Logger.getInstance(JdkComboBox.class);
    @NotNull
    private final Consumer<Sdk> myOnNewSdkAdded;
    @Nullable
    private JButton mySetUpButton;

    @Deprecated
    public JdkComboBox(@NotNull ProjectSdksModel jdkModel) {
        if (jdkModel == null) {
            JdkComboBox.$$$reportNull$$$0(0);
        }
        this(jdkModel, null);
    }

    @Deprecated
    public JdkComboBox(@NotNull ProjectSdksModel jdkModel, @Nullable Condition<? super SdkTypeId> filter) {
        if (jdkModel == null) {
            JdkComboBox.$$$reportNull$$$0(1);
        }
        this(jdkModel, filter, JdkComboBox.getSdkFilter(filter), filter, false);
    }

    @Deprecated
    public JdkComboBox(@NotNull ProjectSdksModel jdkModel, @Nullable Condition<? super SdkTypeId> sdkTypeFilter, @Nullable Condition<? super Sdk> filter, @Nullable Condition<? super SdkTypeId> creationFilter, boolean addSuggestedItems) {
        if (jdkModel == null) {
            JdkComboBox.$$$reportNull$$$0(2);
        }
        this(null, jdkModel, sdkTypeFilter, filter, creationFilter, null);
    }

    public JdkComboBox(@Nullable Project project, @NotNull ProjectSdksModel sdkModel, @Nullable Condition<? super SdkTypeId> sdkTypeFilter, @Nullable Condition<? super Sdk> sdkFilter, @Nullable Condition<? super SdkTypeId> creationFilter, @Nullable Consumer<? super Sdk> onNewSdkAdded) {
        if (sdkModel == null) {
            JdkComboBox.$$$reportNull$$$0(3);
        }
        super(new SdkListModelBuilder(project, sdkModel, sdkTypeFilter, SimpleJavaSdkType.notSimpleJavaSdkType(creationFilter), sdkFilter));
        this.myOnNewSdkAdded = sdk -> {
            if (onNewSdkAdded != null) {
                onNewSdkAdded.consume(sdk);
            }
        };
        this.setRenderer(new SdkListPresenter(() -> ((JdkComboBoxModel)this.getModel()).myInnerModel).forType(JdkComboBox::unwrapItem));
        this.reloadModel();
    }

    protected void onModelUpdated(@NotNull SdkListModel model) {
        if (model == null) {
            JdkComboBox.$$$reportNull$$$0(4);
        }
        JdkComboBoxItem previousSelection = this.getSelectedItem();
        JdkComboBoxModel newModel = new JdkComboBoxModel(model);
        newModel.setSelectedItem(previousSelection);
        this.setModel(newModel);
    }

    @NotNull
    private static SdkListItem unwrapItem(@Nullable JdkComboBoxItem item) {
        if (item == null) {
            item = new ProjectJdkComboBoxItem();
        }
        if (item instanceof InnerComboBoxItem) {
            SdkListItem sdkListItem = ((InnerComboBoxItem)((Object)item)).getItem();
            if (sdkListItem == null) {
                JdkComboBox.$$$reportNull$$$0(5);
            }
            return sdkListItem;
        }
        throw new RuntimeException("Failed to unwrap " + item.getClass().getName() + ": " + item);
    }

    @NotNull
    private static JdkComboBoxItem wrapItem(@NotNull SdkListItem item) {
        if (item == null) {
            JdkComboBox.$$$reportNull$$$0(6);
        }
        if (item instanceof SdkListItem.SdkItem) {
            return new ActualJdkInnerItem((SdkListItem.SdkItem)item);
        }
        if (item instanceof SdkListItem.NoneSdkItem) {
            return new NoneJdkComboBoxItem();
        }
        if (item instanceof SdkListItem.ProjectSdkItem) {
            return new ProjectJdkComboBoxItem();
        }
        return new InnerJdkComboBoxItem(item);
    }

    @Deprecated
    public void setSetupButton(JButton setUpButton, @Nullable Project project, ProjectSdksModel jdksModel, JdkComboBoxItem firstItem, @Nullable Condition<? super Sdk> additionalSetup, boolean moduleJdkSetup) {
        this.setSetupButton(setUpButton, project, jdksModel, firstItem, additionalSetup, "");
    }

    @Deprecated
    public void setSetupButton(JButton setUpButton, @Nullable Project project, ProjectSdksModel jdksModel, JdkComboBoxItem firstItem, @Nullable Condition<? super Sdk> additionalSetup, String actionGroupTitle) {
        this.mySetUpButton = setUpButton;
        this.mySetUpButton.setVisible(false);
    }

    public void setEditButton(@NotNull JButton editButton, @NotNull Project project, @NotNull Supplier<? extends Sdk> retrieveJDK) {
        if (editButton == null) {
            JdkComboBox.$$$reportNull$$$0(7);
        }
        if (project == null) {
            JdkComboBox.$$$reportNull$$$0(8);
        }
        if (retrieveJDK == null) {
            JdkComboBox.$$$reportNull$$$0(9);
        }
        editButton.addActionListener(e -> {
            Sdk projectJdk = (Sdk)retrieveJDK.get();
            if (projectJdk != null) {
                ProjectStructureConfigurable.getInstance(project).select(projectJdk, true);
            }
        });
        this.addActionListener(e -> {
            JdkComboBoxItem selectedItem = this.getSelectedItem();
            if (selectedItem instanceof ProjectJdkComboBoxItem) {
                editButton.setEnabled(ProjectStructureConfigurable.getInstance(project).getProjectJdksModel().getProjectSdk() != null);
            } else {
                editButton.setEnabled(selectedItem != null && selectedItem.getJdk() != null);
            }
        });
    }

    @Deprecated
    @Nullable
    public JButton getSetUpButton() {
        return this.mySetUpButton;
    }

    @Nullable
    public JdkComboBoxItem getSelectedItem() {
        return (JdkComboBoxItem)super.getSelectedItem();
    }

    @Nullable
    public Sdk getSelectedJdk() {
        JdkComboBoxItem selectedItem = this.getSelectedItem();
        return selectedItem != null ? selectedItem.getJdk() : null;
    }

    public void setSelectedJdk(@Nullable Sdk jdk) {
        this.setSelectedItem(jdk);
    }

    @Deprecated
    public void reloadModel(JdkComboBoxItem firstItem, @Nullable Project project) {
        this.processFirstItem(firstItem);
        this.reloadModel();
    }

    private void processFirstItem(@Nullable JdkComboBoxItem firstItem) {
        if (firstItem instanceof ProjectJdkComboBoxItem) {
            this.myModel.showProjectSdkItem();
        } else if (firstItem instanceof NoneJdkComboBoxItem) {
            this.myModel.showNoneSdkItem();
        } else if (firstItem instanceof ActualJdkComboBoxItem) {
            this.setSelectedJdk(((ActualJdkComboBoxItem)firstItem).myJdk);
        }
    }

    public void firePopupMenuWillBecomeVisible() {
        this.resolveSuggestionsIfNeeded();
        super.firePopupMenuWillBecomeVisible();
    }

    private void resolveSuggestionsIfNeeded() {
        this.myModel.reloadActions();
        DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)((Object)this));
        if (dialogWrapper == null) {
            LOG.warn("Cannot find DialogWrapper parent for the JdkComboBox " + (Object)((Object)this) + ", SDK search is disabled", (Throwable)new RuntimeException());
            return;
        }
        this.myModel.detectItems((JComponent)((Object)this), dialogWrapper.getDisposable());
    }

    public void setSelectedItem(@Nullable Object anObject) {
        SdkListItem item;
        if (anObject instanceof SdkListItem) {
            this.setSelectedItem(JdkComboBox.wrapItem((SdkListItem)anObject));
            return;
        }
        if (anObject == null) {
            SdkListModel innerModel = ((JdkComboBoxModel)this.getModel()).myInnerModel;
            SdkListItem candidate = innerModel.findProjectSdkItem();
            if (candidate == null) {
                candidate = innerModel.findNoneSdkItem();
            }
            if (candidate == null) {
                candidate = this.myModel.showProjectSdkItem();
            }
            this.setSelectedItem(candidate);
            return;
        }
        if (anObject instanceof Sdk) {
            this.myModel.reloadSdks();
            ((JdkComboBoxModel)this.getModel()).trySelectSdk((Sdk)anObject);
            return;
        }
        if (anObject instanceof InnerComboBoxItem && this.myModel.executeAction((JComponent)((Object)this), item = ((InnerComboBoxItem)anObject).getItem(), newItem -> {
            this.setSelectedItem(newItem);
            if (newItem instanceof SdkListItem.SdkItem) {
                this.myOnNewSdkAdded.consume((Object)((SdkListItem.SdkItem)newItem).getSdk());
            }
        })) {
            return;
        }
        if (anObject instanceof SelectableComboBoxItem) {
            super.setSelectedItem(anObject);
        }
    }

    @NotNull
    public static Condition<Sdk> getSdkFilter(@Nullable Condition<? super SdkTypeId> filter) {
        Condition condition2 = filter == null ? Conditions.alwaysTrue() : sdk -> filter.value((Object)sdk.getSdkType());
        if (condition2 == null) {
            JdkComboBox.$$$reportNull$$$0(10);
        }
        return condition2;
    }

    @Deprecated
    public void insertItemAt(JdkComboBoxItem item, int index) {
        super.insertItemAt((Object)item, index);
        this.processFirstItem(item);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editButton";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "retrieveJDK";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapItem";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onModelUpdated";
                break;
            }
            case 5: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wrapItem";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setEditButton";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    public static class SuggestedJdkItem
    extends JdkComboBoxItem {
        private final SdkType mySdkType;
        private final String myPath;

        SuggestedJdkItem(@NotNull SdkType sdkType, @NotNull String path) {
            if (sdkType == null) {
                SuggestedJdkItem.$$$reportNull$$$0(0);
            }
            if (path == null) {
                SuggestedJdkItem.$$$reportNull$$$0(1);
            }
            this.mySdkType = sdkType;
            this.myPath = path;
        }

        @NotNull
        public SdkType getSdkType() {
            SdkType sdkType = this.mySdkType;
            if (sdkType == null) {
                SuggestedJdkItem.$$$reportNull$$$0(2);
            }
            return sdkType;
        }

        @NotNull
        public String getPath() {
            String string = this.myPath;
            if (string == null) {
                SuggestedJdkItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        public String toString() {
            return this.myPath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox$SuggestedJdkItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox$SuggestedJdkItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSdkType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class NoneJdkComboBoxItem
    extends JdkComboBoxItem
    implements InnerComboBoxItem,
    SelectableComboBoxItem {
        @Override
        @NotNull
        public SdkListItem getItem() {
            return new SdkListItem.NoneSdkItem();
        }

        public String toString() {
            return JavaUiBundle.message("jdk.combo.box.none.item", new Object[0]);
        }

        public int hashCode() {
            return 42;
        }

        public boolean equals(Object obj) {
            return obj instanceof NoneJdkComboBoxItem;
        }
    }

    public static class ProjectJdkComboBoxItem
    extends JdkComboBoxItem
    implements InnerComboBoxItem,
    SelectableComboBoxItem {
        @Override
        @NotNull
        public SdkListItem getItem() {
            return new SdkListItem.ProjectSdkItem();
        }

        public int hashCode() {
            return 42;
        }

        public boolean equals(Object obj) {
            return obj instanceof ProjectJdkComboBoxItem;
        }
    }

    public static class ActualJdkComboBoxItem
    extends JdkComboBoxItem
    implements SelectableComboBoxItem {
        private final Sdk myJdk;

        public ActualJdkComboBoxItem(@NotNull Sdk jdk) {
            if (jdk == null) {
                ActualJdkComboBoxItem.$$$reportNull$$$0(0);
            }
            this.myJdk = jdk;
        }

        public String toString() {
            return this.myJdk.getName();
        }

        @Override
        @NotNull
        public Sdk getJdk() {
            Sdk sdk = this.myJdk;
            if (sdk == null) {
                ActualJdkComboBoxItem.$$$reportNull$$$0(1);
            }
            return sdk;
        }

        @Override
        @Nullable
        public String getSdkName() {
            return this.myJdk.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActualJdkComboBoxItem item = (ActualJdkComboBoxItem)o;
            return this.myJdk.equals(item.myJdk);
        }

        public int hashCode() {
            return Objects.hash(this.myJdk);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox$ActualJdkComboBoxItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox$ActualJdkComboBoxItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJdk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ActualJdkInnerItem
    extends ActualJdkComboBoxItem
    implements InnerComboBoxItem {
        private final SdkListItem.SdkItem myItem;

        private ActualJdkInnerItem(@NotNull SdkListItem.SdkItem item) {
            if (item == null) {
                ActualJdkInnerItem.$$$reportNull$$$0(0);
            }
            super(item.getSdk());
            this.myItem = item;
        }

        @Override
        @NotNull
        public SdkListItem getItem() {
            SdkListItem.SdkItem sdkItem = this.myItem;
            if (sdkItem == null) {
                ActualJdkInnerItem.$$$reportNull$$$0(1);
            }
            return sdkItem;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox$ActualJdkInnerItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox$ActualJdkInnerItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InnerJdkComboBoxItem
    extends JdkComboBoxItem
    implements InnerComboBoxItem {
        private final SdkListItem myItem;

        private InnerJdkComboBoxItem(@NotNull SdkListItem item) {
            if (item == null) {
                InnerJdkComboBoxItem.$$$reportNull$$$0(0);
            }
            this.myItem = item;
        }

        @Override
        @NotNull
        public SdkListItem getItem() {
            SdkListItem sdkListItem = this.myItem;
            if (sdkListItem == null) {
                InnerJdkComboBoxItem.$$$reportNull$$$0(1);
            }
            return sdkListItem;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InnerJdkComboBoxItem item = (InnerJdkComboBoxItem)o;
            return this.myItem.equals(item.myItem);
        }

        public int hashCode() {
            return Objects.hash(this.myItem);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox$InnerJdkComboBoxItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox$InnerJdkComboBoxItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class JdkComboBoxItem {
        @Nullable
        public Sdk getJdk() {
            return null;
        }

        @Nullable
        public String getSdkName() {
            return null;
        }
    }

    private static interface SelectableComboBoxItem {
    }

    private static interface InnerComboBoxItem {
        @NotNull
        public SdkListItem getItem();
    }

    private static class JdkComboBoxModel
    extends AbstractListModel<JdkComboBoxItem>
    implements ComboBoxPopupState<JdkComboBoxItem>,
    ComboBoxModel<JdkComboBoxItem> {
        private final SdkListModel myInnerModel;
        private JdkComboBoxItem mySelectedItem;

        JdkComboBoxModel(@NotNull SdkListModel innerModel) {
            if (innerModel == null) {
                JdkComboBoxModel.$$$reportNull$$$0(0);
            }
            this.myInnerModel = innerModel;
        }

        @Override
        public int getSize() {
            return this.myInnerModel.getItems().size();
        }

        @Override
        public JdkComboBoxItem getElementAt(int index) {
            return JdkComboBox.wrapItem((SdkListItem)this.myInnerModel.getItems().get(index));
        }

        @Nullable
        public ListModel<JdkComboBoxItem> onChosen(JdkComboBoxItem selectedValue) {
            if (selectedValue instanceof InnerComboBoxItem) {
                SdkListModel inner = this.myInnerModel.onChosen(((InnerComboBoxItem)((Object)selectedValue)).getItem());
                return inner == null ? null : new JdkComboBoxModel(inner);
            }
            return null;
        }

        public boolean hasSubstep(JdkComboBoxItem selectedValue) {
            if (selectedValue instanceof InnerComboBoxItem) {
                return this.myInnerModel.hasSubstep(((InnerComboBoxItem)((Object)selectedValue)).getItem());
            }
            return false;
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (!(anObject instanceof JdkComboBoxItem)) {
                return;
            }
            if (!(anObject instanceof InnerComboBoxItem)) {
                return;
            }
            SdkListItem innerItem = ((InnerComboBoxItem)anObject).getItem();
            if (!this.myInnerModel.getItems().contains(innerItem)) {
                return;
            }
            this.mySelectedItem = (JdkComboBoxItem)anObject;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.mySelectedItem;
        }

        void trySelectSdk(@NotNull Sdk sdk) {
            SdkListItem.SdkItem item;
            if (sdk == null) {
                JdkComboBoxModel.$$$reportNull$$$0(1);
            }
            if ((item = this.myInnerModel.findSdkItem(sdk)) == null) {
                return;
            }
            this.setSelectedItem(JdkComboBox.wrapItem((SdkListItem)item));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "innerModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/JdkComboBox$JdkComboBoxModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "trySelectSdk";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

