/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import org.jetbrains.annotations.Nullable;

public class UIRootConfigurationAccessor
extends RootConfigurationAccessor {
    private final Project myProject;

    public UIRootConfigurationAccessor(Project project) {
        this.myProject = project;
    }

    @Nullable
    public Library getLibrary(Library library, String libraryName, String libraryLevel) {
        StructureConfigurableContext context = ProjectStructureConfigurable.getInstance(this.myProject).getContext();
        if (library == null) {
            if (libraryName != null) {
                library = context.getLibrary(libraryName, libraryLevel);
            }
        } else {
            Library model = context.getLibraryModel(library);
            if (model != null) {
                library = model;
            }
            library = context.getLibrary(library.getName(), library.getTable().getTableLevel());
        }
        return library;
    }

    @Nullable
    public Sdk getSdk(Sdk sdk, String sdkName) {
        ProjectSdksModel model = ProjectStructureConfigurable.getInstance(this.myProject).getJdkConfig().getJdksTreeModel();
        return sdkName != null ? model.findSdk(sdkName) : sdk;
    }

    public Module getModule(Module module, String moduleName) {
        if (module == null) {
            return ModuleStructureConfigurable.getInstance(this.myProject).getModule(moduleName);
        }
        return module;
    }

    public Sdk getProjectSdk(Project project) {
        return ProjectStructureConfigurable.getInstance(project).getProjectJdksModel().getProjectSdk();
    }

    @Nullable
    public String getProjectSdkName(Project project) {
        Sdk projectJdk = this.getProjectSdk(project);
        if (projectJdk != null) {
            return projectJdk.getName();
        }
        String projectJdkName = ProjectRootManager.getInstance((Project)project).getProjectSdkName();
        ProjectSdksModel projectJdksModel = ProjectStructureConfigurable.getInstance(project).getProjectJdksModel();
        return projectJdkName != null && projectJdksModel.findSdk(projectJdkName) == null ? projectJdkName : null;
    }
}

