/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.facet.Facet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModificationOfImportedModelWarningComponent;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProblemsHolderImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContextImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.UsageInArtifact;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.FacetProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.FacetBasedPackagingElement;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.impl.elements.ModulePackagingElement;
import com.intellij.packaging.ui.ArtifactProblemQuickFix;
import com.intellij.packaging.ui.ArtifactProblemsHolder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactProjectStructureElement
extends ProjectStructureElement {
    private final ArtifactsStructureConfigurableContext myArtifactsStructureContext;
    private final Artifact myOriginalArtifact;

    ArtifactProjectStructureElement(StructureConfigurableContext context, ArtifactsStructureConfigurableContext artifactsStructureContext, Artifact artifact) {
        super(context);
        this.myArtifactsStructureContext = artifactsStructureContext;
        this.myOriginalArtifact = artifactsStructureContext.getOriginalArtifact(artifact);
    }

    @Override
    public void check(ProjectStructureProblemsHolder problemsHolder) {
        ProjectModelExternalSource externalSource;
        ArtifactEditorImpl artifactEditor;
        Artifact artifact = this.myArtifactsStructureContext.getArtifactModel().getArtifactByOriginal(this.myOriginalArtifact);
        ArtifactProblemsHolderImpl artifactProblemsHolder = new ArtifactProblemsHolderImpl(this.myArtifactsStructureContext, this.myOriginalArtifact, problemsHolder);
        if (this.myArtifactsStructureContext instanceof ArtifactsStructureConfigurableContextImpl && (artifactEditor = ((ArtifactsStructureConfigurableContextImpl)this.myArtifactsStructureContext).getArtifactEditor(artifact)) != null && (artifactEditor.isModified() || this.isArtifactModified(artifact)) && (externalSource = artifact.getExternalSource()) != null) {
            String message2 = ModificationOfImportedModelWarningComponent.getWarningText("Artifact '" + artifact.getName() + "'", externalSource);
            artifactProblemsHolder.registerWarning(message2, "modification-of-imported-element", null, new ArtifactProblemQuickFix[0]);
        }
        artifact.getArtifactType().checkRootElement(this.myArtifactsStructureContext.getRootElement(this.myOriginalArtifact), artifact, (ArtifactProblemsHolder)artifactProblemsHolder);
    }

    private boolean isArtifactModified(Artifact artifact) {
        ModifiableArtifactModel modifiableModel = ((ArtifactsStructureConfigurableContextImpl)this.myArtifactsStructureContext).getActualModifiableModel();
        return modifiableModel != null && artifact != modifiableModel.getOriginalArtifact(artifact);
    }

    public Artifact getOriginalArtifact() {
        return this.myOriginalArtifact;
    }

    @Override
    public List<ProjectStructureElementUsage> getUsagesInElement() {
        Artifact artifact = this.myArtifactsStructureContext.getArtifactModel().getArtifactByOriginal(this.myOriginalArtifact);
        final ArrayList<ProjectStructureElementUsage> usages = new ArrayList<ProjectStructureElementUsage>();
        final CompositePackagingElement<?> rootElement = this.myArtifactsStructureContext.getRootElement(artifact);
        ArtifactUtil.processPackagingElements(rootElement, null, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> packagingElement, @NotNull PackagingElementPath path) {
                ProjectStructureElement element;
                if (packagingElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((element = ArtifactProjectStructureElement.getProjectStructureElementFor(packagingElement, ArtifactProjectStructureElement.this.myContext, ArtifactProjectStructureElement.this.myArtifactsStructureContext)) != null) {
                    usages.add(ArtifactProjectStructureElement.this.createUsage(packagingElement, element, path.getPathStringFrom("/", rootElement)));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "packagingElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactProjectStructureElement$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this.myArtifactsStructureContext, false, artifact.getArtifactType());
        return usages;
    }

    @Nullable
    public static ProjectStructureElement getProjectStructureElementFor(PackagingElement<?> packagingElement, StructureConfigurableContext context, ArtifactsStructureConfigurableContext artifactsStructureContext) {
        Facet facet;
        if (packagingElement instanceof ModulePackagingElement) {
            Module module = ((ModulePackagingElement)packagingElement).findModule(artifactsStructureContext);
            if (module != null) {
                return new ModuleProjectStructureElement(context, module);
            }
        } else if (packagingElement instanceof LibraryPackagingElement) {
            Library library = ((LibraryPackagingElement)packagingElement).findLibrary(artifactsStructureContext);
            if (library != null) {
                return new LibraryProjectStructureElement(context, library);
            }
        } else if (packagingElement instanceof ArtifactPackagingElement) {
            Artifact usedArtifact = ((ArtifactPackagingElement)packagingElement).findArtifact(artifactsStructureContext);
            if (usedArtifact != null) {
                return artifactsStructureContext.getOrCreateArtifactElement(usedArtifact);
            }
        } else if (packagingElement instanceof FacetBasedPackagingElement && (facet = ((FacetBasedPackagingElement)packagingElement).findFacet(artifactsStructureContext)) != null) {
            return new FacetProjectStructureElement(context, facet);
        }
        return null;
    }

    private UsageInArtifact createUsage(PackagingElement<?> packagingElement, ProjectStructureElement element, String parentPath) {
        return new UsageInArtifact(this.myOriginalArtifact, this.myArtifactsStructureContext, element, this, parentPath, packagingElement);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArtifactProjectStructureElement)) {
            return false;
        }
        return this.myOriginalArtifact.equals(((ArtifactProjectStructureElement)o).myOriginalArtifact);
    }

    @Override
    public int hashCode() {
        return this.myOriginalArtifact.hashCode();
    }

    @Override
    public String getPresentableName() {
        return this.getActualArtifactName();
    }

    @Override
    public String getTypeName() {
        return "Artifact";
    }

    @Override
    public String getId() {
        return "artifact:" + this.getActualArtifactName();
    }

    private String getActualArtifactName() {
        return this.myArtifactsStructureContext.getArtifactModel().getArtifactByOriginal(this.myOriginalArtifact).getName();
    }
}

