/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.ide.JavaUiBundle;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryAttachDialog;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ComparingJarFilesTask;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ConvertToRepositoryLibraryActionBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ConvertToRepositoryLibraryActionBaseKt;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibraryJarsDiffDialog;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b&\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0013H$J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00152\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\f0\u001dH$J\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u00112\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110!H\u0002J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertToRepositoryLibraryActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "context", "Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;", "(Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;)V", "getContext", "()Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "changeCoordinatesAndRetry", "mavenCoordinates", "Lorg/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor;", "library", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "detectOrSpecifyMavenCoordinates", "Lcom/intellij/openapi/roots/libraries/Library;", "downloadLibraryAndReplace", "getSelectedLibrary", "replaceByLibrary", "configuration", "Lcom/intellij/openapi/roots/libraries/NewLibraryConfiguration;", "replaceLibrary", "configureNewLibrary", "Lkotlin/Function1;", "Lcom/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryEditorBase;", "specifyMavenCoordinates", "detectedCoordinates", "", "update", "Companion", "intellij.java.ui"})
public abstract class ConvertToRepositoryLibraryActionBase
extends DumbAwareAction {
    @NotNull
    private final Project project;
    @NotNull
    private final StructureConfigurableContext context;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @Nullable
    protected abstract LibraryEx getSelectedLibrary();

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        LibraryEx library = this.getSelectedLibrary();
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(library != null && library.getKind() == null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        LibraryEx libraryEx = this.getSelectedLibrary();
        if (libraryEx == null) {
            return;
        }
        LibraryEx library = libraryEx;
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor = this.detectOrSpecifyMavenCoordinates((Library)library);
        if (jpsMavenRepositoryLibraryDescriptor == null) {
            return;
        }
        JpsMavenRepositoryLibraryDescriptor mavenCoordinates = jpsMavenRepositoryLibraryDescriptor;
        this.downloadLibraryAndReplace(library, mavenCoordinates);
    }

    /*
     * WARNING - void declaration
     */
    private final void downloadLibraryAndReplace(LibraryEx library, JpsMavenRepositoryLibraryDescriptor mavenCoordinates) {
        void $this$mapTo$iv$iv;
        File file;
        Object object;
        void $this$mapTo$iv$iv2;
        OrderRoot it;
        Iterable $this$filterTo$iv$iv;
        RepositoryLibraryProperties libraryProperties = new RepositoryLibraryProperties(mavenCoordinates.getGroupId(), mavenCoordinates.getArtifactId(), mavenCoordinates.getVersion(), mavenCoordinates.isIncludeTransitiveDependencies(), mavenCoordinates.getExcludedDependencies());
        boolean hasSources = RepositoryUtils.libraryHasSources((Library)library);
        boolean hasJavadoc = RepositoryUtils.libraryHasJavaDocs((Library)library);
        ConvertToRepositoryLibraryActionBaseKt.access$getLOG$p().debug("Resolving " + mavenCoordinates);
        Collection<OrderRoot> collection = JarRepositoryManager.loadDependenciesModal(this.project, libraryProperties, hasSources, hasJavadoc, null, null);
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"JarRepositoryManager.loa\u2026, hasJavadoc, null, null)");
        Collection<OrderRoot> roots = collection;
        Iterable $this$filter$iv = roots;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        VirtualFile[] destination$iv$iv = (VirtualFile[])new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (OrderRoot)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)OrderRootType.CLASSES)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (OrderRoot)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            file = VfsUtilCore.virtualToIoFile((VirtualFile)it.getFile());
            object.add(file);
        }
        List downloadedFiles = (List)destination$iv$iv;
        if (downloadedFiles.isEmpty()) {
            if (Messages.showYesNoDialog((String)JavaUiBundle.message("dialog.message.no.files.were.downloaded", new Object[0]), (String)JavaUiBundle.message("dialog.title.no.files.were.downloaded", new Object[0]), null) != 0) {
                return;
            }
            this.changeCoordinatesAndRetry(mavenCoordinates, library);
            return;
        }
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"library.getFiles(OrderRootType.CLASSES)");
        VirtualFile[] $this$map$iv2 = virtualFileArray;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
        boolean $i$f$mapTo2 = false;
        void var14_18 = $this$mapTo$iv$iv;
        int n = ((void)var14_18).length;
        for (int i = 0; i < n; ++i) {
            void it2;
            void item$iv$iv;
            void var18_26 = item$iv$iv = var14_18[i];
            object = destination$iv$iv2;
            boolean bl = false;
            file = VfsUtilCore.virtualToIoFile((VirtualFile)it2);
            object.add(file);
        }
        List libraryFiles = (List)destination$iv$iv2;
        ComparingJarFilesTask task = new ComparingJarFilesTask(this.project, downloadedFiles, libraryFiles);
        task.queue();
        if (task.getCancelled()) {
            return;
        }
        if (!task.getFilesAreTheSame()) {
            VirtualFile virtualFile = task.getLibraryFileToCompare();
            VirtualFile virtualFile2 = task.getDownloadedFileToCompare();
            String string = LibraryUtil.getPresentableName((Library)((Library)library));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LibraryUtil.getPresentableName(library)");
            LibraryJarsDiffDialog dialog = new LibraryJarsDiffDialog(virtualFile, virtualFile2, mavenCoordinates, string, this.project);
            dialog.show();
            task.deleteTemporaryFiles();
            switch (dialog.getExitCode()) {
                case 1: {
                    return;
                }
                case 2: {
                    this.changeCoordinatesAndRetry(mavenCoordinates, library);
                    return;
                }
            }
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(this, library, roots, libraryProperties){
            final /* synthetic */ ConvertToRepositoryLibraryActionBase this$0;
            final /* synthetic */ LibraryEx $library;
            final /* synthetic */ Collection $roots;
            final /* synthetic */ RepositoryLibraryProperties $libraryProperties;

            public final void run() {
                Library library = (Library)this.$library;
                String string = this.$library.getName();
                if (string == null) {
                    string = "";
                }
                ConvertToRepositoryLibraryActionBase.access$replaceByLibrary(this.this$0, library, new NewLibraryConfiguration(this, string, RepositoryLibraryType.getInstance(), (LibraryProperties)this.$libraryProperties){
                    final /* synthetic */ downloadLibraryAndReplace.1 this$0;

                    public void addRoots(@NotNull LibraryEditor editor) {
                        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                        editor.addRoots(this.this$0.$roots);
                    }
                    {
                        this.this$0 = $outer;
                        super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                    }
                });
            }
            {
                this.this$0 = convertToRepositoryLibraryActionBase;
                this.$library = libraryEx;
                this.$roots = collection;
                this.$libraryProperties = repositoryLibraryProperties;
            }
        });
    }

    private final void changeCoordinatesAndRetry(JpsMavenRepositoryLibraryDescriptor mavenCoordinates, LibraryEx library) {
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor = this.specifyMavenCoordinates(CollectionsKt.listOf((Object)mavenCoordinates));
        if (jpsMavenRepositoryLibraryDescriptor == null) {
            return;
        }
        JpsMavenRepositoryLibraryDescriptor coordinates = jpsMavenRepositoryLibraryDescriptor;
        ApplicationManager.getApplication().invokeLater(new Runnable(this, library, coordinates){
            final /* synthetic */ ConvertToRepositoryLibraryActionBase this$0;
            final /* synthetic */ LibraryEx $library;
            final /* synthetic */ JpsMavenRepositoryLibraryDescriptor $coordinates;

            public final void run() {
                ConvertToRepositoryLibraryActionBase.access$downloadLibraryAndReplace(this.this$0, this.$library, this.$coordinates);
            }
            {
                this.this$0 = convertToRepositoryLibraryActionBase;
                this.$library = libraryEx;
                this.$coordinates = jpsMavenRepositoryLibraryDescriptor;
            }
        });
    }

    private final JpsMavenRepositoryLibraryDescriptor detectOrSpecifyMavenCoordinates(Library library) {
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"library.getFiles(OrderRootType.CLASSES)");
        List<JpsMavenRepositoryLibraryDescriptor> detectedCoordinates = Companion.detectMavenCoordinates(virtualFileArray);
        ConvertToRepositoryLibraryActionBaseKt.access$getLOG$p().debug("Maven coordinates for " + LibraryUtil.getPresentableName((Library)library) + " JARs: " + detectedCoordinates);
        if (detectedCoordinates.size() == 1) {
            return detectedCoordinates.get(0);
        }
        String string = detectedCoordinates.isEmpty() ? JavaUiBundle.message("dialog.message.cannot.detect.maven.coordinates", new Object[0]) : JavaUiBundle.message("dialog.message.multiple.maven.coordinates", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (detectedCoordinates.\u2026tiple.maven.coordinates\")");
        String message2 = string;
        if (Messages.showYesNoDialog((Project)this.project, (String)(message2 + ". " + JavaUiBundle.message("dialog.message.do.you.want", new Object[0])), (String)JavaUiBundle.message("dialog.title.cannot.detect.maven.coordinates", new Object[0]), null) != 0) {
            return null;
        }
        return this.specifyMavenCoordinates(detectedCoordinates);
    }

    private final JpsMavenRepositoryLibraryDescriptor specifyMavenCoordinates(List<? extends JpsMavenRepositoryLibraryDescriptor> detectedCoordinates) {
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor = (JpsMavenRepositoryLibraryDescriptor)CollectionsKt.firstOrNull(detectedCoordinates);
        RepositoryAttachDialog dialog = new RepositoryAttachDialog(this.project, jpsMavenRepositoryLibraryDescriptor != null ? jpsMavenRepositoryLibraryDescriptor.getMavenId() : null, RepositoryAttachDialog.Mode.SEARCH);
        if (!dialog.showAndGet()) {
            return null;
        }
        return dialog.getSelectedLibraryDescriptor();
    }

    private final void replaceByLibrary(Library library, NewLibraryConfiguration configuration) {
        String[] annotationUrls = library.getUrls(AnnotationOrderRootType.getInstance());
        ProjectStructureConfigurable projectStructureConfigurable = ProjectStructureConfigurable.getInstance(this.project);
        Object[] objectArray = library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"library.getFiles(OrderRootType.CLASSES)");
        Object[] objectArray2 = library.getFiles(OrderRootType.SOURCES);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"library.getFiles(OrderRootType.SOURCES)");
        projectStructureConfigurable.registerObsoleteLibraryRoots(ArraysKt.asList((Object[])ArraysKt.plus((Object[])objectArray, (Object[])objectArray2)));
        this.replaceLibrary(library, (Function1<? super LibraryEditorBase, Unit>)((Function1)new Function1<LibraryEditorBase, Unit>(configuration, annotationUrls){
            final /* synthetic */ NewLibraryConfiguration $configuration;
            final /* synthetic */ String[] $annotationUrls;

            public final void invoke(@NotNull LibraryEditorBase editor) {
                Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                editor.setProperties(this.$configuration.getProperties());
                editor.removeAllRoots();
                this.$configuration.addRoots((LibraryEditor)editor);
                Intrinsics.checkExpressionValueIsNotNull((Object)this.$annotationUrls, (String)"annotationUrls");
                String[] $this$forEach$iv = this.$annotationUrls;
                boolean $i$f$forEach = false;
                String[] stringArray = $this$forEach$iv;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String element$iv;
                    String it = element$iv = stringArray[i];
                    boolean bl = false;
                    editor.addRoot(it, AnnotationOrderRootType.getInstance());
                }
            }
            {
                this.$configuration = newLibraryConfiguration;
                this.$annotationUrls = stringArray;
                super(1);
            }
        }));
    }

    protected abstract void replaceLibrary(@NotNull Library var1, @NotNull Function1<? super LibraryEditorBase, Unit> var2);

    @NotNull
    protected final StructureConfigurableContext getContext() {
        return this.context;
    }

    public ConvertToRepositoryLibraryActionBase(@NotNull StructureConfigurableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(JavaUiBundle.messagePointer("action.text.convert.to.repository.library", new Object[0]), JavaUiBundle.messagePointer("action.description.convert.to.repository.library", new Object[0]), null);
        this.context = context;
        Project project = this.context.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"context.project");
        this.project = project;
    }

    public static final /* synthetic */ void access$replaceByLibrary(ConvertToRepositoryLibraryActionBase $this, Library library, NewLibraryConfiguration configuration) {
        $this.replaceByLibrary(library, configuration);
    }

    public static final /* synthetic */ void access$downloadLibraryAndReplace(ConvertToRepositoryLibraryActionBase $this, LibraryEx library, JpsMavenRepositoryLibraryDescriptor mavenCoordinates) {
        $this.downloadLibraryAndReplace(library, mavenCoordinates);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertToRepositoryLibraryActionBase$Companion;", "", "()V", "detectMavenCoordinates", "", "Lorg/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor;", "libraryRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/util/List;", "parsePomProperties", "virtualFile", "intellij.java.ui"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<JpsMavenRepositoryLibraryDescriptor> detectMavenCoordinates(@NotNull VirtualFile[] libraryRoots) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)libraryRoots, (String)"libraryRoots");
            VirtualFile[] $this$flatMap$iv = libraryRoots;
            boolean $i$f$flatMap = false;
            VirtualFile[] virtualFileArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            void var7_7 = $this$flatMapTo$iv$iv;
            int n = ((void)var7_7).length;
            for (int i = 0; i < n; ++i) {
                void $this$mapNotNullTo$iv$iv;
                List list;
                JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor;
                Iterable $this$flatMapTo$iv$iv2;
                Collection destination$iv$iv2;
                void element$iv$iv;
                void root = element$iv$iv = var7_7[i];
                boolean bl = false;
                VirtualFile[] virtualFileArray2 = root.findFileByRelativePath("META-INF/maven");
                if (virtualFileArray2 != null && (virtualFileArray2 = virtualFileArray2.getChildren()) != null) {
                    VirtualFile[] $this$flatMap$iv2 = virtualFileArray2;
                    boolean $i$f$flatMap2 = false;
                    VirtualFile[] virtualFileArray3 = $this$flatMap$iv2;
                    destination$iv$iv2 = new ArrayList();
                    boolean $i$f$flatMapTo2 = false;
                    Iterable iterable = $this$flatMapTo$iv$iv2;
                    int n2 = ((Iterable)iterable).length;
                    for (int j = 0; j < n2; ++j) {
                        List list2;
                        Iterable element$iv$iv2;
                        Iterable groupDir = element$iv$iv2 = iterable[j];
                        boolean bl2 = false;
                        Iterable iterable2 = groupDir;
                        Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"groupDir");
                        if (iterable2.getChildren() != null) {
                            void $this$mapNotNullTo$iv$iv2;
                            JpsMavenRepositoryLibraryDescriptor $this$mapNotNull$iv;
                            boolean $i$f$mapNotNull = false;
                            jpsMavenRepositoryLibraryDescriptor = $this$mapNotNull$iv;
                            Collection destination$iv$iv3 = new ArrayList();
                            boolean $i$f$mapNotNullTo = false;
                            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                            boolean $i$f$forEach = false;
                            void var31_33 = $this$forEach$iv$iv$iv;
                            int n3 = ((void)var31_33).length;
                            for (int k = 0; k < n3; ++k) {
                                VirtualFile virtualFile;
                                void element$iv$iv$iv;
                                void element$iv$iv3 = element$iv$iv$iv = var31_33[k];
                                boolean bl3 = false;
                                void artifactDir = element$iv$iv3;
                                boolean bl4 = false;
                                if (artifactDir.findChild("pom.properties") == null) continue;
                                boolean bl5 = false;
                                boolean bl6 = false;
                                VirtualFile it$iv$iv = virtualFile;
                                boolean bl7 = false;
                                destination$iv$iv3.add(it$iv$iv);
                            }
                            list2 = (List)destination$iv$iv3;
                        } else {
                            list2 = CollectionsKt.emptyList();
                        }
                        Iterable list$iv$iv = list2;
                        CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                    }
                    list = (List)destination$iv$iv2;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List pomPropertiesFiles = list;
                Iterable $this$mapNotNull$iv = pomPropertiesFiles;
                boolean $i$f$mapNotNull = false;
                $this$flatMapTo$iv$iv2 = $this$mapNotNull$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv$iv;
                    Object element$iv$iv4 = element$iv$iv$iv = iterator.next();
                    boolean bl8 = false;
                    VirtualFile it = (VirtualFile)element$iv$iv4;
                    boolean bl9 = false;
                    VirtualFile virtualFile = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
                    if (Companion.parsePomProperties(virtualFile) == null) continue;
                    boolean bl10 = false;
                    boolean bl11 = false;
                    JpsMavenRepositoryLibraryDescriptor it$iv$iv = jpsMavenRepositoryLibraryDescriptor;
                    boolean bl12 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final JpsMavenRepositoryLibraryDescriptor parsePomProperties(VirtualFile virtualFile) {
            Properties properties = new Properties();
            try {
                Closeable closeable = virtualFile.getInputStream();
                boolean bl = false;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl2 = false;
                    properties.load(it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                return null;
            }
            String groupId = properties.getProperty("groupId");
            String artifactId = properties.getProperty("artifactId");
            String version = properties.getProperty("version");
            return groupId != null && artifactId != null && version != null ? new JpsMavenRepositoryLibraryDescriptor(groupId, artifactId, version) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

