/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactAdapter;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.impl.artifacts.ArtifactPointerImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ArtifactPointerManagerImpl
extends ArtifactPointerManager {
    private final Map<String, ArtifactPointerImpl> myUnresolvedPointers = new HashMap<String, ArtifactPointerImpl>();
    private final Map<Artifact, ArtifactPointerImpl> myPointers = new HashMap<Artifact, ArtifactPointerImpl>();
    private ArtifactManager myArtifactManager;

    public ArtifactPointerManagerImpl(Project project) {
        project.getMessageBus().connect().subscribe(ArtifactManager.TOPIC, (Object)new ArtifactAdapter(){

            public void artifactRemoved(@NotNull Artifact artifact) {
                if (artifact == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArtifactPointerManagerImpl.this.disposePointer(artifact);
            }

            public void artifactAdded(@NotNull Artifact artifact) {
                ArtifactPointerImpl unresolved;
                ArtifactPointerImpl pointer;
                if (artifact == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((pointer = (ArtifactPointerImpl)ArtifactPointerManagerImpl.this.myPointers.get(artifact)) != null) {
                    pointer.setName(artifact.getName());
                }
                if ((unresolved = (ArtifactPointerImpl)ArtifactPointerManagerImpl.this.myUnresolvedPointers.remove(artifact.getName())) != null) {
                    unresolved.setArtifact(artifact);
                    if (pointer == null) {
                        ArtifactPointerManagerImpl.this.myPointers.put(artifact, unresolved);
                    }
                }
            }

            public void artifactChanged(@NotNull Artifact artifact, @NotNull String oldName) {
                if (artifact == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (oldName == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.artifactAdded(artifact);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "artifact";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldName";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/packaging/impl/artifacts/ArtifactPointerManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "artifactRemoved";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "artifactAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "artifactChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void setArtifactManager(ArtifactManager artifactManager) {
        this.myArtifactManager = artifactManager;
    }

    private void disposePointer(Artifact artifact) {
        ArtifactPointerImpl pointer = this.myPointers.remove(artifact);
        if (pointer != null) {
            pointer.setArtifact(null);
            this.myUnresolvedPointers.put(pointer.getArtifactName(), pointer);
        }
    }

    public ArtifactPointer createPointer(@NotNull String name2) {
        Artifact artifact;
        if (name2 == null) {
            ArtifactPointerManagerImpl.$$$reportNull$$$0(0);
        }
        if (this.myArtifactManager != null && (artifact = this.myArtifactManager.findArtifact(name2)) != null) {
            return this.createPointer(artifact);
        }
        ArtifactPointerImpl pointer = this.myUnresolvedPointers.get(name2);
        if (pointer == null) {
            pointer = new ArtifactPointerImpl(name2);
            this.myUnresolvedPointers.put(name2, pointer);
        }
        return pointer;
    }

    public ArtifactPointer createPointer(@NotNull Artifact artifact) {
        ArtifactPointerImpl pointer;
        if (artifact == null) {
            ArtifactPointerManagerImpl.$$$reportNull$$$0(1);
        }
        if ((pointer = this.myPointers.get(artifact)) == null) {
            pointer = this.myUnresolvedPointers.get(artifact.getName());
            if (pointer != null) {
                pointer.setArtifact(artifact);
            } else {
                pointer = new ArtifactPointerImpl(artifact);
            }
            this.myPointers.put(artifact, pointer);
        }
        return pointer;
    }

    public ArtifactPointer createPointer(@NotNull Artifact artifact, @NotNull ArtifactModel artifactModel) {
        if (artifact == null) {
            ArtifactPointerManagerImpl.$$$reportNull$$$0(2);
        }
        if (artifactModel == null) {
            ArtifactPointerManagerImpl.$$$reportNull$$$0(3);
        }
        return this.createPointer(artifactModel.getOriginalArtifact(artifact));
    }

    public void disposePointers(List<? extends Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            this.disposePointer(artifact);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "artifact";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "artifactModel";
                break;
            }
        }
        objectArray[1] = "com/intellij/packaging/impl/artifacts/ArtifactPointerManagerImpl";
        objectArray[2] = "createPointer";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

