/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileOrDirectoryCopyPackagingElement<T extends FileOrDirectoryCopyPackagingElement>
extends PackagingElement<T> {
    @NonNls
    public static final String PATH_ATTRIBUTE = "path";
    protected String myFilePath;

    public FileOrDirectoryCopyPackagingElement(PackagingElementType type2) {
        super(type2);
    }

    protected FileOrDirectoryCopyPackagingElement(PackagingElementType type2, String filePath) {
        super(type2);
        this.myFilePath = filePath;
    }

    @Nullable
    public VirtualFile findFile() {
        return LocalFileSystem.getInstance().findFileByPath(this.myFilePath);
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            FileOrDirectoryCopyPackagingElement.$$$reportNull$$$0(0);
        }
        return element instanceof FileOrDirectoryCopyPackagingElement && this.myFilePath != null && this.myFilePath.equals(((FileOrDirectoryCopyPackagingElement)element).getFilePath());
    }

    @Attribute(value="path")
    public String getFilePath() {
        return this.myFilePath;
    }

    public void setFilePath(String filePath) {
        this.myFilePath = filePath;
    }

    @NotNull
    public PackagingElementOutputKind getFilesKind(PackagingElementResolvingContext context) {
        VirtualFile file = this.findFile();
        if (file == null) {
            PackagingElementOutputKind packagingElementOutputKind = PackagingElementOutputKind.OTHER;
            if (packagingElementOutputKind == null) {
                FileOrDirectoryCopyPackagingElement.$$$reportNull$$$0(1);
            }
            return packagingElementOutputKind;
        }
        if (file.isDirectory() && file.isInLocalFileSystem()) {
            boolean containsDirectories = false;
            boolean containsJars = false;
            for (VirtualFile child : file.getChildren()) {
                if (child.isDirectory() && child.isInLocalFileSystem()) {
                    containsDirectories |= true;
                } else {
                    containsJars |= FileOrDirectoryCopyPackagingElement.isJar(child);
                }
                if (containsDirectories && containsJars) break;
            }
            return new PackagingElementOutputKind(containsDirectories, containsJars);
        }
        PackagingElementOutputKind packagingElementOutputKind = FileOrDirectoryCopyPackagingElement.isJar(file) ? PackagingElementOutputKind.JAR_FILES : PackagingElementOutputKind.OTHER;
        if (packagingElementOutputKind == null) {
            FileOrDirectoryCopyPackagingElement.$$$reportNull$$$0(2);
        }
        return packagingElementOutputKind;
    }

    private static boolean isJar(VirtualFile file) {
        String ext = file.getExtension();
        return ext != null && ext.equalsIgnoreCase("jar");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/FileOrDirectoryCopyPackagingElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/FileOrDirectoryCopyPackagingElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEqualTo";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

