/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.LibraryElementType;
import com.intellij.packaging.impl.ui.LibraryElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryPackagingElement
extends ComplexPackagingElement<LibraryPackagingElement> {
    @NonNls
    public static final String LIBRARY_NAME_ATTRIBUTE = "name";
    @NonNls
    public static final String MODULE_NAME_ATTRIBUTE = "module-name";
    @NonNls
    public static final String LIBRARY_LEVEL_ATTRIBUTE = "level";
    private String myLevel;
    private String myLibraryName;
    private String myModuleName;

    public LibraryPackagingElement() {
        super((PackagingElementType)LibraryElementType.LIBRARY_ELEMENT_TYPE);
    }

    public LibraryPackagingElement(String level, String libraryName, String moduleName) {
        super((PackagingElementType)LibraryElementType.LIBRARY_ELEMENT_TYPE);
        this.myLevel = level;
        this.myLibraryName = libraryName;
        this.myModuleName = moduleName;
    }

    public List<? extends PackagingElement<?>> getSubstitution(@NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType) {
        Library library;
        if (context == null) {
            LibraryPackagingElement.$$$reportNull$$$0(0);
        }
        if (artifactType == null) {
            LibraryPackagingElement.$$$reportNull$$$0(1);
        }
        if ((library = this.findLibrary(context)) != null) {
            VirtualFile[] files = library.getFiles(OrderRootType.CLASSES);
            ArrayList<FileCopyPackagingElement> elements = new ArrayList<FileCopyPackagingElement>();
            for (VirtualFile file : files) {
                String localPath = PathUtil.getLocalPath((VirtualFile)file);
                if (localPath == null) continue;
                String path = FileUtil.toSystemIndependentName((String)localPath);
                elements.add((FileCopyPackagingElement)(file.isDirectory() && file.isInLocalFileSystem() ? new DirectoryCopyPackagingElement(path) : new FileCopyPackagingElement(path)));
            }
            return elements;
        }
        return null;
    }

    @NotNull
    public PackagingElementOutputKind getFilesKind(PackagingElementResolvingContext context) {
        Library library = this.findLibrary(context);
        PackagingElementOutputKind packagingElementOutputKind = library != null ? LibraryPackagingElement.getKindForLibrary(library) : PackagingElementOutputKind.OTHER;
        if (packagingElementOutputKind == null) {
            LibraryPackagingElement.$$$reportNull$$$0(2);
        }
        return packagingElementOutputKind;
    }

    @NotNull
    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            LibraryPackagingElement.$$$reportNull$$$0(3);
        }
        return new LibraryElementPresentation(this.myLibraryName, this.myLevel, this.myModuleName, this.findLibrary((PackagingElementResolvingContext)context), context);
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            LibraryPackagingElement.$$$reportNull$$$0(4);
        }
        if (!(element instanceof LibraryPackagingElement)) {
            return false;
        }
        LibraryPackagingElement packagingElement = (LibraryPackagingElement)element;
        return this.myLevel != null && this.myLibraryName != null && this.myLevel.equals(packagingElement.getLevel()) && this.myLibraryName.equals(packagingElement.getLibraryName()) && Comparing.equal((String)this.myModuleName, (String)packagingElement.getModuleName());
    }

    public LibraryPackagingElement getState() {
        return this;
    }

    public void loadState(@NotNull LibraryPackagingElement state) {
        if (state == null) {
            LibraryPackagingElement.$$$reportNull$$$0(5);
        }
        this.myLevel = state.getLevel();
        this.myLibraryName = state.getLibraryName();
        this.myModuleName = state.getModuleName();
    }

    @Attribute(value="level")
    public String getLevel() {
        return this.myLevel;
    }

    public void setLevel(String level) {
        this.myLevel = level;
    }

    @Attribute(value="name")
    public String getLibraryName() {
        return this.myLibraryName;
    }

    public void setLibraryName(String libraryName) {
        this.myLibraryName = libraryName;
    }

    @Attribute(value="module-name")
    public String getModuleName() {
        return this.myModuleName;
    }

    public void setModuleName(String moduleName) {
        this.myModuleName = moduleName;
    }

    public String toString() {
        return "lib:" + this.myLibraryName + "(" + (this.myModuleName != null ? "module " + this.myModuleName : this.myLevel) + ")";
    }

    @Nullable
    public Library findLibrary(@NotNull PackagingElementResolvingContext context) {
        if (context == null) {
            LibraryPackagingElement.$$$reportNull$$$0(6);
        }
        if (this.myModuleName == null) {
            return context.findLibrary(this.myLevel, this.myLibraryName);
        }
        ModulesProvider modulesProvider = context.getModulesProvider();
        Module module = modulesProvider.getModule(this.myModuleName);
        if (module != null) {
            for (OrderEntry entry : modulesProvider.getRootModel(module).getOrderEntries()) {
                String libraryName;
                LibraryOrderEntry libraryEntry;
                if (!(entry instanceof LibraryOrderEntry) || !(libraryEntry = (LibraryOrderEntry)entry).isModuleLevel() || (libraryName = libraryEntry.getLibraryName()) == null || !libraryName.equals(this.myLibraryName)) continue;
                return libraryEntry.getLibrary();
            }
        }
        return null;
    }

    public static PackagingElementOutputKind getKindForLibrary(Library library) {
        boolean containsDirectories = false;
        boolean containsJars = false;
        for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
            if (file.isInLocalFileSystem()) {
                containsDirectories = true;
                continue;
            }
            containsJars = true;
        }
        return new PackagingElementOutputKind(containsDirectories, containsJars);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/LibraryPackagingElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/LibraryPackagingElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitution";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEqualTo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

