/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.tree.java.PsiMethodCallExpressionImpl;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDiamondTypeImpl
extends PsiDiamondType {
    private static final Logger LOG = Logger.getInstance(PsiDiamondTypeImpl.class);
    private final PsiManager myManager;
    private final PsiTypeElement myTypeElement;

    public PsiDiamondTypeImpl(PsiManager manager, PsiTypeElement psiTypeElement) {
        this.myManager = manager;
        this.myTypeElement = psiTypeElement;
    }

    @NotNull
    public String getPresentableText() {
        return "";
    }

    @NotNull
    public String getCanonicalText() {
        return "";
    }

    @NotNull
    public String getInternalCanonicalText() {
        return "Diamond Type";
    }

    public boolean isValid() {
        return false;
    }

    public boolean equalsToText(@NotNull @NonNls String text2) {
        if (text2 == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(0);
        }
        return text2.isEmpty();
    }

    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(1);
        }
        return (A)visitor2.visitDiamondType((PsiDiamondType)this);
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myManager.getProject());
        if (globalSearchScope == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(2);
        }
        return globalSearchScope;
    }

    public PsiType @NotNull [] getSuperTypes() {
        PsiType[] psiTypeArray = new PsiType[]{PsiDiamondTypeImpl.getJavaLangObject((PsiManager)this.myManager, (GlobalSearchScope)this.getResolveScope())};
        if (psiTypeArray == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(3);
        }
        return psiTypeArray;
    }

    public PsiDiamondType.DiamondInferenceResult resolveInferredTypes() {
        PsiNewExpression newExpression = this.getNewExpression();
        if (newExpression == null) {
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        return PsiDiamondTypeImpl.resolveInferredTypes(newExpression);
    }

    private PsiNewExpression getNewExpression() {
        PsiElement typeElementWithDiamondTypeArgument = this.myTypeElement.getParent();
        return (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)typeElementWithDiamondTypeArgument, PsiNewExpression.class, (boolean)true, (Class[])new Class[]{PsiTypeElement.class});
    }

    @Nullable
    public JavaResolveResult getStaticFactory() {
        PsiNewExpression newExpression = this.getNewExpression();
        return newExpression != null ? PsiDiamondTypeImpl.getStaticFactory(newExpression, (PsiElement)newExpression) : null;
    }

    public static PsiDiamondType.DiamondInferenceResult resolveInferredTypes(PsiNewExpression newExpression) {
        return PsiDiamondTypeImpl.resolveInferredTypes(newExpression, (PsiElement)newExpression);
    }

    public static PsiDiamondType.DiamondInferenceResult resolveInferredTypes(PsiNewExpression newExpression, PsiElement context) {
        PsiElement resolve2;
        PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
        if (anonymousClass != null && !PsiUtil.isLanguageLevel9OrHigher((PsiElement)newExpression) && (resolve2 = anonymousClass.getBaseClassReference().resolve()) instanceof PsiClass) {
            return PsiDiamondType.DiamondInferenceResult.ANONYMOUS_INNER_RESULT;
        }
        PsiReferenceParameterList referenceParameterList = (PsiReferenceParameterList)PsiTreeUtil.getChildOfType((PsiElement)newExpression, PsiReferenceParameterList.class);
        if (referenceParameterList != null && referenceParameterList.getTypeParameterElements().length > 0) {
            return PsiDiamondType.DiamondInferenceResult.EXPLICIT_CONSTRUCTOR_TYPE_ARGS;
        }
        PsiDiamondType.DiamondInferenceResult inferenceResult = PsiDiamondTypeImpl.resolveInferredTypesNoCheck(newExpression, context);
        if (anonymousClass != null && PsiUtil.isLanguageLevel9OrHigher((PsiElement)newExpression)) {
            InferredAnonymousTypeVisitor anonymousTypeVisitor = new InferredAnonymousTypeVisitor(context);
            for (PsiType type2 : inferenceResult.getInferredTypes()) {
                Boolean accepted = (Boolean)type2.accept((PsiTypeVisitor)anonymousTypeVisitor);
                if (accepted == null || accepted.booleanValue()) continue;
                return PsiDiamondType.DiamondInferenceResult.ANONYMOUS_INNER_RESULT;
            }
        }
        return inferenceResult;
    }

    private static JavaResolveResult getStaticFactory(PsiNewExpression newExpression, PsiElement context) {
        return context == newExpression && !MethodCandidateInfo.isOverloadCheck((PsiElement)newExpression.getArgumentList()) ? (JavaResolveResult)CachedValuesManager.getCachedValue((PsiElement)newExpression, () -> new CachedValueProvider.Result((Object)PsiDiamondTypeImpl.getStaticFactoryCandidateInfo(newExpression, (PsiElement)newExpression), new Object[]{PsiModificationTracker.MODIFICATION_COUNT})) : PsiDiamondTypeImpl.getStaticFactoryCandidateInfo(newExpression, context);
    }

    public static PsiDiamondType.DiamondInferenceResult resolveInferredTypesNoCheck(PsiNewExpression newExpression, PsiElement context) {
        JavaResolveResult staticFactoryCandidateInfo = PsiDiamondTypeImpl.getStaticFactory(newExpression, context);
        if (staticFactoryCandidateInfo == null) {
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        if (!(staticFactoryCandidateInfo instanceof MethodCandidateInfo)) {
            return PsiDiamondType.DiamondInferenceResult.UNRESOLVED_CONSTRUCTOR;
        }
        LOG.assertTrue(!PsiMethodCallExpressionImpl.doWePerformGenericMethodOverloadResolutionNow((PsiCall)newExpression, PsiUtil.getLanguageLevel((PsiElement)newExpression)), (Object)"diamond evaluation during overload resolution");
        PsiSubstitutor substitutor = staticFactoryCandidateInfo.getSubstitutor();
        final String errorMessage = ((MethodCandidateInfo)staticFactoryCandidateInfo).getInferenceErrorMessageAssumeAlreadyComputed();
        if (errorMessage == null && ((MethodCandidateInfo)staticFactoryCandidateInfo).isErased()) {
            return PsiDiamondType.DiamondInferenceResult.RAW_RESULT;
        }
        PsiMethod staticFactory = ((MethodCandidateInfo)staticFactoryCandidateInfo).getElement();
        PsiTypeParameter[] parameters2 = staticFactory.getTypeParameters();
        PsiElement staticFactoryContext = staticFactory.getContext();
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)staticFactoryContext, PsiClass.class, (boolean)false);
        if (psiClass == null) {
            LOG.error("failed for expression:" + newExpression);
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        PsiTypeParameter[] classParameters = psiClass.getTypeParameters();
        PsiJavaCodeReferenceElement classOrAnonymousClassReference = newExpression.getClassOrAnonymousClassReference();
        LOG.assertTrue(classOrAnonymousClassReference != null);
        PsiDiamondType.DiamondInferenceResult result = new PsiDiamondType.DiamondInferenceResult(classOrAnonymousClassReference.getReferenceName() + "<>"){

            public String getErrorMessage() {
                return errorMessage != null ? PsiDiamondType.DiamondInferenceResult.NULL_RESULT.getErrorMessage() : super.getErrorMessage();
            }
        };
        if (errorMessage == null && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)staticFactory, (PsiSubstitutor)substitutor)) {
            if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)newExpression) && PsiUtil.skipParenthesizedExprUp((PsiElement)newExpression.getParent()) instanceof PsiExpressionList) {
                for (PsiTypeParameter ignored : parameters2) {
                    result.addInferredType((PsiType)PsiType.getJavaLangObject((PsiManager)newExpression.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)newExpression.getProject())));
                }
            }
            return result;
        }
        block1: for (PsiTypeParameter parameter2 : parameters2) {
            for (PsiTypeParameter classParameter : classParameters) {
                if (!Comparing.strEqual((String)classParameter.getName(), (String)parameter2.getName())) continue;
                result.addInferredType(substitutor.substitute(parameter2));
                continue block1;
            }
        }
        return result;
    }

    private static JavaResolveResult getStaticFactoryCandidateInfo(@NotNull PsiNewExpression newExpression, PsiElement context) {
        if (newExpression == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(4);
        }
        return (JavaResolveResult)ourDiamondGuard.doPreventingRecursion((Object)context, false, () -> {
            PsiMethod staticFactory;
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return null;
            }
            PsiFile containingFile = argumentList.getContainingFile();
            if (containingFile == null) {
                return null;
            }
            JavaMethodsConflictResolver resolver = new JavaMethodsConflictResolver((PsiElement)argumentList, null, PsiUtil.getLanguageLevel((PsiElement)containingFile), containingFile);
            List<CandidateInfo> results = PsiDiamondTypeImpl.collectStaticFactories(newExpression);
            CandidateInfo result = results != null ? resolver.resolveConflict(new ArrayList<CandidateInfo>(results)) : null;
            PsiMethod psiMethod = staticFactory = result != null ? (PsiMethod)result.getElement() : null;
            if (staticFactory == null) {
                return JavaResolveResult.EMPTY;
            }
            MethodCandidateInfo staticFactoryCandidateInfo = PsiDiamondTypeImpl.createMethodCandidate((MethodCandidateInfo)result, context, false, argumentList);
            if (!staticFactory.isVarArgs()) {
                return staticFactoryCandidateInfo;
            }
            ArrayList<CandidateInfo> conflicts = new ArrayList<CandidateInfo>();
            conflicts.add((CandidateInfo)staticFactoryCandidateInfo);
            conflicts.add((CandidateInfo)PsiDiamondTypeImpl.createMethodCandidate((MethodCandidateInfo)result, context, true, argumentList));
            return resolver.resolveConflict(conflicts);
        });
    }

    @Nullable
    public static List<CandidateInfo> collectStaticFactories(PsiNewExpression newExpression) {
        return (List)CachedValuesManager.getCachedValue((PsiElement)newExpression, () -> new CachedValueProvider.Result(PsiDiamondTypeImpl.collectStaticFactoriesInner(newExpression), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static List<CandidateInfo> collectStaticFactoriesInner(PsiNewExpression newExpression) {
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        final PsiClass psiClass = PsiDiamondTypeImpl.findClass(newExpression);
        if (psiClass == null) {
            return null;
        }
        ArrayList candidates = new ArrayList();
        PsiMethod[] constructors = psiClass.getConstructors();
        if (constructors.length == 0) {
            constructors = new PsiMethod[]{null};
        }
        PsiFile containingFile = argumentList.getContainingFile();
        MethodCandidatesProcessor processor = new MethodCandidatesProcessor((PsiElement)argumentList, containingFile, new PsiConflictResolver[0], candidates){

            @Override
            protected boolean isAccepted(@NotNull PsiMethod candidate) {
                if (candidate == null) {
                    2.$$$reportNull$$$0(0);
                }
                return true;
            }

            @Override
            protected PsiClass getContainingClass(@NotNull PsiMethod method) {
                if (method == null) {
                    2.$$$reportNull$$$0(1);
                }
                return psiClass;
            }

            @Override
            protected boolean acceptVarargs() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "candidate";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/PsiDiamondTypeImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isAccepted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getContainingClass";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processor.setArgumentList(argumentList);
        for (PsiMethod constructor : constructors) {
            PsiTypeParameter[] params = PsiDiamondTypeImpl.getAllTypeParams((PsiTypeParameterListOwner)constructor, psiClass);
            PsiMethod staticFactory = PsiDiamondTypeImpl.generateStaticFactory(constructor, psiClass, params, newExpression.getClassReference());
            if (staticFactory == null) continue;
            processor.add((PsiElement)staticFactory, PsiSubstitutor.EMPTY);
        }
        return processor.getResults();
    }

    @Nullable
    private static PsiClass findClass(PsiNewExpression newExpression) {
        PsiJavaCodeReferenceElement classReference2 = newExpression.getClassOrAnonymousClassReference();
        if (classReference2 != null) {
            String text2 = classReference2.getReferenceName();
            if (text2 != null) {
                PsiClass aClass;
                Project project = newExpression.getProject();
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
                PsiResolveHelper resolveHelper = facade.getResolveHelper();
                PsiExpression newExpressionQualifier = newExpression.getQualifier();
                PsiElement qualifierElement = classReference2.getQualifier();
                String qualifier = qualifierElement != null ? qualifierElement.getText() : "";
                String qualifiedName = StringUtil.getQualifiedName((String)qualifier, (String)text2);
                if (newExpressionQualifier != null && (aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)newExpressionQualifier.getType())) != null) {
                    return aClass.findInnerClassByName(qualifiedName, false);
                }
                return resolveHelper.resolveReferencedClass(qualifiedName, (PsiElement)newExpression);
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static PsiMethod generateStaticFactory(@Nullable PsiMethod constructor, PsiClass containingClass, PsiTypeParameter[] params, PsiJavaCodeReferenceElement reference) {
        PsiElement qualifier;
        StringBuilder buf = new StringBuilder();
        String modifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)(constructor != null ? constructor.getModifierList() : containingClass.getModifierList()));
        if (!"packageLocal".equals(modifier)) {
            buf.append(modifier);
            buf.append(" ");
        }
        buf.append("static ");
        buf.append("<");
        UniqueNameGenerator generator = new UniqueNameGenerator();
        buf.append(StringUtil.join((Object[])params, psiTypeParameter -> {
            Object[] extendsListTypes;
            String extendsList = "";
            if (psiTypeParameter.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && (extendsListTypes = psiTypeParameter.getExtendsListTypes()).length > 0) {
                Function canonicalTypePresentationFun = type2 -> type2.getCanonicalText();
                extendsList = " extends " + StringUtil.join((Object[])extendsListTypes, (Function)canonicalTypePresentationFun, (String)"&");
            }
            return generator.generateUniqueName(psiTypeParameter.getName()) + extendsList;
        }, (String)", "));
        buf.append(">");
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)containingClass.getProject());
        String qualifiedName = containingClass.getQualifiedName();
        PsiElement psiElement = qualifier = reference != null ? reference.getQualifier() : null;
        if (qualifier instanceof PsiJavaCodeReferenceElement) {
            JavaResolveResult resolveResult = ((PsiJavaCodeReferenceElement)qualifier).advancedResolve(false);
            PsiElement element = resolveResult.getElement();
            if (element instanceof PsiClass) {
                String outerClassSubstitutedQName = elementFactory.createType((PsiClass)element, resolveResult.getSubstitutor()).getInternalCanonicalText();
                qualifiedName = outerClassSubstitutedQName + "." + containingClass.getName();
            }
        } else if (reference != null && qualifier == null && containingClass.getContainingClass() != null) {
            qualifiedName = null;
        }
        buf.append(qualifiedName != null ? qualifiedName : containingClass.getName());
        Object[] parameters2 = containingClass.getTypeParameters();
        buf.append("<");
        buf.append(StringUtil.join((Object[])parameters2, psiTypeParameter -> psiTypeParameter.getName(), (String)", "));
        buf.append("> ");
        String staticFactoryName = "staticFactory";
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)containingClass.getProject());
        staticFactoryName = styleManager.suggestUniqueVariableName(staticFactoryName, (PsiElement)containingClass, false);
        buf.append(staticFactoryName);
        if (constructor == null) {
            buf.append("()");
        } else {
            buf.append("(").append(StringUtil.join((Object[])constructor.getParameterList().getParameters(), (Function)new Function<PsiParameter, String>(){
                int myIdx;

                public String fun(PsiParameter psiParameter) {
                    return psiParameter.getType().getCanonicalText() + " p" + this.myIdx++;
                }
            }, (String)",")).append(")");
            Object[] types = constructor.getThrowsList().getReferencedTypes();
            if (types.length > 0) {
                buf.append("throws ").append(StringUtil.join((Object[])types, type2 -> type2.getCanonicalText(), (String)", "));
            }
        }
        buf.append("{}");
        try {
            return elementFactory.createMethodFromText(buf.toString(), (PsiElement)(constructor != null ? constructor : containingClass));
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    private static PsiTypeParameter @NotNull [] getAllTypeParams(PsiTypeParameterListOwner listOwner, PsiClass containingClass) {
        LinkedHashSet params = new LinkedHashSet();
        Collections.addAll(params, containingClass.getTypeParameters());
        if (listOwner != null) {
            Collections.addAll(params, listOwner.getTypeParameters());
        }
        PsiTypeParameter[] psiTypeParameterArray = params.toArray(PsiTypeParameter.EMPTY_ARRAY);
        if (psiTypeParameterArray == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(5);
        }
        return psiTypeParameterArray;
    }

    private static MethodCandidateInfo createMethodCandidate(@NotNull MethodCandidateInfo staticFactoryMethod, final PsiElement parent, final boolean varargs, final PsiExpressionList argumentList) {
        if (staticFactoryMethod == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(6);
        }
        return new MethodCandidateInfo((PsiElement)staticFactoryMethod.getElement(), PsiSubstitutor.EMPTY, !staticFactoryMethod.isAccessible(), false, (PsiElement)argumentList, parent, null, null){
            private PsiType[] myExpressionTypes;

            public boolean isVarargs() {
                return varargs;
            }

            protected PsiElement getParent() {
                return parent;
            }

            public PsiType[] getArgumentTypes() {
                if (this.myExpressionTypes == null) {
                    PsiType[] expressionTypes = argumentList.getExpressionTypes();
                    if (MethodCandidateInfo.isOverloadCheck()) {
                        return expressionTypes;
                    }
                    this.myExpressionTypes = expressionTypes;
                }
                return this.myExpressionTypes;
            }
        };
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass psiClass) {
        PsiMethod[] constructors;
        if (psiClass == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(7);
        }
        for (PsiMethod method : constructors = psiClass.getConstructors()) {
            if (!method.getParameterList().isEmpty()) continue;
            return true;
        }
        return constructors.length == 0;
    }

    public static boolean haveConstructorsGenericsParameters(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiDiamondTypeImpl.$$$reportNull$$$0(8);
        }
        for (final PsiMethod method : psiClass.getConstructors()) {
            for (PsiParameter parameter2 : method.getParameterList().getParameters()) {
                PsiType type2 = parameter2.getType();
                Boolean accept = (Boolean)type2.accept((PsiTypeVisitor)new PsiTypeVisitor<Boolean>(){

                    public Boolean visitArrayType(@NotNull PsiArrayType arrayType) {
                        if (arrayType == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
                    }

                    public Boolean visitClassType(@NotNull PsiClassType classType) {
                        if (classType == null) {
                            5.$$$reportNull$$$0(1);
                        }
                        for (PsiType psiType : classType.getParameters()) {
                            Boolean typeParamFound;
                            if (psiType == null || (typeParamFound = (Boolean)psiType.accept((PsiTypeVisitor)this)) == null || !typeParamFound.booleanValue()) continue;
                            return true;
                        }
                        PsiClass aClass = PsiUtil.resolveClassInType((PsiType)classType);
                        return aClass instanceof PsiTypeParameter && ((PsiTypeParameter)aClass).getOwner() == method;
                    }

                    public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                        PsiType bound;
                        if (wildcardType == null) {
                            5.$$$reportNull$$$0(2);
                        }
                        if ((bound = wildcardType.getBound()) == null) {
                            return false;
                        }
                        return (Boolean)bound.accept((PsiTypeVisitor)this);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "arrayType";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "classType";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "wildcardType";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/psi/PsiDiamondTypeImpl$5";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitArrayType";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitClassType";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitWildcardType";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                if (accept == null || !accept.booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiDiamondTypeImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticFactoryMethod";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiDiamondTypeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTypeParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStaticFactoryCandidateInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMethodCandidate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasDefaultConstructor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "haveConstructorsGenericsParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InferredAnonymousTypeVisitor
    extends PsiTypeVisitor<Boolean> {
        private final PsiElement myExpression;

        InferredAnonymousTypeVisitor(PsiElement expression2) {
            this.myExpression = expression2;
        }

        @Nullable
        public Boolean visitType(@NotNull PsiType type2) {
            if (type2 == null) {
                InferredAnonymousTypeVisitor.$$$reportNull$$$0(0);
            }
            return true;
        }

        @Nullable
        public Boolean visitCapturedWildcardType(@NotNull PsiCapturedWildcardType capturedWildcardType) {
            if (capturedWildcardType == null) {
                InferredAnonymousTypeVisitor.$$$reportNull$$$0(1);
            }
            return false;
        }

        @Nullable
        public Boolean visitIntersectionType(@NotNull PsiIntersectionType intersectionType) {
            if (intersectionType == null) {
                InferredAnonymousTypeVisitor.$$$reportNull$$$0(2);
            }
            return false;
        }

        @Nullable
        public Boolean visitClassType(@NotNull PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult;
            PsiClass psiClass;
            if (classType == null) {
                InferredAnonymousTypeVisitor.$$$reportNull$$$0(3);
            }
            if ((psiClass = (resolveResult = classType.resolveGenerics()).getElement()) != null) {
                if (psiClass instanceof PsiTypeParameter && TypeConversionUtil.isFreshVariable((PsiTypeParameter)((PsiTypeParameter)psiClass))) {
                    return false;
                }
                if (!PsiUtil.isAccessible((PsiMember)psiClass, (PsiElement)this.myExpression, null)) {
                    return false;
                }
                for (PsiType psiType : resolveResult.getSubstitutor().getSubstitutionMap().values()) {
                    Boolean accepted = psiType != null ? (Boolean)psiType.accept((PsiTypeVisitor)this) : null;
                    if (accepted == null || accepted.booleanValue()) continue;
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "capturedWildcardType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "intersectionType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/PsiDiamondTypeImpl$InferredAnonymousTypeVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCapturedWildcardType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIntersectionType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

