/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.codeStyle.properties.CodeStylePropertiesUtil;
import com.intellij.application.options.codeStyle.properties.ValueListPropertyAccessor;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPackageEntryTableAccessor
extends ValueListPropertyAccessor<PackageEntryTable> {
    public static final char BLANK_LINE_CHAR = '|';
    public static final String STATIC_PREFIX = "$";

    public JavaPackageEntryTableAccessor(@NotNull Object object, @NotNull Field field) {
        if (object == null) {
            JavaPackageEntryTableAccessor.$$$reportNull$$$0(0);
        }
        if (field == null) {
            JavaPackageEntryTableAccessor.$$$reportNull$$$0(1);
        }
        super(object, field);
    }

    @Nullable
    protected PackageEntryTable fromExternal(@NotNull List<String> strList) {
        if (strList == null) {
            JavaPackageEntryTableAccessor.$$$reportNull$$$0(2);
        }
        PackageEntryTable entryTable = new PackageEntryTable();
        for (String strValue : strList) {
            String parseStr = strValue.trim();
            if (parseStr.length() > 0 && parseStr.charAt(0) == '|') {
                for (int i = 0; i < parseStr.length(); ++i) {
                    if (parseStr.charAt(i) != '|') continue;
                    entryTable.addEntry(PackageEntry.BLANK_LINE_ENTRY);
                }
                continue;
            }
            boolean isStatic = false;
            boolean isWithSubpackages = false;
            if (parseStr.startsWith(STATIC_PREFIX)) {
                parseStr = parseStr.substring(STATIC_PREFIX.length()).trim();
                isStatic = true;
            }
            if ((parseStr = parseStr.trim()).endsWith("**")) {
                isWithSubpackages = true;
                parseStr = parseStr.substring(0, parseStr.length() - 1);
            }
            if ("*".equals(parseStr)) {
                entryTable.addEntry(isStatic ? PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY : PackageEntry.ALL_OTHER_IMPORTS_ENTRY);
                continue;
            }
            entryTable.addEntry(new PackageEntry(isStatic, parseStr, isWithSubpackages));
        }
        return entryTable;
    }

    @NotNull
    protected List<String> toExternal(@NotNull PackageEntryTable value2) {
        if (value2 == null) {
            JavaPackageEntryTableAccessor.$$$reportNull$$$0(3);
        }
        ArrayList<String> externalList = new ArrayList<String>();
        for (PackageEntry entry : value2.getEntries()) {
            if (entry == PackageEntry.BLANK_LINE_ENTRY) {
                externalList.add(String.valueOf('|'));
                continue;
            }
            StringBuilder entryBuilder = new StringBuilder();
            if (entry.isStatic()) {
                entryBuilder.append(STATIC_PREFIX);
            }
            if (entry.isSpecial()) {
                entryBuilder.append("*");
            } else {
                entryBuilder.append(entry.getPackageName()).append(".*");
                if (entry.isWithSubpackages()) {
                    entryBuilder.append("*");
                }
            }
            externalList.add(entryBuilder.toString());
        }
        ArrayList<String> arrayList = externalList;
        if (arrayList == null) {
            JavaPackageEntryTableAccessor.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    protected String valueToString(@NotNull List<String> value2) {
        if (value2 == null) {
            JavaPackageEntryTableAccessor.$$$reportNull$$$0(5);
        }
        return CodeStylePropertiesUtil.toCommaSeparatedString(value2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strList";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/JavaPackageEntryTableAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/JavaPackageEntryTableAccessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toExternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromExternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toExternal";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "valueToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

