/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public class PsiMethodCallFilter
implements ElementFilter {
    @NonNls
    private final String myClassName;
    @NonNls
    private final Set<String> myMethodNames;

    public PsiMethodCallFilter(@NonNls String className2, String ... methodNames) {
        this.myClassName = className2;
        this.myMethodNames = ContainerUtil.set((Object[])methodNames);
    }

    public boolean isAcceptable(Object element, PsiElement context) {
        if (element instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)element;
            if (!this.myMethodNames.contains(callExpression.getMethodExpression().getReferenceName())) {
                return false;
            }
            PsiMethod psiMethod = callExpression.resolveMethod();
            return psiMethod != null && this.myMethodNames.contains(psiMethod.getName()) && InheritanceUtil.isInheritor((PsiClass)psiMethod.getContainingClass(), (String)this.myClassName);
        }
        return false;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return PsiMethodCallExpression.class.isAssignableFrom(hintClass);
    }

    @NonNls
    public String toString() {
        return "methodcall(" + this.myClassName + "." + this.myMethodNames + ")";
    }
}

