/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.impl.java.FunExprOccurrence;
import com.intellij.psi.impl.java.ReferenceChainLink;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionKey;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.FileLocalResolver;
import com.intellij.psi.impl.source.JavaFileElementType;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveLighterASTNodeWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentFileContent;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.StringSearcher;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFunctionalExpressionIndex
extends FileBasedIndexExtension<FunctionalExpressionKey, Map<Integer, FunExprOccurrence>> {
    public static final ID<FunctionalExpressionKey, Map<Integer, FunExprOccurrence>> INDEX_ID = ID.create((String)"java.fun.expression");
    private static final KeyDescriptor<FunctionalExpressionKey> KEY_DESCRIPTOR = new KeyDescriptor<FunctionalExpressionKey>(){

        public int getHashCode(FunctionalExpressionKey value2) {
            return value2.hashCode();
        }

        public boolean isEqual(FunctionalExpressionKey val1, FunctionalExpressionKey val2) {
            return val1.equals(val2);
        }

        public void save(@NotNull DataOutput out, FunctionalExpressionKey value2) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            value2.serializeKey(out);
        }

        public FunctionalExpressionKey read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            return FunctionalExpressionKey.deserializeKey(in);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    private static List<ReferenceChainLink> createCallChain(FileLocalResolver resolver, @Nullable LighterASTNode expr2) {
        ArrayList<ReferenceChainLink> chain = new ArrayList<ReferenceChainLink>();
        while (expr2 != null) {
            if (expr2.getTokenType() == JavaElementType.PARENTH_EXPRESSION) {
                expr2 = LightTreeUtil.firstChildOfType((LighterAST)resolver.getLightTree(), (LighterASTNode)expr2, (TokenSet)ElementType.EXPRESSION_BIT_SET);
                continue;
            }
            if (expr2.getTokenType() == JavaElementType.TYPE_CAST_EXPRESSION) {
                String typeName = resolver.getShortClassTypeName(expr2);
                ContainerUtil.addIfNotNull(chain, (Object)(typeName != null ? new ReferenceChainLink(typeName, false, -1) : null));
                return JavaFunctionalExpressionIndex.reversedChain(chain);
            }
            boolean isCall = expr2.getTokenType() == JavaElementType.METHOD_CALL_EXPRESSION || expr2.getTokenType() == JavaElementType.NEW_EXPRESSION;
            String referenceName = JavaFunctionalExpressionIndex.getReferencedMemberName(resolver.getLightTree(), expr2, isCall);
            if (referenceName == null) {
                return JavaFunctionalExpressionIndex.reversedChain(chain);
            }
            LighterASTNode qualifier = JavaFunctionalExpressionIndex.getQualifier(resolver.getLightTree(), expr2, isCall);
            if (qualifier == null) {
                ContainerUtil.addIfNotNull(chain, (Object)JavaFunctionalExpressionIndex.createChainStart(resolver, expr2, isCall, referenceName));
                return JavaFunctionalExpressionIndex.reversedChain(chain);
            }
            chain.add(new ReferenceChainLink(referenceName, isCall, JavaFunctionalExpressionIndex.getArgCount(resolver.getLightTree(), expr2)));
            expr2 = qualifier;
        }
        return JavaFunctionalExpressionIndex.reversedChain(chain);
    }

    @NotNull
    private static List<ReferenceChainLink> reversedChain(List<ReferenceChainLink> chain) {
        Collections.reverse(chain);
        List<ReferenceChainLink> list = chain;
        if (list == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static int getArgCount(LighterAST tree, LighterASTNode expr2) {
        List<LighterASTNode> args = JavaLightTreeUtil.getArgList(tree, expr2);
        return args == null ? -1 : args.size();
    }

    @Nullable
    private static LighterASTNode getQualifier(LighterAST tree, LighterASTNode expr2, boolean isCall) {
        LighterASTNode qualifier = (LighterASTNode)tree.getChildren(expr2).get(0);
        if (isCall) {
            List children = tree.getChildren(qualifier);
            qualifier = children.isEmpty() ? null : (LighterASTNode)children.get(0);
        }
        return qualifier != null && ElementType.EXPRESSION_BIT_SET.contains(qualifier.getTokenType()) ? qualifier : null;
    }

    @Nullable
    private static String getReferencedMemberName(LighterAST tree, LighterASTNode expr2, boolean isCall) {
        if (isCall) {
            return JavaFunctionalExpressionIndex.getCalledMethodName(tree, expr2);
        }
        if (expr2.getTokenType() == JavaElementType.REFERENCE_EXPRESSION) {
            return JavaLightTreeUtil.getNameIdentifierText(tree, expr2);
        }
        return null;
    }

    @Nullable
    private static ReferenceChainLink createChainStart(FileLocalResolver resolver, LighterASTNode expr2, boolean isCall, String referenceName) {
        if (!isCall) {
            FileLocalResolver.LightResolveResult result = resolver.resolveLocally(expr2);
            if (result == FileLocalResolver.LightResolveResult.UNKNOWN) {
                return null;
            }
            LighterASTNode target = result.getTarget();
            if (target != null) {
                String typeName = resolver.getShortClassTypeName(target);
                return typeName != null ? new ReferenceChainLink(typeName, false, -1) : null;
            }
        }
        return new ReferenceChainLink(referenceName, isCall, JavaFunctionalExpressionIndex.getArgCount(resolver.getLightTree(), expr2));
    }

    @NotNull
    private static String calcExprType(LighterASTNode funExpr, FileLocalResolver resolver) {
        LighterAST tree = resolver.getLightTree();
        LighterASTNode scope = JavaFunctionalExpressionIndex.skipExpressionsUp(tree, funExpr, TokenSet.create((IElementType[])new IElementType[]{JavaElementType.LOCAL_VARIABLE, JavaElementType.FIELD, JavaElementType.TYPE_CAST_EXPRESSION, JavaElementType.RETURN_STATEMENT, JavaElementType.ASSIGNMENT_EXPRESSION, JavaElementType.ARRAY_INITIALIZER_EXPRESSION}));
        int arrayDepth = 0;
        while (scope != null && scope.getTokenType() == JavaElementType.ARRAY_INITIALIZER_EXPRESSION) {
            scope = tree.getParent(scope);
            ++arrayDepth;
        }
        if (scope != null) {
            if (scope.getTokenType() == JavaElementType.ASSIGNMENT_EXPRESSION) {
                LighterASTNode lValue = JavaFunctionalExpressionIndex.findExpressionChild(scope, tree);
                scope = lValue == null ? null : resolver.resolveLocally(lValue).getTarget();
            } else if (scope.getTokenType() == JavaElementType.RETURN_STATEMENT) {
                scope = LightTreeUtil.getParentOfType((LighterAST)tree, (LighterASTNode)scope, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JavaElementType.METHOD}), (TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{ElementType.MEMBER_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{JavaElementType.LAMBDA_EXPRESSION})}));
            } else if (scope.getTokenType() == JavaElementType.NEW_EXPRESSION) {
                assert (arrayDepth > 0);
                if (arrayDepth != LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)scope, (IElementType)JavaTokenType.LBRACKET).size()) {
                    return "";
                }
                LighterASTNode typeRef = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)scope, (IElementType)JavaElementType.JAVA_CODE_REFERENCE);
                String refName = JavaLightTreeUtil.getNameIdentifierText(tree, typeRef);
                String string = StringUtil.notNullize((String)refName);
                if (string == null) {
                    JavaFunctionalExpressionIndex.$$$reportNull$$$0(1);
                }
                return string;
            }
        }
        String string = StringUtil.notNullize(scope == null ? null : resolver.getShortClassTypeName(scope, arrayDepth));
        if (string == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static int getArgIndex(List<? extends LighterASTNode> args, LighterASTNode expr2) {
        for (int i = 0; i < args.size(); ++i) {
            if (args.get(i).getEndOffset() < expr2.getEndOffset()) continue;
            return i;
        }
        return -1;
    }

    private static FunctionalExpressionKey.CoarseType calcReturnType(final LighterAST tree, LighterASTNode funExpr) {
        if (funExpr.getTokenType() == JavaElementType.METHOD_REF_EXPRESSION) {
            return FunctionalExpressionKey.CoarseType.UNKNOWN;
        }
        LighterASTNode block = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)funExpr, (IElementType)JavaElementType.CODE_BLOCK);
        if (block == null) {
            LighterASTNode expr2 = JavaFunctionalExpressionIndex.findExpressionChild(funExpr, tree);
            return JavaFunctionalExpressionIndex.isBooleanExpression(tree, expr2) ? FunctionalExpressionKey.CoarseType.BOOLEAN : FunctionalExpressionKey.CoarseType.UNKNOWN;
        }
        final Ref returnsSomething = Ref.create(null);
        final AtomicBoolean isBoolean = new AtomicBoolean();
        final AtomicBoolean hasStatements = new AtomicBoolean();
        new RecursiveLighterASTNodeWalkingVisitor(tree){

            public void visitNode(@NotNull LighterASTNode element) {
                IElementType type2;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((type2 = element.getTokenType()) == JavaElementType.LAMBDA_EXPRESSION || ElementType.MEMBER_BIT_SET.contains(type2)) {
                    return;
                }
                if (type2 == JavaElementType.RETURN_STATEMENT) {
                    LighterASTNode expr2 = JavaFunctionalExpressionIndex.findExpressionChild(element, tree);
                    returnsSomething.set((Object)(expr2 != null ? 1 : 0));
                    if (JavaFunctionalExpressionIndex.isBooleanExpression(tree, expr2)) {
                        isBoolean.set(true);
                    }
                    return;
                }
                if (type2 == JavaElementType.EXPRESSION_STATEMENT) {
                    hasStatements.set(true);
                }
                super.visitNode(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex$2", "visitNode"));
            }
        }.visitNode(block);
        if (isBoolean.get()) {
            return FunctionalExpressionKey.CoarseType.BOOLEAN;
        }
        if (returnsSomething.isNull()) {
            return hasStatements.get() ? FunctionalExpressionKey.CoarseType.VOID : FunctionalExpressionKey.CoarseType.UNKNOWN;
        }
        return (Boolean)returnsSomething.get() != false ? FunctionalExpressionKey.CoarseType.NON_VOID : FunctionalExpressionKey.CoarseType.VOID;
    }

    @Nullable
    private static LighterASTNode findExpressionChild(@NotNull LighterASTNode element, LighterAST tree) {
        if (element == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(3);
        }
        return LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)element, (TokenSet)ElementType.EXPRESSION_BIT_SET);
    }

    private static boolean isBooleanExpression(LighterAST tree, @Nullable LighterASTNode expr2) {
        if (expr2 == null) {
            return false;
        }
        IElementType type2 = expr2.getTokenType();
        if (type2 == JavaElementType.LITERAL_EXPRESSION) {
            IElementType child = ((LighterASTNode)tree.getChildren(expr2).get(0)).getTokenType();
            return child == JavaTokenType.TRUE_KEYWORD || child == JavaTokenType.FALSE_KEYWORD;
        }
        if (type2 == JavaElementType.POLYADIC_EXPRESSION || type2 == JavaElementType.BINARY_EXPRESSION) {
            return LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)expr2, (TokenSet)PsiBinaryExpression.BOOLEAN_OPERATION_TOKENS) != null;
        }
        if (type2 == JavaElementType.PREFIX_EXPRESSION) {
            return ((LighterASTNode)tree.getChildren(expr2).get(0)).getTokenType() == JavaTokenType.EXCL;
        }
        if (type2 == JavaElementType.PARENTH_EXPRESSION) {
            return JavaFunctionalExpressionIndex.isBooleanExpression(tree, JavaFunctionalExpressionIndex.findExpressionChild(expr2, tree));
        }
        if (type2 == JavaElementType.CONDITIONAL_EXPRESSION) {
            List children = LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)expr2, (TokenSet)ElementType.EXPRESSION_BIT_SET);
            return children.size() == 3 && (JavaFunctionalExpressionIndex.isBooleanExpression(tree, (LighterASTNode)children.get(1)) || JavaFunctionalExpressionIndex.isBooleanExpression(tree, (LighterASTNode)children.get(2)));
        }
        return false;
    }

    private static int getFunExprParameterCount(LighterAST tree, LighterASTNode funExpr) {
        if (funExpr.getTokenType() == JavaElementType.METHOD_REF_EXPRESSION) {
            return -1;
        }
        assert (funExpr.getTokenType() == JavaElementType.LAMBDA_EXPRESSION);
        LighterASTNode paramList = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)funExpr, (IElementType)JavaElementType.PARAMETER_LIST);
        assert (paramList != null);
        return LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)paramList, (TokenSet)Constants.PARAMETER_BIT_SET).size();
    }

    @Nullable
    private static String getCalledMethodName(LighterAST tree, LighterASTNode call) {
        if (call.getTokenType() == JavaElementType.NEW_EXPRESSION) {
            LighterASTNode anonClass = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)call, (IElementType)JavaElementType.ANONYMOUS_CLASS);
            LighterASTNode ref = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)(anonClass != null ? anonClass : call), (IElementType)JavaElementType.JAVA_CODE_REFERENCE);
            return ref == null ? null : JavaLightTreeUtil.getNameIdentifierText(tree, ref);
        }
        LighterASTNode methodExpr = (LighterASTNode)tree.getChildren(call).get(0);
        if (LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)methodExpr, (IElementType)JavaTokenType.SUPER_KEYWORD) != null) {
            return JavaFunctionalExpressionIndex.getSuperClassName(tree, call);
        }
        if (LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)methodExpr, (IElementType)JavaTokenType.THIS_KEYWORD) != null) {
            return JavaLightTreeUtil.getNameIdentifierText(tree, JavaFunctionalExpressionIndex.findClass(tree, call));
        }
        return JavaLightTreeUtil.getNameIdentifierText(tree, methodExpr);
    }

    @Nullable
    private static String getSuperClassName(LighterAST tree, LighterASTNode call) {
        LighterASTNode aClass = JavaFunctionalExpressionIndex.findClass(tree, call);
        return JavaFunctionalExpressionIndex.getReferenceName(tree, LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)aClass, (IElementType)JavaElementType.EXTENDS_LIST));
    }

    @Nullable
    private static String getReferenceName(LighterAST tree, LighterASTNode refParent) {
        return JavaLightTreeUtil.getNameIdentifierText(tree, LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)refParent, (IElementType)JavaElementType.JAVA_CODE_REFERENCE));
    }

    @Nullable
    private static LighterASTNode getContainingCall(LighterAST tree, LighterASTNode node) {
        LighterASTNode expressionList = JavaFunctionalExpressionIndex.skipExpressionsUp(tree, node, TokenSet.create((IElementType[])new IElementType[]{JavaElementType.EXPRESSION_LIST}));
        if (expressionList != null) {
            LighterASTNode parent = tree.getParent(expressionList);
            if (parent != null && parent.getTokenType() == JavaElementType.ANONYMOUS_CLASS) {
                parent = tree.getParent(parent);
            }
            if (parent != null && (parent.getTokenType() == JavaElementType.METHOD_CALL_EXPRESSION || parent.getTokenType() == JavaElementType.NEW_EXPRESSION)) {
                return parent;
            }
        }
        return null;
    }

    private static LighterASTNode skipExpressionsUp(LighterAST tree, @NotNull LighterASTNode node, TokenSet types) {
        if (node == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(4);
        }
        node = tree.getParent(node);
        while (node != null) {
            IElementType type2 = node.getTokenType();
            if (types.contains(type2)) {
                return node;
            }
            if (type2 != JavaElementType.PARENTH_EXPRESSION && type2 != JavaElementType.CONDITIONAL_EXPRESSION) {
                return null;
            }
            node = tree.getParent(node);
        }
        return null;
    }

    private static LighterASTNode findClass(LighterAST tree, LighterASTNode node) {
        return (LighterASTNode)JBIterable.generate((Object)node, arg_0 -> ((LighterAST)tree).getParent(arg_0)).find(n -> n.getTokenType() == JavaElementType.CLASS);
    }

    @NotNull
    public KeyDescriptor<FunctionalExpressionKey> getKeyDescriptor() {
        KeyDescriptor<FunctionalExpressionKey> keyDescriptor = KEY_DESCRIPTOR;
        if (keyDescriptor == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(5);
        }
        return keyDescriptor;
    }

    public int getVersion() {
        return 4;
    }

    @NotNull
    public ID<FunctionalExpressionKey, Map<Integer, FunExprOccurrence>> getName() {
        ID<FunctionalExpressionKey, Map<Integer, FunExprOccurrence>> iD = INDEX_ID;
        if (iD == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(6);
        }
        return iD;
    }

    public boolean hasSnapshotMapping() {
        return true;
    }

    @NotNull
    public DataIndexer<FunctionalExpressionKey, Map<Integer, FunExprOccurrence>, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            CharSequence text2 = inputData.getContentAsText();
            int[] offsets = ArrayUtil.mergeArrays((int[])new StringSearcher("->", true, true).findAllOccurrences(text2), (int[])new StringSearcher("::", true, true).findAllOccurrences(text2));
            if (offsets.length == 0) {
                return Collections.emptyMap();
            }
            HashMap result = new HashMap();
            LighterAST tree = ((PsiDependentFileContent)inputData).getLighterAST();
            FileLocalResolver resolver = new FileLocalResolver(tree);
            LightTreeUtil.processLeavesAtOffsets((int[])offsets, (LighterAST)tree, (leaf, offset) -> {
                LighterASTNode element = tree.getParent((LighterASTNode)leaf);
                if (element == null) {
                    return;
                }
                if (element.getTokenType() == JavaElementType.METHOD_REF_EXPRESSION || element.getTokenType() == JavaElementType.LAMBDA_EXPRESSION) {
                    FunctionalExpressionKey key2 = new FunctionalExpressionKey(JavaFunctionalExpressionIndex.getFunExprParameterCount(tree, element), JavaFunctionalExpressionIndex.calcReturnType(tree, element), JavaFunctionalExpressionIndex.calcExprType(element, resolver));
                    Map map2 = result.computeIfAbsent(key2, __ -> new LinkedHashMap());
                    map2.put(element.getStartOffset(), JavaFunctionalExpressionIndex.createOccurrence(element, resolver));
                }
            });
            return result;
        };
        if (dataIndexer == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(7);
        }
        return dataIndexer;
    }

    @NotNull
    private static FunExprOccurrence createOccurrence(@NotNull LighterASTNode funExpr, FileLocalResolver resolver) {
        LighterASTNode assignment;
        LighterASTNode containingCall;
        LighterAST tree;
        List<LighterASTNode> args;
        if (funExpr == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(8);
        }
        int argIndex = (args = JavaLightTreeUtil.getArgList(tree = resolver.getLightTree(), containingCall = JavaFunctionalExpressionIndex.getContainingCall(tree, funExpr))) == null ? -1 : JavaFunctionalExpressionIndex.getArgIndex(args, funExpr);
        LighterASTNode chainExpr = containingCall;
        if (chainExpr == null && (assignment = JavaFunctionalExpressionIndex.skipExpressionsUp(tree, funExpr, TokenSet.create((IElementType[])new IElementType[]{JavaElementType.ASSIGNMENT_EXPRESSION}))) != null) {
            chainExpr = JavaFunctionalExpressionIndex.findExpressionChild(assignment, tree);
        }
        return new FunExprOccurrence(argIndex, JavaFunctionalExpressionIndex.createCallChain(resolver, chainExpr));
    }

    @NotNull
    public DataExternalizer<Map<Integer, FunExprOccurrence>> getValueExternalizer() {
        return new DataExternalizer<Map<Integer, FunExprOccurrence>>(){

            public void save(@NotNull DataOutput out, Map<Integer, FunExprOccurrence> value2) throws IOException {
                if (out == null) {
                    3.$$$reportNull$$$0(0);
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.size());
                for (Map.Entry<Integer, FunExprOccurrence> entry : value2.entrySet()) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)entry.getKey());
                    entry.getValue().serialize(out);
                }
            }

            public Map<Integer, FunExprOccurrence> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    3.$$$reportNull$$$0(1);
                }
                int length = DataInputOutputUtil.readINT((DataInput)in);
                LinkedHashMap<Integer, FunExprOccurrence> map2 = new LinkedHashMap<Integer, FunExprOccurrence>();
                for (int i = 0; i < length; ++i) {
                    int offset = DataInputOutputUtil.readINT((DataInput)in);
                    map2.put(offset, FunExprOccurrence.deserialize(in));
                }
                return map2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    4.$$$reportNull$$$0(0);
                }
                return super.acceptInput(file) && JavaFileElementType.isInSourceContent(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex$4", "acceptInput"));
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funExpr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "reversedChain";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calcExprType";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findExpressionChild";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "skipExpressionsUp";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createOccurrence";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

