/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.search.ApproximateResolver;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceChainLink {
    final String referenceName;
    final boolean isCall;
    final int argCount;
    private static final Key<Set<ReferenceChainLink>> EXPENSIVE_LINKS = Key.create((String)"EXPENSIVE_CHAIN_LINKS");

    public ReferenceChainLink(@NotNull String referenceName, boolean isCall, int argCount) {
        if (referenceName == null) {
            ReferenceChainLink.$$$reportNull$$$0(0);
        }
        this.referenceName = referenceName;
        this.isCall = isCall;
        this.argCount = argCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReferenceChainLink)) {
            return false;
        }
        ReferenceChainLink link = (ReferenceChainLink)o;
        if (this.isCall != link.isCall) {
            return false;
        }
        if (this.argCount != link.argCount) {
            return false;
        }
        return this.referenceName.equals(link.referenceName);
    }

    public int hashCode() {
        int result = this.referenceName.hashCode();
        result = 31 * result + (this.isCall ? 1 : 0);
        result = 31 * result + this.argCount;
        return result;
    }

    public String toString() {
        return this.referenceName + (this.isCall ? "(" + this.argCount + ")" : "");
    }

    @Nullable
    List<PsiMember> getGlobalMembers(VirtualFile placeFile, Project project) {
        PsiPackage pkg;
        if (this.isExpensive(project)) {
            return null;
        }
        GlobalSearchScope scope = ResolveScopeManager.getInstance((Project)project).getDefaultResolveScope(placeFile);
        if (!this.isCall && (pkg = JavaPsiFacade.getInstance((Project)project).findPackage(this.referenceName)) != null && pkg.getDirectories(scope).length > 0) {
            return null;
        }
        Map cache = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ConcurrentMap map2 = ConcurrentFactoryMap.createMap(pair2 -> ((ReferenceChainLink)pair2.first).calcMembersUnlessTooMany((GlobalSearchScope)pair2.second));
            return CachedValueProvider.Result.create((Object)map2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        List candidates = (List)cache.get(Pair.create((Object)this, (Object)scope));
        if (candidates == null) {
            this.markExpensive(project);
            return null;
        }
        return ContainerUtil.filter((Collection)candidates, candidate -> ReferenceChainLink.canBeAccessible(placeFile, candidate));
    }

    @Nullable
    private List<PsiMember> calcMembersUnlessTooMany(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            ReferenceChainLink.$$$reportNull$$$0(1);
        }
        ArrayList<PsiMember> candidates = new ArrayList<PsiMember>();
        AtomicInteger count = new AtomicInteger();
        Processor processor = member -> {
            if (!(member instanceof PsiMethod) || ApproximateResolver.canHaveArgCount((PsiMethod)member, this.argCount)) {
                candidates.add((PsiMember)member);
            }
            return count.incrementAndGet() < 42;
        };
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)scope.getProject());
        if (this.isCall ? !cache.processMethodsWithName(this.referenceName, processor, scope, null) : !cache.processFieldsWithName(this.referenceName, processor, scope, null)) {
            return null;
        }
        if (!cache.processClassesWithName(this.referenceName, processor, scope, null)) {
            return null;
        }
        return candidates;
    }

    private static boolean canBeAccessible(VirtualFile placeFile, PsiMember member) {
        return !member.hasModifierProperty("private") || placeFile.equals(PsiUtilCore.getVirtualFile((PsiElement)member));
    }

    private boolean isExpensive(Project project) {
        Set expensive = (Set)project.getUserData(EXPENSIVE_LINKS);
        return expensive != null && expensive.contains(this);
    }

    private void markExpensive(Project project) {
        Set expensive = (Set)project.getUserData(EXPENSIVE_LINKS);
        if (expensive == null) {
            expensive = ContainerUtil.newConcurrentSet();
            project.putUserData(EXPENSIVE_LINKS, (Object)expensive);
        }
        expensive.add(this);
    }

    public List<? extends PsiMember> getSymbolMembers(Set<? extends PsiClass> qualifiers) {
        return this.isCall ? ApproximateResolver.getPossibleMethods(qualifiers, this.referenceName, this.argCount) : ApproximateResolver.getPossibleNonMethods(qualifiers, this.referenceName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/java/ReferenceChainLink";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calcMembersUnlessTooMany";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

