/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApproximateResolver {
    @Nullable
    static Set<PsiClass> getPossibleTypes(@NotNull PsiExpression expression2, int maxDepth) {
        if (expression2 == null) {
            ApproximateResolver.$$$reportNull$$$0(0);
        }
        if (maxDepth == 0) {
            return null;
        }
        return (expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiTypeCastExpression || expression2 instanceof PsiThisExpression ? ApproximateResolver.extractClass(expression2.getType()) : (expression2 instanceof PsiMethodCallExpression ? ApproximateResolver.getCallType(expression2, maxDepth) : (expression2 instanceof PsiReferenceExpression ? ApproximateResolver.getNonCallType((PsiReferenceExpression)expression2, maxDepth) : (expression2 instanceof PsiNewExpression ? ApproximateResolver.getNewType((PsiNewExpression)expression2) : (expression2 instanceof PsiConditionalExpression ? ApproximateResolver.getConditionalType((PsiConditionalExpression)expression2, maxDepth) : null))));
    }

    @Nullable
    private static Set<PsiClass> getConditionalType(PsiConditionalExpression expression2, int maxDepth) {
        PsiExpression thenBranch = expression2.getThenExpression();
        PsiExpression elseBranch = expression2.getElseExpression();
        if (thenBranch != null && elseBranch != null) {
            PsiClass thenType = (PsiClass)ContainerUtil.getOnlyItem(ApproximateResolver.getPossibleTypes(thenBranch, maxDepth / 2));
            PsiClass elseType = (PsiClass)ContainerUtil.getOnlyItem(ApproximateResolver.getPossibleTypes(elseBranch, maxDepth / 2));
            if (thenType != null && thenType.equals(elseType)) {
                return Collections.singleton(thenType);
            }
        }
        return null;
    }

    @Nullable
    private static Set<PsiClass> getNewType(PsiNewExpression expression2) {
        PsiClass psiClass;
        if (expression2.isArrayCreation()) {
            return null;
        }
        PsiAnonymousClass aClass = expression2.getAnonymousClass();
        if (aClass != null) {
            return Collections.singleton(aClass);
        }
        PsiJavaCodeReferenceElement reference = expression2.getClassReference();
        if (reference != null && (psiClass = (PsiClass)ObjectUtils.tryCast((Object)reference.resolve(), PsiClass.class)) != null) {
            return Collections.singleton(psiClass);
        }
        return null;
    }

    @Nullable
    private static Set<PsiClass> getCallType(@NotNull PsiExpression expression2, int maxDepth) {
        PsiReferenceExpression ref;
        PsiExpression qualifier;
        if (expression2 == null) {
            ApproximateResolver.$$$reportNull$$$0(1);
        }
        if ((qualifier = (ref = ((PsiMethodCallExpression)expression2).getMethodExpression()).getQualifierExpression()) == null) {
            return ApproximateResolver.extractClass(expression2.getType());
        }
        Set<PsiClass> qualifierType = ApproximateResolver.getPossibleTypes(qualifier, maxDepth - 1);
        String refName = ref.getReferenceName();
        int argCount = ((PsiMethodCallExpression)expression2).getArgumentList().getExpressionCount();
        List<PsiMethod> methods = refName == null || qualifierType == null ? null : ApproximateResolver.getPossibleMethods(qualifierType, refName, argCount);
        return methods == null ? null : ApproximateResolver.getDefiniteSymbolTypes(methods, qualifierType);
    }

    @Nullable
    private static Set<PsiClass> getNonCallType(@NotNull PsiReferenceExpression expression2, int maxDepth) {
        PsiExpression qualifier;
        if (expression2 == null) {
            ApproximateResolver.$$$reportNull$$$0(2);
        }
        if ((qualifier = expression2.getQualifierExpression()) == null) {
            PsiElement target = expression2.resolve();
            return target instanceof PsiClass ? Collections.singleton((PsiClass)target) : ApproximateResolver.extractClass(expression2.getType());
        }
        Set<PsiClass> qualifierType = ApproximateResolver.getPossibleTypes(qualifier, maxDepth - 1);
        String refName = expression2.getReferenceName();
        List<PsiMember> members = refName == null || qualifierType == null ? null : ApproximateResolver.getPossibleNonMethods(qualifierType, refName);
        return members == null ? null : ApproximateResolver.getDefiniteSymbolTypes(members, qualifierType);
    }

    @Nullable
    private static Set<PsiClass> extractClass(PsiType type2) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        return psiClass == null || psiClass instanceof PsiTypeParameter ? null : Collections.singleton(psiClass);
    }

    @NotNull
    public static List<PsiMethod> getPossibleMethods(@NotNull Set<? extends PsiClass> symbols, @NotNull String name2, int callArgCount) {
        if (symbols == null) {
            ApproximateResolver.$$$reportNull$$$0(3);
        }
        if (name2 == null) {
            ApproximateResolver.$$$reportNull$$$0(4);
        }
        List list = JBIterable.from(symbols).flatMap(sym -> Arrays.asList(sym.findMethodsByName(name2, true))).filter(m -> ApproximateResolver.canHaveArgCount(m, callArgCount)).toList();
        if (list == null) {
            ApproximateResolver.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static List<PsiMember> getPossibleNonMethods(@NotNull Set<? extends PsiClass> symbols, @NotNull String name2) {
        if (symbols == null) {
            ApproximateResolver.$$$reportNull$$$0(6);
        }
        if (name2 == null) {
            ApproximateResolver.$$$reportNull$$$0(7);
        }
        ArrayList<PsiMember> result = new ArrayList<PsiMember>();
        for (PsiClass psiClass : symbols) {
            ContainerUtil.addIfNotNull(result, (Object)psiClass.findFieldByName(name2, true));
            ContainerUtil.addIfNotNull(result, (Object)psiClass.findInnerClassByName(name2, true));
        }
        ArrayList<PsiMember> arrayList = result;
        if (arrayList == null) {
            ApproximateResolver.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    public static Set<PsiClass> getDefiniteSymbolTypes(@NotNull List<? extends PsiMember> candidates, @NotNull Set<? extends PsiClass> qualifierType) {
        if (candidates == null) {
            ApproximateResolver.$$$reportNull$$$0(9);
        }
        if (qualifierType == null) {
            ApproximateResolver.$$$reportNull$$$0(10);
        }
        HashSet<PsiClass> possibleTypes = new HashSet<PsiClass>();
        for (PsiMember psiMember : candidates) {
            PsiClass typeClass;
            if (psiMember instanceof PsiClass) {
                possibleTypes.add((PsiClass)psiMember);
                continue;
            }
            if (psiMember instanceof PsiMethod && ((PsiMethod)psiMember).isConstructor()) {
                ContainerUtil.addIfNotNull(possibleTypes, (Object)psiMember.getContainingClass());
                continue;
            }
            PsiType type2 = psiMember instanceof PsiField ? ((PsiField)psiMember).getType() : ((PsiMethod)psiMember).getReturnType();
            if (type2 instanceof PsiPrimitiveType) continue;
            if (type2 instanceof PsiArrayType) {
                type2 = PsiType.getJavaLangObject((PsiManager)psiMember.getManager(), (GlobalSearchScope)psiMember.getResolveScope());
            }
            if ((typeClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2)) == null) {
                return null;
            }
            if (typeClass instanceof PsiTypeParameter) {
                PsiClass containingClass = psiMember.getContainingClass();
                if (containingClass == null) {
                    return null;
                }
                typeClass = null;
                for (PsiClass psiClass : qualifierType) {
                    PsiSubstitutor substitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)psiClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    if (substitutor == null) continue;
                    PsiClass substitutedTypeClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)substitutor.substitute(type2));
                    if (substitutedTypeClass instanceof PsiTypeParameter || substitutedTypeClass == null || typeClass != null && substitutedTypeClass != typeClass) {
                        return null;
                    }
                    typeClass = substitutedTypeClass;
                }
                if (typeClass == null) {
                    return null;
                }
            }
            possibleTypes.add(typeClass);
        }
        return possibleTypes;
    }

    public static boolean canHaveArgCount(PsiMethod method, int argCount) {
        return method.isVarArgs() ? argCount >= method.getParameterList().getParametersCount() - 1 : argCount == method.getParameterList().getParametersCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/ApproximateResolver";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/ApproximateResolver";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleMethods";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleNonMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleTypes";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNonCallType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleMethods";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleNonMethods";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDefiniteSymbolTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

