/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.compiler.CompilerReferenceService;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.java.JavaBinaryPlusExpressionIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ImplicitToStringSearch;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.THashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ImplicitToStringSearcher
extends QueryExecutorBase<PsiExpression, ImplicitToStringSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance(ImplicitToStringSearcher.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQuery(@NotNull ImplicitToStringSearch.SearchParameters parameters2, @NotNull Processor<? super PsiExpression> consumer) {
        if (parameters2 == null) {
            ImplicitToStringSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            ImplicitToStringSearcher.$$$reportNull$$$0(1);
        }
        PsiMethod targetMethod = parameters2.getTargetMethod();
        Project project = PsiUtilCore.getProjectInReadAction((PsiElement)targetMethod);
        PsiClass aClass = (PsiClass)ReadAction.compute(() -> targetMethod.getContainingClass());
        if (aClass == null) {
            return;
        }
        DumbService dumbService = DumbService.getInstance((Project)project);
        THashMap fileOffsets = new THashMap();
        dumbService.runReadActionInSmartMode(() -> ImplicitToStringSearcher.lambda$processQuery$2(project, aClass, parameters2, (Map)fileOffsets));
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        psiManager.startBatchFilesProcessingMode();
        try {
            for (Map.Entry entry : fileOffsets.entrySet()) {
                VirtualFile file = (VirtualFile)entry.getKey();
                int[] offsets = (int[])entry.getValue();
                ProgressManager.checkCanceled();
                if (ImplicitToStringSearcher.processFile(file, offsets, psiManager, targetMethod, consumer, dumbService)) continue;
                return;
            }
        }
        finally {
            psiManager.finishBatchFilesProcessingMode();
        }
    }

    private static boolean processFile(VirtualFile file, int[] offsets, PsiManager manager, PsiMethod targetMethod, Processor<? super PsiExpression> consumer, DumbService dumbService) {
        return (Boolean)dumbService.runReadActionInSmartMode(() -> {
            PsiFile psiFile = Objects.requireNonNull(manager.findFile(file));
            if (!(psiFile instanceof PsiJavaFile)) {
                LOG.error("Non-java file " + psiFile + "; " + file);
                return true;
            }
            for (int offset : offsets) {
                PsiJavaToken plusToken = (PsiJavaToken)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)offset, PsiJavaToken.class, (boolean)false);
                if (plusToken == null) {
                    LOG.error("plusToken shouldn't be null in " + psiFile + " at " + offset);
                    continue;
                }
                PsiElement parent = plusToken.getParent();
                if (parent instanceof PsiPolyadicExpression) {
                    PsiExpression[] operands2;
                    PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
                    PsiType exprType = polyadicExpression.getType();
                    if (exprType == null || !exprType.equalsToText("java.lang.String")) continue;
                    for (PsiExpression operand2 : operands2 = polyadicExpression.getOperands()) {
                        if (ImplicitToStringSearcher.processPolyadicExprOperand(operand2, consumer, targetMethod)) continue;
                        return false;
                    }
                    continue;
                }
                LOG.error(parent + " expected to be polyadic expression");
            }
            return true;
        });
    }

    private static boolean processPolyadicExprOperand(@NotNull PsiExpression expr2, @NotNull Processor<? super PsiExpression> consumer, @NotNull PsiMethod targetMethod) {
        PsiMethod implicitlyUsedMethod;
        PsiClass aClass;
        PsiType type2;
        if (expr2 == null) {
            ImplicitToStringSearcher.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            ImplicitToStringSearcher.$$$reportNull$$$0(3);
        }
        if (targetMethod == null) {
            ImplicitToStringSearcher.$$$reportNull$$$0(4);
        }
        if ((type2 = expr2.getType()) instanceof PsiPrimitiveType) {
            type2 = ((PsiPrimitiveType)type2).getBoxedType((PsiElement)expr2);
        }
        if ((aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2)) != null && !"java.lang.String".equals(aClass.getQualifiedName()) && (implicitlyUsedMethod = aClass.findMethodBySignature(targetMethod, true)) != null && (targetMethod == implicitlyUsedMethod || MethodSignatureUtil.isSuperMethod((PsiMethod)targetMethod, (PsiMethod)implicitlyUsedMethod))) {
            return consumer.process((Object)expr2);
        }
        return true;
    }

    private static /* synthetic */ void lambda$processQuery$2(Project project, PsiClass aClass, ImplicitToStringSearch.SearchParameters parameters2, Map fileOffsets) {
        CompilerReferenceService compilerReferenceService = CompilerReferenceService.getInstance(project);
        GlobalSearchScope scopeWithoutToString = compilerReferenceService == null ? null : compilerReferenceService.getScopeWithoutImplicitToStringCodeReferences((PsiElement)aClass);
        GlobalSearchScope filter = GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)(scopeWithoutToString == null ? parameters2.getSearchScope() : GlobalSearchScope.notScope((GlobalSearchScope)scopeWithoutToString).intersectWith(parameters2.getSearchScope())), (Project)project);
        FileBasedIndex.getInstance().processValues(JavaBinaryPlusExpressionIndex.INDEX_ID, (Object)Boolean.TRUE, null, (file, value2) -> {
            ProgressManager.checkCanceled();
            fileOffsets.put(file, value2.getOffsets());
            return true;
        }, filter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethod";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/search/ImplicitToStringSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processQuery";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processPolyadicExprOperand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

