/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassInnerStuffCache {
    private final PsiExtensibleClass myClass;
    private final SimpleModificationTracker myTracker;

    public ClassInnerStuffCache(@NotNull PsiExtensibleClass aClass) {
        if (aClass == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(0);
        }
        this.myTracker = new SimpleModificationTracker();
        this.myClass = aClass;
    }

    public PsiMethod @NotNull [] getConstructors() {
        PsiMethod[] psiMethodArray = (PsiMethod[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(PsiImplUtil.getConstructors(this.myClass))));
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(1);
        }
        return psiMethodArray;
    }

    public PsiField @NotNull [] getFields() {
        PsiField[] psiFieldArray = (PsiField[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.calcFields())));
        if (psiFieldArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(2);
        }
        return psiFieldArray;
    }

    public PsiMethod @NotNull [] getMethods() {
        PsiMethod[] psiMethodArray = (PsiMethod[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.calcMethods())));
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(3);
        }
        return psiMethodArray;
    }

    public PsiClass @NotNull [] getInnerClasses() {
        PsiClass[] psiClassArray = (PsiClass[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.calcInnerClasses())));
        if (psiClassArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(4);
        }
        return psiClassArray;
    }

    public PsiRecordComponent @NotNull [] getRecordComponents() {
        PsiRecordComponent[] psiRecordComponentArray = (PsiRecordComponent[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.calcRecordComponents())));
        if (psiRecordComponentArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(5);
        }
        return psiRecordComponentArray;
    }

    @Nullable
    public PsiField findFieldByName(String name2, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findFieldByName(this.myClass, name2, true);
        }
        return (PsiField)((Map)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.getFieldsMap()))).get(name2);
    }

    public PsiMethod @NotNull [] findMethodsByName(String name2, boolean checkBases) {
        if (checkBases) {
            PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsByName(this.myClass, name2, true);
            if (psiMethodArray == null) {
                ClassInnerStuffCache.$$$reportNull$$$0(6);
            }
            return psiMethodArray;
        }
        PsiMethod[] psiMethodArray = (PsiMethod[])ClassInnerStuffCache.copy((Object[])ObjectUtils.notNull(((Map)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.getMethodsMap()))).get(name2), (Object)PsiMethod.EMPTY_ARRAY));
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(7);
        }
        return psiMethodArray;
    }

    @Nullable
    public PsiClass findInnerClassByName(String name2, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findInnerByName(this.myClass, name2, true);
        }
        return (PsiClass)((Map)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.getInnerClassesMap()))).get(name2);
    }

    @Nullable
    PsiMethod getValuesMethod() {
        return this.myClass.isEnum() && !this.isAnonymousClass() ? (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.makeValuesMethod())) : null;
    }

    @Nullable
    private PsiMethod getValueOfMethod() {
        return this.myClass.isEnum() && !this.isAnonymousClass() ? (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.makeValueOfMethod())) : null;
    }

    private boolean isAnonymousClass() {
        return this.myClass.getName() == null || this.myClass instanceof ClsClassImpl && ((ClsClassImpl)this.myClass).isAnonymousClass();
    }

    private static <T> T[] copy(T[] value2) {
        return value2.length == 0 ? value2 : (Object[])value2.clone();
    }

    private <T> CachedValueProvider.Result<T> makeResult(T value2) {
        return CachedValueProvider.Result.create(value2, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker});
    }

    private PsiField @NotNull [] calcFields() {
        List<PsiField> own = this.myClass.getOwnFields();
        List ext = PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiField.class);
        PsiField[] psiFieldArray = (PsiField[])ArrayUtil.mergeCollections(own, (Collection)ext, (ArrayFactory)PsiField.ARRAY_FACTORY);
        if (psiFieldArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(8);
        }
        return psiFieldArray;
    }

    private PsiMethod @NotNull [] calcMethods() {
        List<PsiMethod> own = this.myClass.getOwnMethods();
        List ext = PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiMethod.class);
        if (this.myClass.isEnum()) {
            ContainerUtil.addIfNotNull((Collection)ext, (Object)this.getValuesMethod());
            ContainerUtil.addIfNotNull((Collection)ext, (Object)this.getValueOfMethod());
        }
        PsiMethod[] psiMethodArray = (PsiMethod[])ArrayUtil.mergeCollections(own, (Collection)ext, (ArrayFactory)PsiMethod.ARRAY_FACTORY);
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(9);
        }
        return psiMethodArray;
    }

    private PsiClass @NotNull [] calcInnerClasses() {
        List<PsiClass> own = this.myClass.getOwnInnerClasses();
        List ext = PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiClass.class);
        PsiClass[] psiClassArray = (PsiClass[])ArrayUtil.mergeCollections(own, (Collection)ext, (ArrayFactory)PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(10);
        }
        return psiClassArray;
    }

    private PsiRecordComponent @NotNull [] calcRecordComponents() {
        PsiRecordHeader header = this.myClass.getRecordHeader();
        PsiRecordComponent[] psiRecordComponentArray = header == null ? PsiRecordComponent.EMPTY_ARRAY : header.getRecordComponents();
        if (psiRecordComponentArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(11);
        }
        return psiRecordComponentArray;
    }

    @NotNull
    private Map<String, PsiField> getFieldsMap() {
        PsiField[] fields = this.getFields();
        if (fields.length == 0) {
            Map<String, PsiField> map2 = Collections.emptyMap();
            if (map2 == null) {
                ClassInnerStuffCache.$$$reportNull$$$0(12);
            }
            return map2;
        }
        THashMap cachedFields = new THashMap();
        for (PsiField field : fields) {
            String name2 = field.getName();
            if (cachedFields.containsKey(name2)) continue;
            cachedFields.put(name2, field);
        }
        THashMap tHashMap = cachedFields;
        if (tHashMap == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(13);
        }
        return tHashMap;
    }

    @NotNull
    private Map<String, PsiMethod[]> getMethodsMap() {
        PsiMethod[] methods = this.getMethods();
        if (methods.length == 0) {
            Map<String, PsiMethod[]> map2 = Collections.emptyMap();
            if (map2 == null) {
                ClassInnerStuffCache.$$$reportNull$$$0(14);
            }
            return map2;
        }
        HashMap<String, SmartList> collectedMethods = new HashMap<String, SmartList>();
        for (PsiMethod method : methods) {
            List list = (List)collectedMethods.get(method.getName());
            if (list == null) {
                list = new SmartList();
                collectedMethods.put(method.getName(), (SmartList)list);
            }
            list.add(method);
        }
        THashMap cachedMethods = new THashMap();
        for (Map.Entry entry : collectedMethods.entrySet()) {
            List list = (List)entry.getValue();
            cachedMethods.put(entry.getKey(), list.toArray(PsiMethod.EMPTY_ARRAY));
        }
        THashMap tHashMap = cachedMethods;
        if (tHashMap == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(15);
        }
        return tHashMap;
    }

    @NotNull
    private Map<String, PsiClass> getInnerClassesMap() {
        PsiClass[] classes2 = this.getInnerClasses();
        if (classes2.length == 0) {
            Map<String, PsiClass> map2 = Collections.emptyMap();
            if (map2 == null) {
                ClassInnerStuffCache.$$$reportNull$$$0(16);
            }
            return map2;
        }
        THashMap cachedInners = new THashMap();
        for (PsiClass psiClass : classes2) {
            String name2 = psiClass.getName();
            if (name2 == null) {
                Logger.getInstance(ClassInnerStuffCache.class).error((Object)psiClass);
                continue;
            }
            if (psiClass instanceof ExternallyDefinedPsiElement && cachedInners.containsKey(name2)) continue;
            cachedInners.put(name2, psiClass);
        }
        THashMap tHashMap = cachedInners;
        if (tHashMap == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(17);
        }
        return tHashMap;
    }

    private PsiMethod makeValuesMethod() {
        return new EnumSyntheticMethod(this.myClass, "public static " + this.myClass.getName() + "[] values() { }");
    }

    private PsiMethod makeValueOfMethod() {
        return new EnumSyntheticMethod(this.myClass, "public static " + this.myClass.getName() + " valueOf(java.lang.String name) throws java.lang.IllegalArgumentException { }");
    }

    public void dropCaches() {
        this.myTracker.incModificationCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/ClassInnerStuffCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/ClassInnerStuffCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordComponents";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFields";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calcMethods";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInnerClasses";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRecordComponents";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsMap";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsMap";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClassesMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EnumSyntheticMethod
    extends LightMethod
    implements SyntheticElement {
        private final PsiClass myClass;
        private final String myText;

        EnumSyntheticMethod(@NotNull PsiClass enumClass, @NotNull String text2) {
            if (enumClass == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(1);
            }
            super(enumClass.getManager(), JavaPsiFacade.getElementFactory((Project)enumClass.getProject()).createMethodFromText(text2, (PsiElement)enumClass), enumClass);
            this.myClass = enumClass;
            this.myText = text2;
        }

        public int getTextOffset() {
            return this.myClass.getTextOffset();
        }

        public boolean equals(Object another) {
            return this == another || another instanceof EnumSyntheticMethod && this.myClass.equals(((EnumSyntheticMethod)((Object)another)).myClass) && this.myText.equals(((EnumSyntheticMethod)((Object)another)).myText);
        }

        public int hashCode() {
            return Objects.hash(this.myText, this.myClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "enumClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/source/ClassInnerStuffCache$EnumSyntheticMethod";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

