/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.refResolve;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.CacheUpdateRunner;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.RefResolveService;
import com.intellij.psi.refResolve.PersistentIntList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;

public final class RefResolveServiceImpl
extends RefResolveService
implements Runnable,
Disposable {
    private static final Logger LOG = Logger.getInstance(RefResolveServiceImpl.class);
    private final AtomicInteger fileCount;
    private final AtomicLong bytesSize;
    private final AtomicLong refCount;
    private final PersistentIntList storage;
    private final Deque<VirtualFile> filesToResolve;
    private final ConcurrentBitSet fileIsInQueue;
    private final ConcurrentBitSet fileIsResolved;
    private final Project myProject;
    private volatile boolean myDisposed;
    private volatile boolean upToDate;
    private final AtomicInteger enableVetoes;
    private final FileWriter log;
    private final ProjectFileIndex myProjectFileIndex;
    private volatile Future<?> resolveProcess;
    private volatile int resolvedInPreviousBatch;
    private String prevLog;
    private static final Set<JavaSourceRootType> SOURCE_ROOTS = ContainerUtil.newTroveSet((Object[])new JavaSourceRootType[]{JavaSourceRootType.SOURCE, JavaSourceRootType.TEST_SOURCE});
    private final List<RefResolveService.Listener> myListeners;

    public RefResolveServiceImpl(@NotNull Project project) throws IOException {
        if (project == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(0);
        }
        this.fileCount = new AtomicInteger();
        this.bytesSize = new AtomicLong();
        this.refCount = new AtomicLong();
        this.filesToResolve = new ArrayDeque<VirtualFile>();
        this.fileIsInQueue = new ConcurrentBitSet();
        this.enableVetoes = new AtomicInteger();
        this.resolveProcess = new FutureTask<Object>(EmptyRunnable.getInstance(), null);
        this.prevLog = "";
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        ((FutureTask)this.resolveProcess).run();
        this.myProjectFileIndex = ProjectFileIndex.getInstance((Project)project);
        if (ENABLED) {
            this.log = new FileWriter(new File(this.getStorageDirectory(), "log.txt"));
            File dataFile = new File(this.getStorageDirectory(), "data");
            this.fileIsResolved = ConcurrentBitSet.readFrom((File)new File(this.getStorageDirectory(), "bitSet"));
            this.log("Read resolved file bitset: " + this.fileIsResolved);
            int maxId = FSRecords.getMaxId();
            PersistentIntList list = new PersistentIntList(dataFile, dataFile.exists() ? 0 : maxId);
            if (list.getSize() == maxId) {
                this.storage = list;
            } else {
                Disposer.dispose((Disposable)list);
                this.storage = new PersistentIntList(dataFile, maxId);
                this.log("VFS maxId changed: was " + list.getSize() + "; now: " + maxId + "; re-resolving everything");
                this.fileIsResolved.clear();
            }
            Disposer.register((Disposable)this, (Disposable)this.storage);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                    this.initListeners(project.getMessageBus(), PsiManager.getInstance((Project)project));
                    this.startThread();
                });
            }
            Disposer.register((Disposable)this, (Disposable)new Disposable(){

                public void dispose() {
                    try {
                        RefResolveServiceImpl.this.save();
                        RefResolveServiceImpl.this.log.close();
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
        } else {
            this.log = null;
            this.fileIsResolved = null;
            this.storage = null;
        }
    }

    @NotNull
    private static List<VirtualFile> toVf(int @NotNull [] ids) {
        if (ids == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(1);
        }
        ArrayList<VirtualFile> res = new ArrayList<VirtualFile>();
        for (int id : ids) {
            VirtualFile file = PersistentFS.getInstance().findFileById(id);
            if (file == null) continue;
            res.add(file);
        }
        ArrayList<VirtualFile> arrayList = res;
        if (arrayList == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private static String toVfString(int @NotNull [] backIds) {
        if (backIds == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(3);
        }
        List<VirtualFile> list = RefResolveServiceImpl.toVf(backIds);
        return RefResolveServiceImpl.toVfString(list);
    }

    @NotNull
    private static String toVfString(@NotNull Collection<VirtualFile> list) {
        if (list == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(4);
        }
        List sub = ContainerUtil.getFirstItems(new ArrayList<VirtualFile>(list), (int)100);
        String string = list.size() + " files: " + StringUtil.join((Collection)sub, file -> file.getName(), (String)", ") + (list.size() == sub.size() ? "" : "...");
        if (string == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    private void initListeners(@NotNull MessageBus messageBus, @NotNull PsiManager psiManager) {
        if (messageBus == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(6);
        }
        if (psiManager == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(7);
        }
        MessageBusConnection connection = messageBus.connect((Disposable)this);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                RefResolveServiceImpl.this.fileCount.set(0);
                List files = ContainerUtil.mapNotNull(events, event -> event.getFile());
                RefResolveServiceImpl.this.queue(files, "VFS events " + events.size());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/psi/refResolve/RefResolveServiceImpl$2", "after"));
            }
        });
        psiManager.addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                PsiFile file;
                VirtualFile virtualFile;
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((virtualFile = PsiUtilCore.getVirtualFile((PsiElement)(file = event.getFile()))) != null) {
                    RefResolveServiceImpl.this.queue(Collections.singletonList(virtualFile), event);
                }
            }

            public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                this.childrenChanged(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/psi/refResolve/RefResolveServiceImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                RefResolveServiceImpl.this.disable();
            }

            public void exitDumbMode() {
                RefResolveServiceImpl.this.enable();
            }
        });
        connection.subscribe(PowerSaveMode.TOPIC, (Object)new PowerSaveMode.Listener(){

            public void powerSaveStateChanged() {
                if (PowerSaveMode.isEnabled()) {
                    RefResolveServiceImpl.this.enable();
                } else {
                    RefResolveServiceImpl.this.disable();
                }
            }
        });
        ApplicationManagerEx.getApplicationEx().addApplicationListener(new ApplicationListener(){

            public void beforeWriteActionStart(@NotNull Object action) {
                if (action == null) {
                    6.$$$reportNull$$$0(0);
                }
                RefResolveServiceImpl.this.disable();
            }

            public void writeActionFinished(@NotNull Object action) {
                if (action == null) {
                    6.$$$reportNull$$$0(1);
                }
                RefResolveServiceImpl.this.enable();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "action";
                objectArray2[1] = "com/intellij/psi/refResolve/RefResolveServiceImpl$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeWriteActionStart";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "writeActionFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        Disposer.register((Disposable)this, () -> this.disable());
        VirtualFileManager.getInstance().addVirtualFileManagerListener(new VirtualFileManagerListener(){

            public void beforeRefreshStart(boolean asynchronous) {
                RefResolveServiceImpl.this.disable();
            }

            public void afterRefreshFinish(boolean asynchronous) {
                RefResolveServiceImpl.this.enable();
            }
        }, (Disposable)this);
        HeavyProcessLatch.INSTANCE.addListener(new HeavyProcessLatch.HeavyProcessListener(){

            public void processFinished() {
                RefResolveServiceImpl.this.wakeUp();
            }
        }, (Disposable)this);
    }

    private boolean queueIfNeeded(VirtualFile virtualFile, @NotNull Project project) {
        if (project == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(8);
        }
        return this.toResolve(virtualFile, project) && this.queueUpdate(virtualFile);
    }

    private boolean toResolve(VirtualFile virtualFile, @NotNull Project project) {
        if (project == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(9);
        }
        if (virtualFile != null && virtualFile.isValid() && project.isInitialized() && this.myProjectFileIndex.isInSourceContent(virtualFile) && RefResolveServiceImpl.isSupportedFileType(virtualFile)) {
            return true;
        }
        if (virtualFile instanceof VirtualFileWithId) {
            int id = RefResolveServiceImpl.getAbsId(virtualFile);
            this.fileIsResolved.set(id);
        }
        return false;
    }

    public static boolean isSupportedFileType(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(10);
        }
        if (virtualFile.isDirectory()) {
            return true;
        }
        if (FileTypeRegistry.getInstance().isFileOfType(virtualFile, (FileType)StdFileTypes.JAVA)) {
            return true;
        }
        if (FileTypeRegistry.getInstance().isFileOfType(virtualFile, (FileType)StdFileTypes.XML) && !ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile)) {
            return true;
        }
        String extension = virtualFile.getExtension();
        return "groovy".equals(extension) || "kt".equals(extension);
    }

    @NotNull
    private File getStorageDirectory() {
        String dirName = this.myProject.getName() + "." + Integer.toHexString(this.myProject.getPresentableUrl().hashCode());
        File dir = new File(PathManager.getSystemPath(), "refs/" + dirName);
        FileUtil.createDirectory((File)dir);
        File file = dir;
        if (file == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(11);
        }
        return file;
    }

    private void log(String m) {
        this.logf(m);
    }

    private void logf(String m) {
        if (LOG.isDebugEnabled()) {
            try {
                this.log.write(DateFormat.getDateTimeInstance().format(new Date()) + " " + m + "\n");
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void flushLog() {
        try {
            this.log.flush();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queueUpdate(@NotNull VirtualFile file) {
        if (file == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(12);
        }
        Deque<VirtualFile> deque = this.filesToResolve;
        synchronized (deque) {
            if (!(file instanceof VirtualFileWithId)) {
                return false;
            }
            int fileId = RefResolveServiceImpl.getAbsId(file);
            this.countAndMarkUnresolved(file, new LinkedHashSet<VirtualFile>(), true);
            boolean alreadyAdded = this.fileIsInQueue.set(fileId);
            if (!alreadyAdded) {
                this.filesToResolve.add(file);
            }
            this.upToDate = false;
            this.wakeUpUnderLock();
            return !alreadyAdded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp() {
        Deque<VirtualFile> deque = this.filesToResolve;
        synchronized (deque) {
            this.wakeUpUnderLock();
        }
    }

    private void wakeUpUnderLock() {
        this.filesToResolve.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForQueue() throws InterruptedException {
        Deque<VirtualFile> deque = this.filesToResolve;
        synchronized (deque) {
            this.filesToResolve.wait(1000L);
        }
    }

    private void startThread() {
        new Thread((Runnable)this, "Ref resolve service").start();
        this.upToDate = true;
        this.queueUnresolvedFilesSinceLastRestart();
    }

    private void queueUnresolvedFilesSinceLastRestart() {
        PersistentFS fs = PersistentFS.getInstance();
        int maxId = FSRecords.getMaxId();
        TIntArrayList list = new TIntArrayList();
        int id = this.fileIsResolved.nextClearBit(1);
        while (id >= 0 && id < maxId) {
            int nextSetBit = this.fileIsResolved.nextSetBit(id);
            int endOfRun = Math.min(maxId, nextSetBit == -1 ? maxId : nextSetBit);
            do {
                VirtualFile virtualFile;
                if (this.queueIfNeeded(virtualFile = fs.findFileById(id), this.myProject)) {
                    list.add(id);
                    continue;
                }
                this.fileIsResolved.set(id);
            } while (++id < endOfRun);
            id = this.fileIsResolved.nextClearBit(id + 1);
        }
        this.log("Initially added to resolve " + RefResolveServiceImpl.toVfString(list.toNativeArray()));
    }

    public void dispose() {
        this.myDisposed = true;
    }

    private void save() throws IOException {
        this.log("Saving resolved file bitset: " + this.fileIsResolved);
        this.fileIsResolved.writeTo(new File(this.getStorageDirectory(), "bitSet"));
        this.log("list.size = " + this.storage.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.myDisposed) {
            boolean isEmpty;
            Deque<VirtualFile> deque = this.filesToResolve;
            synchronized (deque) {
                isEmpty = this.filesToResolve.isEmpty();
            }
            if (this.enableVetoes.get() > 0 || isEmpty || !this.resolveProcess.isDone() || HeavyProcessLatch.INSTANCE.isRunning() || PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments()) {
                try {
                    this.waitForQueue();
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            final Set<VirtualFile> files = this.pollFilesToResolve();
            if (files.isEmpty()) continue;
            this.upToDate = false;
            ApplicationManagerEx.getApplicationEx().invokeLater(() -> {
                if (!this.resolveProcess.isDone()) {
                    return;
                }
                this.log("Started to resolve " + files.size() + " files");
                Task.Backgroundable backgroundable = new Task.Backgroundable(this.myProject, PsiBundle.message((String)"resolving.files", (Object[])new Object[0]), false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            9.$$$reportNull$$$0(0);
                        }
                        if (!ApplicationManagerEx.getApplicationEx().isDisposed()) {
                            RefResolveServiceImpl.this.processBatch(indicator, files);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/refResolve/RefResolveServiceImpl$9", "run"));
                    }
                };
                Object indicator = files.size() > 1 ? new BackgroundableProcessIndicator(backgroundable) : new MyProgress();
                this.resolveProcess = ((ProgressManagerImpl)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(backgroundable, (ProgressIndicator)indicator, null);
            }, this.myProject.getDisposed());
            this.flushLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBatch(@NotNull ProgressIndicator indicator, @NotNull Set<VirtualFile> files) {
        if (indicator == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(13);
        }
        if (files == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(14);
        }
        assert (!ApplicationManagerEx.getApplicationEx().isDispatchThread());
        int resolvedInPreviousBatch = this.resolvedInPreviousBatch;
        int totalSize = files.size() + resolvedInPreviousBatch;
        ConcurrentIntObjectMap fileToForwardIds = ContainerUtil.createConcurrentIntObjectMap();
        Set<VirtualFile> toProcess = Collections.synchronizedSet(files);
        indicator.setIndeterminate(false);
        ProgressIndicatorUtils.forceWriteActionPriority((ProgressIndicator)indicator, (Disposable)((Disposable)indicator));
        long start = System.currentTimeMillis();
        Processor processor = arg_0 -> this.lambda$processBatch$4(toProcess, totalSize, indicator, (IntObjectMap)fileToForwardIds, arg_0);
        boolean success = true;
        try {
            success = this.processFilesConcurrently(files, indicator, (Processor<VirtualFile>)processor);
            this.resolvedInPreviousBatch = toProcess.isEmpty() ? 0 : totalSize - toProcess.size();
        }
        catch (Throwable throwable) {
            this.resolvedInPreviousBatch = toProcess.isEmpty() ? 0 : totalSize - toProcess.size();
            this.queue(toProcess, "re-added after fail. success=" + success);
            this.storeIds((IntObjectMap<int[]>)fileToForwardIds);
            long end = System.currentTimeMillis();
            this.log("Resolved batch of " + (totalSize - toProcess.size()) + " from " + totalSize + " files in " + (end - start) / 1000L + "sec. (Gap: " + this.storage.gap + ")");
            Deque<VirtualFile> deque = this.filesToResolve;
            synchronized (deque) {
                this.upToDate = this.filesToResolve.isEmpty();
                this.log("upToDate = " + this.upToDate);
                if (this.upToDate) {
                    for (RefResolveService.Listener listener : this.myListeners) {
                        listener.allFilesResolved();
                    }
                }
            }
            throw throwable;
        }
        this.queue(toProcess, "re-added after fail. success=" + success);
        this.storeIds((IntObjectMap<int[]>)fileToForwardIds);
        long end = System.currentTimeMillis();
        this.log("Resolved batch of " + (totalSize - toProcess.size()) + " from " + totalSize + " files in " + (end - start) / 1000L + "sec. (Gap: " + this.storage.gap + ")");
        Deque<VirtualFile> deque = this.filesToResolve;
        synchronized (deque) {
            this.upToDate = this.filesToResolve.isEmpty();
            this.log("upToDate = " + this.upToDate);
            if (this.upToDate) {
                for (RefResolveService.Listener listener : this.myListeners) {
                    listener.allFilesResolved();
                }
            }
        }
    }

    private boolean processFilesConcurrently(@NotNull Set<VirtualFile> files, @NotNull ProgressIndicator indicator, @NotNull Processor<VirtualFile> processor) {
        if (files == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(15);
        }
        if (indicator == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(17);
        }
        ArrayList<VirtualFile> fileList = new ArrayList<VirtualFile>(files);
        int parallelism = CacheUpdateRunner.indexingThreadCount();
        Callable<Boolean> processFileFromSet = () -> {
            boolean[] result = new boolean[]{true};
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                block4: {
                    VirtualFile file;
                    do {
                        ProgressManager.checkCanceled();
                        List list = fileList;
                        synchronized (list) {
                            file = fileList.isEmpty() ? null : (VirtualFile)fileList.remove(fileList.size() - 1);
                        }
                        if (file == null) break block4;
                    } while (processor.process((Object)file));
                    result[0] = false;
                }
            }, indicator);
            return result[0];
        };
        List futures = ContainerUtil.map(Collections.nCopies(parallelism, ""), s -> ApplicationManagerEx.getApplicationEx().executeOnPooledThread(processFileFromSet));
        List results = ContainerUtil.map((Collection)futures, future -> {
            try {
                return (Boolean)future.get();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return false;
            }
        });
        return !ContainerUtil.exists((Iterable)results, result -> result != null && result == false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Set<VirtualFile> pollFilesToResolve() {
        LinkedHashSet<VirtualFile> set;
        Deque<VirtualFile> deque = this.filesToResolve;
        synchronized (deque) {
            int queuedSize = this.filesToResolve.size();
            set = new LinkedHashSet<VirtualFile>(queuedSize);
            for (VirtualFile file : this.filesToResolve) {
                if (!this.fileIsInQueue.clear(RefResolveServiceImpl.getAbsId(file))) continue;
                set.add(file);
            }
            this.filesToResolve.clear();
        }
        return this.countAndMarkUnresolved(set, false);
    }

    private static int getAbsId(@NotNull VirtualFile file) {
        if (file == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(18);
        }
        return ((VirtualFileWithId)file).getId();
    }

    @NotNull
    private Set<VirtualFile> countAndMarkUnresolved(@NotNull Collection<VirtualFile> files, boolean inDbOnly) {
        if (files == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(19);
        }
        LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>();
        for (VirtualFile file : files) {
            this.countAndMarkUnresolved(file, result, inDbOnly);
        }
        LinkedHashSet<VirtualFile> linkedHashSet = result;
        if (linkedHashSet == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(20);
        }
        return linkedHashSet;
    }

    private void countAndMarkUnresolved(@NotNull VirtualFile file, final @NotNull Set<VirtualFile> result, final boolean inDbOnly) {
        if (file == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(21);
        }
        if (result == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(22);
        }
        if (file.isDirectory()) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        10.$$$reportNull$$$0(0);
                    }
                    return RefResolveServiceImpl.this.doCountAndMarkUnresolved(file, result);
                }

                @Nullable
                public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
                    if (file == null) {
                        10.$$$reportNull$$$0(1);
                    }
                    return inDbOnly ? ((NewVirtualFile)file).iterInDbChildren() : null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "file";
                    objectArray2[1] = "com/intellij/psi/refResolve/RefResolveServiceImpl$10";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitFile";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getChildrenIterable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        } else {
            this.doCountAndMarkUnresolved(file, result);
        }
    }

    private boolean doCountAndMarkUnresolved(@NotNull VirtualFile file, @NotNull Set<VirtualFile> result) {
        if (file == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(23);
        }
        if (result == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(24);
        }
        if (file.isDirectory()) {
            this.fileIsResolved.set(RefResolveServiceImpl.getAbsId(file));
            return result.add(file);
        }
        if (this.toResolve(file, this.myProject)) {
            result.add(file);
            this.fileIsResolved.clear(RefResolveServiceImpl.getAbsId(file));
        }
        return true;
    }

    private void enable() {
        int vetoes;
        while ((vetoes = this.enableVetoes.get()) != 0 && !this.enableVetoes.compareAndSet(vetoes, vetoes - 1)) {
        }
        this.wakeUp();
    }

    private void disable() {
        this.enableVetoes.incrementAndGet();
        this.wakeUp();
    }

    private int[] processFile(@NotNull VirtualFile file, int fileId, @NotNull ProgressIndicator indicator) {
        TIntHashSet forward;
        if (file == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(25);
        }
        if (indicator == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(26);
        }
        try {
            forward = this.calcForwardRefs(file, indicator);
        }
        catch (ApplicationUtil.CannotRunReadActionException | IndexNotReadyException e) {
            return null;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            this.log(ExceptionUtil.getThrowableText((Throwable)e));
            this.flushLog();
            return null;
        }
        int[] forwardIds = forward.toArray();
        this.fileIsResolved.set(fileId);
        this.logf("  ---- " + file.getPresentableUrl() + " processed. forwardIds: " + RefResolveServiceImpl.toVfString(forwardIds));
        for (RefResolveService.Listener listener : this.myListeners) {
            listener.fileResolved(file);
        }
        return forwardIds;
    }

    private void storeIds(@NotNull IntObjectMap<int[]> fileToForwardIds) {
        if (fileToForwardIds == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(27);
        }
        int forwardSize = 0;
        int backwardSize = 0;
        TIntObjectHashMap fileToBackwardIds = new TIntObjectHashMap(fileToForwardIds.size());
        for (IntObjectMap.Entry entry : fileToForwardIds.entrySet()) {
            int fileId = entry.getKey();
            int[] forwardIds = (int[])entry.getValue();
            forwardSize += forwardIds.length;
            for (int forwardId : forwardIds) {
                TIntArrayList backIds = (TIntArrayList)fileToBackwardIds.get(forwardId);
                if (backIds == null) {
                    backIds = new TIntArrayList();
                    fileToBackwardIds.put(forwardId, (Object)backIds);
                }
                backIds.add(fileId);
                ++backwardSize;
            }
        }
        this.log("backwardSize = " + backwardSize);
        this.log("forwardSize = " + forwardSize);
        this.log("fileToForwardIds.size() = " + fileToForwardIds.size());
        this.log("fileToBackwardIds.size() = " + fileToBackwardIds.size());
        assert (forwardSize == backwardSize);
        ApplicationManagerEx.getApplicationEx().runReadAction(() -> {
            if (!ApplicationManagerEx.getApplicationEx().isDisposed()) {
                fileToBackwardIds.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntArrayList>(){

                    public boolean execute(int fileId, TIntArrayList backIds) {
                        RefResolveServiceImpl.this.storage.addAll(fileId, backIds.toNativeArray());
                        return true;
                    }
                });
            }
        });
    }

    @NotNull
    private TIntHashSet calcForwardRefs(@NotNull VirtualFile virtualFile, final @NotNull ProgressIndicator indicator) throws IndexNotReadyException, ApplicationUtil.CannotRunReadActionException {
        if (virtualFile == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(28);
        }
        if (indicator == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(29);
        }
        TIntHashSet forward = new TIntHashSet();
        final PsiFile psiFile = (PsiFile)ApplicationUtil.tryRunReadAction(() -> {
            if (this.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            if (this.fileCount.incrementAndGet() % 100 == 0) {
                PsiManager.getInstance((Project)this.myProject).dropResolveCaches();
                try {
                    this.storage.flush();
                    this.log.flush();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            return PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
        });
        int fileId = RefResolveServiceImpl.getAbsId(virtualFile);
        if (psiFile != null) {
            this.bytesSize.addAndGet(virtualFile.getLength());
            THashSet resolved = new THashSet();
            ApplicationUtil.tryRunReadAction((Runnable)new Runnable((Set)resolved, forward){
                final /* synthetic */ Set val$resolved;
                final /* synthetic */ TIntHashSet val$forward;
                {
                    this.val$resolved = set;
                    this.val$forward = tIntHashSet;
                }

                @Override
                public void run() {
                    indicator.checkCanceled();
                    if (psiFile instanceof PsiJavaFile) {
                        psiFile.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                                indicator.checkCanceled();
                                RefResolveServiceImpl.this.resolveReference((PsiReference)reference, val$resolved);
                                super.visitReferenceElement(reference);
                            }
                        });
                    } else {
                        psiFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                            public void visitElement(@NotNull PsiElement element) {
                                if (element == null) {
                                    2.$$$reportNull$$$0(0);
                                }
                                for (PsiReference reference : element.getReferences()) {
                                    indicator.checkCanceled();
                                    RefResolveServiceImpl.this.resolveReference(reference, val$resolved);
                                }
                                super.visitElement(element);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/refResolve/RefResolveServiceImpl$12$2", "visitElement"));
                            }
                        });
                    }
                    indicator.checkCanceled();
                    for (PsiElement element : this.val$resolved) {
                        PsiFile file = element.getContainingFile();
                        RefResolveServiceImpl.addIdAndSuperClasses(file, this.val$forward);
                    }
                }
            });
        }
        forward.remove(fileId);
        TIntHashSet tIntHashSet = forward;
        if (tIntHashSet == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(30);
        }
        return tIntHashSet;
    }

    private void resolveReference(@NotNull PsiReference reference, @NotNull Set<PsiElement> resolved) {
        PsiElement element;
        if (reference == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(31);
        }
        if (resolved == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(32);
        }
        if ((element = reference.resolve()) != null) {
            resolved.add(element);
        }
        this.refCount.incrementAndGet();
    }

    private static void addIdAndSuperClasses(PsiFile file, @NotNull TIntHashSet forward) {
        if (forward == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(33);
        }
        if (file instanceof PsiJavaFile && file.getName().equals("Object.class") && ((PsiJavaFile)file).getPackageName().equals("java.lang")) {
            return;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
        if (virtualFile instanceof VirtualFileWithId && forward.add(RefResolveServiceImpl.getAbsId(virtualFile)) && file instanceof PsiClassOwner) {
            for (PsiClass aClass : ((PsiClassOwner)file).getClasses()) {
                for (PsiClass superClass : aClass.getSupers()) {
                    RefResolveServiceImpl.addIdAndSuperClasses(superClass.getContainingFile(), forward);
                }
            }
        }
    }

    public int @Nullable [] getBackwardIds(@NotNull VirtualFileWithId file) {
        if (file == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(34);
        }
        if (!this.isUpToDate()) {
            return null;
        }
        int fileId = RefResolveServiceImpl.getAbsId((VirtualFile)file);
        return this.storage.get(fileId);
    }

    @NotNull
    public GlobalSearchScope restrictByBackwardIds(final @NotNull VirtualFile virtualFile, @NotNull GlobalSearchScope scope) {
        int[] backIds;
        if (virtualFile == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(35);
        }
        if (scope == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(36);
        }
        if ((backIds = RefResolveService.getInstance((Project)this.myProject).getBackwardIds((VirtualFileWithId)virtualFile)) == null) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                RefResolveServiceImpl.$$$reportNull$$$0(37);
            }
            return globalSearchScope;
        }
        String files = RefResolveServiceImpl.toVfString(backIds);
        String log = "Restricting scope of " + virtualFile.getName() + " to " + files;
        if (!log.equals(this.prevLog)) {
            this.log(log);
            this.flushLog();
            this.prevLog = log;
        }
        GlobalSearchScope restrictedByBackwardIds = new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    13.$$$reportNull$$$0(0);
                }
                if (!(file instanceof VirtualFileWithId) || file.equals(virtualFile) || ArrayUtil.indexOf((int[])backIds, (int)RefResolveServiceImpl.getAbsId(file)) != -1) {
                    return true;
                }
                return false & !RefResolveServiceImpl.this.myProjectFileIndex.isUnderSourceRootOfType(file, SOURCE_ROOTS);
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    13.$$$reportNull$$$0(1);
                }
                return true;
            }

            public boolean isSearchInLibraries() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/refResolve/RefResolveServiceImpl$13";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSearchInModuleContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        GlobalSearchScope globalSearchScope = scope.intersectWith(restrictedByBackwardIds);
        if (globalSearchScope == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(38);
        }
        return globalSearchScope;
    }

    public boolean queue(@NotNull Collection<VirtualFile> files, @NotNull Object reason) {
        if (files == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(39);
        }
        if (reason == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(40);
        }
        if (files.isEmpty()) {
            return false;
        }
        boolean queued = false;
        ArrayList<VirtualFile> added = new ArrayList<VirtualFile>(files.size());
        for (VirtualFile file : files) {
            boolean wasAdded = this.queueIfNeeded(file, this.myProject);
            if (wasAdded) {
                added.add(file);
            }
            queued |= wasAdded;
        }
        if (queued) {
            this.log("Queued to resolve (from " + reason + "): " + RefResolveServiceImpl.toVfString(added));
            this.flushLog();
        }
        return queued;
    }

    public boolean isUpToDate() {
        return ENABLED && !this.myDisposed && this.upToDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        Deque<VirtualFile> deque = this.filesToResolve;
        synchronized (deque) {
            return this.filesToResolve.size();
        }
    }

    public void addListener(@NotNull Disposable parent, final @NotNull RefResolveService.Listener listener) {
        if (parent == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(41);
        }
        if (listener == null) {
            RefResolveServiceImpl.$$$reportNull$$$0(42);
        }
        this.myListeners.add(listener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                RefResolveServiceImpl.this.myListeners.remove(listener);
            }
        });
    }

    private /* synthetic */ boolean lambda$processBatch$4(Set toProcess, int totalSize, ProgressIndicator indicator, IntObjectMap fileToForwardIds, VirtualFile file) {
        double fraction = 1.0 - (double)toProcess.size() * 1.0 / (double)totalSize;
        indicator.setFraction(fraction);
        try {
            if (!file.isDirectory() && this.toResolve(file, this.myProject)) {
                int fileId = RefResolveServiceImpl.getAbsId(file);
                int i = totalSize - toProcess.size();
                indicator.setText(PsiBundle.message((String)"0.1.resolving.2", (Object[])new Object[]{i, totalSize, file.getPresentableUrl()}));
                int[] forwardIds = this.processFile(file, fileId, indicator);
                if (forwardIds == null) {
                    return false;
                }
                fileToForwardIds.put(fileId, (Object)forwardIds);
            }
            toProcess.remove(file);
            return true;
        }
        catch (RuntimeException e) {
            indicator.checkCanceled();
            return true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 20: 
            case 30: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 20: 
            case 30: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 20: 
            case 30: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/refResolve/RefResolveServiceImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backIds";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 10: 
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 12: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 16: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 14: 
            case 15: 
            case 19: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToForwardIds";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forward";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/refResolve/RefResolveServiceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toVf";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toVfString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageDirectory";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "countAndMarkUnresolved";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "calcForwardRefs";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictByBackwardIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toVf";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 20: 
            case 30: 
            case 37: 
            case 38: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toVfString";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initListeners";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "queueIfNeeded";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toResolve";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedFileType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "queueUpdate";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processBatch";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processFilesConcurrently";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAbsId";
                break;
            }
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "countAndMarkUnresolved";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doCountAndMarkUnresolved";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "storeIds";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "calcForwardRefs";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addIdAndSuperClasses";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getBackwardIds";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "restrictByBackwardIds";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "queue";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 20: 
            case 30: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyProgress
    extends ProgressIndicatorBase
    implements Disposable {
        private MyProgress() {
        }

        public void dispose() {
        }
    }
}

