/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.chainCall;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.chainCall.ChainCallExtractor;
import com.siyeh.ig.callMatcher.CallMatcher;
import org.jetbrains.annotations.NotNull;

public class CompletionStageChainCallExtractor
implements ChainCallExtractor {
    private static final CallMatcher NEXT_CALL = CallMatcher.instanceCall("java.util.concurrent.CompletionStage", "thenApply", "thenAccept", "thenCompose").parameterCount(1);

    @Override
    public boolean canExtractChainCall(@NotNull PsiMethodCallExpression call, PsiExpression expression2, PsiType expressionType) {
        if (call == null) {
            CompletionStageChainCallExtractor.$$$reportNull$$$0(0);
        }
        if (expressionType instanceof PsiPrimitiveType) {
            return false;
        }
        if (call.getMethodExpression().getQualifierExpression() == null) {
            return false;
        }
        return NEXT_CALL.test(call);
    }

    @Override
    public String getMethodName(PsiVariable variable, PsiExpression expression2, PsiType expressionType) {
        return "thenApply";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/refactoring/chainCall/CompletionStageChainCallExtractor", "canExtractChainCall"));
    }
}

