/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterInfoImpl
implements JavaParameterInfo {
    private static final Logger LOG = Logger.getInstance(ParameterInfoImpl.class);
    public int oldParameterIndex;
    private boolean useAnySingleVariable;
    private String name = "";
    private CanonicalTypes.Type myType;
    String defaultValue = "";

    public ParameterInfoImpl(int oldParameterIndex) {
        this.oldParameterIndex = oldParameterIndex;
    }

    public ParameterInfoImpl(int oldParameterIndex, @NonNls String name2, PsiType aType) {
        this.setName(name2);
        this.oldParameterIndex = oldParameterIndex;
        this.setType(aType);
    }

    public ParameterInfoImpl(int oldParameterIndex, @NonNls String name2, PsiType aType, @NonNls String defaultValue) {
        this(oldParameterIndex, name2, aType, defaultValue, false);
    }

    public ParameterInfoImpl(int oldParameterIndex, @NonNls String name2, PsiType aType, @NonNls String defaultValue, boolean useAnyVariable) {
        this(oldParameterIndex, name2, aType);
        this.defaultValue = defaultValue;
        this.useAnySingleVariable = useAnyVariable;
    }

    public ParameterInfoImpl(int oldParameterIndex, String name2, CanonicalTypes.Type typeWrapper, String defaultValue) {
        this.setName(name2);
        this.oldParameterIndex = oldParameterIndex;
        this.myType = typeWrapper;
        this.defaultValue = defaultValue;
    }

    public int getOldIndex() {
        return this.oldParameterIndex;
    }

    public void setUseAnySingleVariable(boolean useAnySingleVariable) {
        this.useAnySingleVariable = useAnySingleVariable;
    }

    public void updateFromMethod(PsiMethod method) {
        if (this.getTypeWrapper() != null) {
            return;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        LOG.assertTrue(this.oldParameterIndex >= 0 && this.oldParameterIndex < parameters2.length);
        PsiParameter parameter2 = parameters2[this.oldParameterIndex];
        this.setName(parameter2.getName());
        this.setType(parameter2.getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterInfoImpl)) {
            return false;
        }
        ParameterInfoImpl parameterInfo = (ParameterInfoImpl)o;
        if (this.oldParameterIndex != parameterInfo.oldParameterIndex) {
            return false;
        }
        if (this.defaultValue != null ? !this.defaultValue.equals(parameterInfo.defaultValue) : parameterInfo.defaultValue != null) {
            return false;
        }
        if (!this.getName().equals(parameterInfo.getName())) {
            return false;
        }
        return this.getTypeText().equals(parameterInfo.getTypeText());
    }

    public int hashCode() {
        String name2 = this.getName();
        int result = name2 != null ? name2.hashCode() : 0;
        result = 29 * result + this.getTypeText().hashCode();
        return result;
    }

    @Override
    public String getTypeText() {
        return this.getTypeWrapper() == null ? "" : this.getTypeWrapper().getTypeText();
    }

    @Override
    public PsiType createType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
        return this.getTypeWrapper() == null ? null : this.getTypeWrapper().getType(context, manager);
    }

    @Override
    public void setType(PsiType type2) {
        this.myType = CanonicalTypes.createTypeWrapper(type2);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public CanonicalTypes.Type getTypeWrapper() {
        return this.myType;
    }

    public void setName(String name2) {
        this.name = name2 != null ? name2 : "";
    }

    @Override
    public boolean isVarargType() {
        return this.getTypeText().endsWith("...");
    }

    @Override
    @Nullable
    public PsiExpression getValue(PsiCallExpression expr2) throws IncorrectOperationException {
        if (StringUtil.isEmpty((String)this.defaultValue)) {
            return null;
        }
        PsiExpression expression2 = JavaPsiFacade.getElementFactory((Project)expr2.getProject()).createExpressionFromText(this.defaultValue, (PsiElement)expr2);
        return (PsiExpression)JavaCodeStyleManager.getInstance((Project)expr2.getProject()).shortenClassReferences((PsiElement)expression2);
    }

    public boolean isUseAnySingleVariable() {
        return this.useAnySingleVariable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public static ParameterInfoImpl @NotNull [] fromMethod(@NotNull PsiMethod method) {
        if (method == null) {
            ParameterInfoImpl.$$$reportNull$$$0(0);
        }
        ArrayList<ParameterInfoImpl> result = new ArrayList<ParameterInfoImpl>();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            result.add(ParameterInfoImpl.create(i).withName(parameter2.getName()).withType(parameter2.getType()));
        }
        ParameterInfoImpl[] parameterInfoImplArray = result.toArray(new ParameterInfoImpl[0]);
        if (parameterInfoImplArray == null) {
            ParameterInfoImpl.$$$reportNull$$$0(1);
        }
        return parameterInfoImplArray;
    }

    public static ParameterInfoImpl @NotNull [] fromMethodExceptParameter(@NotNull PsiMethod method, @NotNull PsiParameter parameterToRemove) {
        if (method == null) {
            ParameterInfoImpl.$$$reportNull$$$0(2);
        }
        if (parameterToRemove == null) {
            ParameterInfoImpl.$$$reportNull$$$0(3);
        }
        ArrayList<ParameterInfoImpl> result = new ArrayList<ParameterInfoImpl>();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            if (parameterToRemove.equals(parameter2)) continue;
            result.add(ParameterInfoImpl.create(i).withName(parameter2.getName()).withType(parameter2.getType()));
        }
        ParameterInfoImpl[] parameterInfoImplArray = result.toArray(new ParameterInfoImpl[0]);
        if (parameterInfoImplArray == null) {
            ParameterInfoImpl.$$$reportNull$$$0(4);
        }
        return parameterInfoImplArray;
    }

    @NotNull
    @Contract(value="-> new", pure=true)
    public static ParameterInfoImpl createNew() {
        return ParameterInfoImpl.create(-1);
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static ParameterInfoImpl create(int oldParameterIndex) {
        return new ParameterInfoImpl(oldParameterIndex);
    }

    @NotNull
    @Contract(value="_ -> this")
    public ParameterInfoImpl withName(@NonNls String name2) {
        this.setName(name2);
        ParameterInfoImpl parameterInfoImpl = this;
        if (parameterInfoImpl == null) {
            ParameterInfoImpl.$$$reportNull$$$0(5);
        }
        return parameterInfoImpl;
    }

    @NotNull
    @Contract(value="_ -> this")
    public ParameterInfoImpl withType(PsiType aType) {
        this.setType(aType);
        ParameterInfoImpl parameterInfoImpl = this;
        if (parameterInfoImpl == null) {
            ParameterInfoImpl.$$$reportNull$$$0(6);
        }
        return parameterInfoImpl;
    }

    @NotNull
    @Contract(value="_ -> this")
    public ParameterInfoImpl withType(CanonicalTypes.Type typeWrapper) {
        this.myType = typeWrapper;
        ParameterInfoImpl parameterInfoImpl = this;
        if (parameterInfoImpl == null) {
            ParameterInfoImpl.$$$reportNull$$$0(7);
        }
        return parameterInfoImpl;
    }

    @NotNull
    @Contract(value="_ -> this")
    public ParameterInfoImpl withDefaultValue(@NonNls String defaultValue) {
        this.defaultValue = defaultValue;
        ParameterInfoImpl parameterInfoImpl = this;
        if (parameterInfoImpl == null) {
            ParameterInfoImpl.$$$reportNull$$$0(8);
        }
        return parameterInfoImpl;
    }

    @NotNull
    @Contract(value="-> this")
    public ParameterInfoImpl useAnySingleVariable() {
        this.useAnySingleVariable = true;
        ParameterInfoImpl parameterInfoImpl = this;
        if (parameterInfoImpl == null) {
            ParameterInfoImpl.$$$reportNull$$$0(9);
        }
        return parameterInfoImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/changeSignature/ParameterInfoImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterToRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/changeSignature/ParameterInfoImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "fromMethod";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromMethodExceptParameter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withDefaultValue";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "useAnySingleVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromMethod";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromMethodExceptParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

