/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.ExtractMethodSnapshot;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethod.VariableDataSnapshot;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.ExtractedParameter;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.VariableReturnValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDuplicatesExtractMethodProcessor
extends ExtractMethodProcessor {
    private static final Logger LOG = Logger.getInstance(JavaDuplicatesExtractMethodProcessor.class);
    private static final Pass<ExtractMethodProcessor> USE_SNAPSHOT_TARGET_CLASS = new Pass<ExtractMethodProcessor>(){

        public void pass(ExtractMethodProcessor processor) {
        }
    };

    public JavaDuplicatesExtractMethodProcessor(PsiElement @NotNull [] elements, @NotNull String refactoringName) {
        if (refactoringName == null) {
            JavaDuplicatesExtractMethodProcessor.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            JavaDuplicatesExtractMethodProcessor.$$$reportNull$$$0(1);
        }
        this(elements, null, refactoringName);
    }

    public JavaDuplicatesExtractMethodProcessor(PsiElement @NotNull [] elements, @Nullable Editor editor, @Nullable String refactoringName) {
        if (elements == null) {
            JavaDuplicatesExtractMethodProcessor.$$$reportNull$$$0(2);
        }
        super(elements[0].getProject(), editor, elements, null, refactoringName, "", "refactoring.extractMethod");
    }

    public void applyFrom(@NotNull ExtractMethodProcessor from, @NotNull Map<PsiVariable, PsiVariable> variablesMapping) {
        if (from == null) {
            JavaDuplicatesExtractMethodProcessor.$$$reportNull$$$0(3);
        }
        if (variablesMapping == null) {
            JavaDuplicatesExtractMethodProcessor.$$$reportNull$$$0(4);
        }
        this.myMethodName = from.myMethodName != null ? from.myMethodName : "dummyMethodName";
        this.myStatic = from.myStatic;
        this.myIsChainedConstructor = from.myIsChainedConstructor;
        this.myMethodVisibility = from.myMethodVisibility;
        this.myNullability = from.myNullability;
        this.myReturnType = from.myReturnType;
        this.myOutputVariables = (PsiVariable[])Arrays.stream(from.myOutputVariables).map(variable -> variablesMapping.getOrDefault(variable, (PsiVariable)variable)).toArray(PsiVariable[]::new);
        this.myOutputVariable = (PsiVariable)ArrayUtil.getFirstElement((Object[])this.myOutputVariables);
        this.myArtificialOutputVariable = variablesMapping.getOrDefault(from.myArtificialOutputVariable, from.myArtificialOutputVariable);
        ArrayList<VariableData> variableDatum = new ArrayList<VariableData>();
        List<VariableData> inputVariables = this.getInputVariables().getInputVariables();
        for (int i = 0; i < from.myVariableDatum.length; ++i) {
            VariableData fromData = from.myVariableDatum[i];
            PsiVariable mappedVariable = variablesMapping.get(fromData.variable);
            if (!this.isReferenced(mappedVariable, fromData.variable) || !JavaDuplicatesExtractMethodProcessor.isUnchanged(mappedVariable, fromData.type, inputVariables)) continue;
            VariableData newData = fromData.substitute(mappedVariable);
            variableDatum.add(newData);
        }
        Set parameterVariables = ContainerUtil.map2Set(variableDatum, data -> data.variable);
        for (VariableData data2 : inputVariables) {
            if (parameterVariables.contains(data2.variable)) continue;
            variableDatum.add(data2);
        }
        this.myVariableDatum = variableDatum.toArray(new VariableData[0]);
    }

    private static boolean isUnchanged(PsiVariable fromVariable, PsiType fromType, @NotNull List<? extends VariableData> inputVariables) {
        if (inputVariables == null) {
            JavaDuplicatesExtractMethodProcessor.$$$reportNull$$$0(5);
        }
        for (VariableData variableData : inputVariables) {
            if (variableData.variable != fromVariable) continue;
            return variableData.type != null && variableData.type.equalsToText(fromType.getCanonicalText());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareFromSnapshot(@NotNull ExtractMethodSnapshot from, boolean showErrorHint) {
        if (from == null) {
            JavaDuplicatesExtractMethodProcessor.$$$reportNull$$$0(6);
        }
        this.applyFromSnapshot(from);
        PsiFile psiFile = this.myElements[0].getContainingFile();
        ExtractMethodSnapshot.SNAPSHOT_KEY.set((UserDataHolder)psiFile, (Object)from);
        try {
            if (!this.prepare(USE_SNAPSHOT_TARGET_CLASS, showErrorHint)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            ExtractMethodSnapshot.SNAPSHOT_KEY.set((UserDataHolder)psiFile, null);
        }
        this.myStatic = from.myStatic;
        this.myInputVariables.setFoldingAvailable(from.myFoldable);
        return true;
    }

    private void applyFromSnapshot(@NotNull ExtractMethodSnapshot from) {
        if (from == null) {
            JavaDuplicatesExtractMethodProcessor.$$$reportNull$$$0(7);
        }
        this.myMethodName = from.myMethodName;
        this.myStatic = from.myStatic;
        this.myIsChainedConstructor = from.myIsChainedConstructor;
        this.myMethodVisibility = from.myMethodVisibility;
        this.myNullability = from.myNullability;
        this.myReturnType = from.myReturnType != null ? from.myReturnType.getType() : null;
        this.myOutputVariables = (PsiVariable[])StreamEx.of(from.myOutputVariables).map(SmartPsiElementPointer::getElement).toArray((Object[])new PsiVariable[0]);
        LOG.assertTrue(!ArrayUtil.contains(null, (Object[])this.myOutputVariables));
        this.myOutputVariable = (PsiVariable)ArrayUtil.getFirstElement((Object[])this.myOutputVariables);
        this.myArtificialOutputVariable = from.myArtificialOutputVariable != null ? (PsiVariable)from.myArtificialOutputVariable.getElement() : null;
        this.myVariableDatum = (VariableData[])StreamEx.of(from.myVariableDatum).map(VariableDataSnapshot::getData).toArray((Object[])new VariableData[0]);
        LOG.assertTrue(!ArrayUtil.contains(null, (Object[])this.myVariableDatum));
    }

    private boolean isReferenced(@Nullable PsiVariable variable, PsiVariable fromVariable) {
        return variable == fromVariable || variable != null && ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope(this.myElements)).findFirst() != null;
    }

    public void applyDefaults(@NotNull String methodName, @PsiModifier.ModifierConstant @NotNull String visibility) {
        PsiType returnType;
        if (methodName == null) {
            JavaDuplicatesExtractMethodProcessor.$$$reportNull$$$0(8);
        }
        if (visibility == null) {
            JavaDuplicatesExtractMethodProcessor.$$$reportNull$$$0(9);
        }
        this.myMethodName = methodName;
        this.myVariableDatum = this.getInputVariables().getInputVariables().toArray(new VariableData[0]);
        this.myMethodVisibility = visibility;
        this.myArtificialOutputVariable = PsiType.VOID.equals((Object)this.myReturnType) ? this.getArtificialOutputVariable() : null;
        PsiType psiType = returnType = this.myArtificialOutputVariable != null ? this.myArtificialOutputVariable.getType() : this.myReturnType;
        if (returnType != null) {
            this.myReturnType = returnType;
        }
    }

    @Override
    public void doExtract() {
        this.chooseAnchor();
        super.doExtract();
    }

    public void updateStaticModifier(List<Match> matches) {
        if (!this.isStatic() && this.isCanBeStatic()) {
            for (Match match : matches) {
                if (this.isInSameFile(match) && this.isInSameClass(match)) continue;
                PsiUtil.setModifierProperty((PsiModifierListOwner)this.myExtractedMethod, (String)"static", (boolean)true);
                this.myStatic = true;
                break;
            }
        }
    }

    public void putExtractedParameters(Map<PsiLocalVariable, ExtractedParameter> extractedParameters) {
        for (Map.Entry<PsiLocalVariable, ExtractedParameter> entry : extractedParameters.entrySet()) {
            this.myInputVariables.foldExtractedParameter((PsiVariable)entry.getKey(), entry.getValue().myPattern.getUsage());
        }
    }

    public boolean prepare(boolean showErrorHint) {
        return this.prepare(null, showErrorHint);
    }

    private boolean prepare(@Nullable Pass<ExtractMethodProcessor> pass, boolean showErrorHint) {
        this.setShowErrorDialogs(false);
        try {
            if (this.prepare(pass)) {
                return true;
            }
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{this.myRefactoringName}));
            LOG.info(message2);
            if (showErrorHint) {
                CommonRefactoringUtil.showErrorHint((Project)this.myProject, null, (String)message2, (String)this.myRefactoringName, (String)"refactoring.extractMethod");
            }
            return false;
        }
        catch (PrepareFailedException e) {
            LOG.info((Throwable)e);
            if (showErrorHint) {
                CommonRefactoringUtil.showErrorHint((Project)this.myProject, null, (String)e.getMessage(), (String)this.myRefactoringName, (String)"refactoring.extractMethod");
            }
            return false;
        }
    }

    @Override
    public PsiElement processMatch(Match match) throws IncorrectOperationException {
        PsiMethodCallExpression callExpression;
        boolean inMultipleFiles;
        boolean bl = inMultipleFiles = !this.isInSameFile(match);
        if (inMultipleFiles) {
            this.relaxMethodVisibility(match);
        }
        boolean inMultipleClasses = !this.isInSameClass(match);
        PsiElement element = super.processMatch(match);
        if ((inMultipleFiles || inMultipleClasses) && (callExpression = this.getMatchMethodCallExpression(element)) != null) {
            return this.updateCallQualifier(callExpression);
        }
        return element;
    }

    @Override
    protected boolean isFoldingApplicable() {
        return false;
    }

    @NotNull
    private PsiElement updateCallQualifier(PsiMethodCallExpression callExpression) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        PsiClass psiClass = this.myExtractedMethod.getContainingClass();
        LOG.assertTrue(psiClass != null, (Object)"myExtractedMethod.getContainingClass");
        PsiReferenceExpression newQualifier = factory.createReferenceExpression(psiClass);
        callExpression.getMethodExpression().setQualifierExpression((PsiExpression)newQualifier);
        PsiElement psiElement = JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)callExpression);
        if (psiElement == null) {
            JavaDuplicatesExtractMethodProcessor.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    @NotNull
    public DuplicatesFinder createDuplicatesFinder() {
        VariableReturnValue returnValue = this.myOutputVariables.length == 1 ? new VariableReturnValue(this.myOutputVariables[0]) : null;
        Set<PsiVariable> effectivelyLocal = this.getEffectivelyLocalVariables();
        return new DuplicatesFinder(this.myElements, this.myInputVariables, returnValue, Collections.emptyList(), DuplicatesFinder.MatchType.PARAMETRIZED, effectivelyLocal, null);
    }

    private void relaxMethodVisibility(Match match) {
        if (this.isInSamePackage(match)) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)this.myExtractedMethod, (String)"private", (boolean)false);
        } else {
            PsiUtil.setModifierProperty((PsiModifierListOwner)this.myExtractedMethod, (String)"public", (boolean)true);
        }
    }

    private boolean isInSameFile(Match match) {
        return this.myExtractedMethod.getContainingFile() == match.getMatchStart().getContainingFile();
    }

    private boolean isInSamePackage(Match match) {
        PsiFile psiFile = this.myExtractedMethod.getContainingFile();
        PsiFile matchFile = match.getMatchStart().getContainingFile();
        return psiFile instanceof PsiJavaFile && matchFile instanceof PsiJavaFile && Objects.equals(((PsiJavaFile)psiFile).getPackageName(), ((PsiJavaFile)matchFile).getPackageName());
    }

    private boolean isInSameClass(Match match) {
        PsiClass matchClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)match.getMatchStart(), PsiClass.class);
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.myExtractedMethod, PsiClass.class);
        return matchClass != null && PsiTreeUtil.isAncestor((PsiElement)psiClass, (PsiElement)matchClass, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoringName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variablesMapping";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputVariables";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethod/JavaDuplicatesExtractMethodProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethod/JavaDuplicatesExtractMethodProcessor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "updateCallQualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFrom";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUnchanged";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepareFromSnapshot";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFromSnapshot";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyDefaults";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

