/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

class SignatureSuggesterPreviewDialog
extends DialogWrapper {
    private final PsiMethod myOldMethod;
    private final PsiMethod myNewMethod;
    private final PsiMethodCallExpression myOldCall;
    private final PsiMethodCallExpression myNewCall;
    private final int myDuplicatesNumber;

    SignatureSuggesterPreviewDialog(PsiMethod oldMethod, PsiMethod newMethod, PsiMethodCallExpression oldMethodCall, PsiMethodCallExpression newMethodCall, int duplicatesNumber) {
        super(oldMethod.getProject());
        this.myOldMethod = oldMethod;
        this.myNewMethod = newMethod;
        this.myOldCall = oldMethodCall;
        this.myNewCall = newMethodCall;
        this.myDuplicatesNumber = duplicatesNumber;
        this.setTitle(JavaRefactoringBundle.message((String)"extract.parameters.to.replace.duplicates", (Object[])new Object[0]));
        this.setOKButtonText(JavaRefactoringBundle.message((String)"accept.signature.change", (Object[])new Object[0]));
        this.setCancelButtonText(JavaRefactoringBundle.message((String)"keep.original.signature", (Object[])new Object[0]));
        this.init();
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return new JLabel(JavaRefactoringBundle.message((String)"no.exact.method.duplicates.were.found", (Object[])new Object[]{this.myDuplicatesNumber, this.myDuplicatesNumber > 1 ? "s" : ""}));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        Project project = this.myOldMethod.getProject();
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)this.myOldMethod);
        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
        DocumentContent oldContent = contentFactory.create(this.myOldMethod.getText() + "\n\n\nmethod call:\n " + this.myOldCall.getText(), file);
        DocumentContent newContent = contentFactory.create(this.myNewMethod.getText() + "\n\n\nmethod call:\n " + this.myNewCall.getText(), file);
        SimpleDiffRequest request = new SimpleDiffRequest(null, (DiffContent)oldContent, (DiffContent)newContent, "Before", "After");
        DiffRequestPanel diffPanel = DiffManager.getInstance().createRequestPanel(project, this.getDisposable(), null);
        diffPanel.putContextHints(DiffUserDataKeys.PLACE, (Object)"ExtractSignature");
        diffPanel.setRequest((DiffRequest)request);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)diffPanel.getComponent(), "Center");
        panel2.setBorder(IdeBorderFactory.createEmptyBorder((Insets)JBUI.insetsTop((int)5)));
        return panel2;
    }
}

