/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.newImpl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.extractMethod.newImpl.structures.CodeFragment;
import com.intellij.refactoring.extractMethod.newImpl.structures.PsiSubstitutionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class BodyBuilder {
    private final PsiElementFactory factory;
    private final CodeFragment fragment;
    private List<List<PsiExpression>> inputGroups = Collections.emptyList();
    private List<String> inputSubstitutions = Collections.emptyList();
    private List<PsiVariable> missedDeclarations = Collections.emptyList();
    private List<PsiStatement> specialExits = Collections.emptyList();
    private String specialSubstitution = "";
    @Nullable
    private String defaultReturnExpression = null;

    public BodyBuilder(CodeFragment fragment) {
        this.fragment = fragment;
        this.factory = PsiElementFactory.getInstance((Project)fragment.getProject());
    }

    public BodyBuilder inputGroups(List<List<PsiExpression>> inputGroups) {
        this.inputGroups = inputGroups;
        return this;
    }

    public BodyBuilder inputSubstitutions(List<String> substitutions) {
        this.inputSubstitutions = substitutions;
        return this;
    }

    public BodyBuilder specialExits(List<PsiStatement> exits, String substitution) {
        this.specialExits = exits;
        this.specialSubstitution = substitution;
        return this;
    }

    public BodyBuilder defaultReturn(String defaultReturnExpression) {
        this.defaultReturnExpression = defaultReturnExpression;
        return this;
    }

    public BodyBuilder missedDeclarations(List<PsiVariable> variables) {
        this.missedDeclarations = variables;
        return this;
    }

    public List<List<PsiExpression>> inputGroups() {
        return this.inputGroups;
    }

    public PsiCodeBlock build() {
        CodeFragment fragmentCopy = CodeFragment.copyAsCodeBlockOf(this.fragment);
        BodyBuilder onCopyBuilder = new BodyBuilder(fragmentCopy).inputGroups(CodeFragment.findSameGroupsInCopy(this.fragment, fragmentCopy, this.inputGroups)).inputSubstitutions(this.inputSubstitutions).missedDeclarations(this.missedDeclarations).specialExits(CodeFragment.findSameElementsInCopy(this.fragment, fragmentCopy, this.specialExits), this.specialSubstitution).defaultReturn(this.defaultReturnExpression);
        List<Runnable> substitutions = onCopyBuilder.createSubstitutions();
        substitutions.forEach(substitution -> substitution.run());
        return (PsiCodeBlock)fragmentCopy.getCommonParent();
    }

    private List<Runnable> createSubstitutions() {
        return BodyBuilder.flatten(this.addDefaultReturn(this.fragment, this.defaultReturnExpression), this.addMissedDeclarations(this.fragment, this.missedDeclarations), this.replaceInputGroup(this.inputGroups, this.inputSubstitutions), this.replaceSpecialExits(this.specialExits, this.specialSubstitution));
    }

    private List<Runnable> replaceInputGroup(List<List<PsiExpression>> inputGroups, List<String> names2) {
        if (inputGroups.size() != names2.size()) {
            throw new IllegalArgumentException("Number of groups and names is different");
        }
        ArrayList<Runnable> substitutions = new ArrayList<Runnable>();
        for (int i = 0; i < inputGroups.size(); ++i) {
            substitutions.addAll(this.replaceInputGroup(inputGroups.get(i), names2.get(i)));
        }
        return substitutions;
    }

    private List<Runnable> replaceInputGroup(List<PsiExpression> inputGroup, String name2) {
        return ContainerUtil.map(inputGroup, reference -> {
            PsiExpression newReference = this.factory.createExpressionFromText(name2, reference.getContext());
            return PsiSubstitutionFactory.createReplace((PsiElement)reference, (PsiElement)newReference);
        });
    }

    private List<Runnable> addMissedDeclarations(CodeFragment fragment, List<PsiVariable> missedVariables) {
        return missedVariables.stream().map(variable -> this.factory.createVariableDeclarationStatement(Objects.requireNonNull(variable.getName()), variable.getType(), null)).map(declaration2 -> PsiSubstitutionFactory.createAddBefore(fragment.getFirstElement(), (PsiElement)declaration2)).collect(Collectors.toList());
    }

    private List<Runnable> replaceSpecialExits(List<PsiStatement> specialExits, String substitution) {
        if (specialExits == null || substitution == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.map(specialExits, exit -> {
            PsiStatement returnStatement = this.factory.createStatementFromText(substitution, exit.getContext());
            return PsiSubstitutionFactory.createReplace((PsiElement)exit, (PsiElement)returnStatement);
        });
    }

    private List<Runnable> addDefaultReturn(CodeFragment fragment, @Nullable String returnExpression2) {
        if (returnExpression2 == null) {
            return Collections.emptyList();
        }
        PsiStatement returnStatement = this.factory.createStatementFromText("return " + returnExpression2 + ";", fragment.getCommonParent());
        Runnable substitution = PsiSubstitutionFactory.createAddAfter(fragment.getLastElement(), (PsiElement)returnStatement);
        return Collections.singletonList(substitution);
    }

    private static List<Runnable> flatten(List<Runnable> ... substitutions) {
        return ContainerUtil.flatten((Collection[])substitutions);
    }
}

