/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.newImpl;

import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.refactoring.extractMethod.newImpl.structures.CodeFragment;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ControlFlowOnFragment {
    private final CodeFragment fragment;
    private final ControlFlow flow;
    private final int flowStart;
    private final int flowEnd;

    private ControlFlowOnFragment(CodeFragment fragment, ControlFlow flow, int flowStart, int flowEnd) {
        this.fragment = fragment;
        this.flow = flow;
        this.flowStart = flowStart;
        this.flowEnd = flowEnd;
    }

    private static ControlFlow createControlFlow(CodeFragment fragment) throws AnalysisCanceledException {
        PsiElement fragmentToAnalyze = ControlFlowUtil.findCodeFragment(fragment.getFirstElement());
        LocalsControlFlowPolicy flowPolicy = new LocalsControlFlowPolicy(fragmentToAnalyze);
        ControlFlowFactory factory = ControlFlowFactory.getInstance(fragment.getProject());
        return factory.getControlFlow(fragmentToAnalyze, flowPolicy, false, false);
    }

    private static int findStartInFlow(ControlFlow flow, CodeFragment fragment) {
        return flow.getStartOffset(fragment.getFirstElement());
    }

    private static int findEndInFlow(ControlFlow flow, CodeFragment fragment) {
        return flow.getEndOffset(fragment.getLastElement());
    }

    public static ControlFlowOnFragment create(CodeFragment fragment) {
        try {
            ControlFlow flow = ControlFlowOnFragment.createControlFlow(fragment);
            int flowStart = ControlFlowOnFragment.findStartInFlow(flow, fragment);
            int flowEnd = ControlFlowOnFragment.findEndInFlow(flow, fragment);
            return new ControlFlowOnFragment(fragment, flow, flowStart, flowEnd);
        }
        catch (AnalysisCanceledException e) {
            throw new IllegalArgumentException("Code fragment may have syntax error");
        }
    }

    public List<PsiVariable> findInputVariables() {
        return ControlFlowUtil.getInputVariables(this.flow, this.flowStart, this.flowEnd);
    }

    public List<PsiVariable> findOutputVariables() {
        IntArrayList exitPoints = new IntArrayList();
        ControlFlowUtil.findExitPointsAndStatements(this.flow, this.flowStart, this.flowEnd, exitPoints, ControlFlowUtil.DEFAULT_EXIT_STATEMENTS_CLASSES);
        Object[] outputVariables = ControlFlowUtil.getOutputVariables(this.flow, this.flowStart, this.flowEnd, exitPoints.toArray());
        Set distinctVariables = ContainerUtil.set((Object[])outputVariables);
        return new ArrayList<PsiVariable>(distinctVariables);
    }

    public boolean canCompleteNormally() {
        return ControlFlowUtil.canCompleteNormally(this.flow, this.flowStart, this.flowEnd);
    }

    public List<PsiStatement> findExitStatements() {
        IntArrayList exitPoints = new IntArrayList();
        Collection<PsiStatement> statements = ControlFlowUtil.findExitPointsAndStatements(this.flow, this.flowStart, this.flowEnd, exitPoints, ControlFlowUtil.DEFAULT_EXIT_STATEMENTS_CLASSES);
        return ContainerUtil.filter(statements, statement -> !this.isExitInside((PsiStatement)statement));
    }

    public boolean hasSingleExit() {
        IntArrayList exitPoints = new IntArrayList();
        Collection<PsiStatement> statements = ControlFlowUtil.findExitPointsAndStatements(this.flow, this.flowStart, this.flowEnd, exitPoints, ControlFlowUtil.DEFAULT_EXIT_STATEMENTS_CLASSES);
        return exitPoints.size() == 1;
    }

    public List<PsiVariable> findWrittenVariables() {
        return new ArrayList<PsiVariable>(ControlFlowUtil.getWrittenVariables(this.flow, this.flowStart, this.flowEnd, false));
    }

    private boolean isExitInside(PsiStatement statement) {
        if (statement instanceof PsiBreakStatement) {
            return this.contains(((PsiBreakStatement)statement).findExitedStatement());
        }
        if (statement instanceof PsiContinueStatement) {
            return this.contains(((PsiContinueStatement)statement).findContinuedStatement());
        }
        if (statement instanceof PsiReturnStatement) {
            return false;
        }
        throw new IllegalArgumentException();
    }

    private boolean contains(@Nullable PsiStatement statement) {
        if (statement == null) {
            return false;
        }
        int startOffset = this.flow.getStartOffset((PsiElement)statement);
        int endOffset = this.flow.getEndOffset((PsiElement)statement);
        return this.flowStart <= startOffset && endOffset <= this.flowEnd;
    }
}

