/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.newImpl.structures;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;

public class CodeFragment {
    public final List<PsiElement> elements;

    private CodeFragment(List<PsiElement> elements) {
        this.elements = elements;
    }

    public static CodeFragment of(List<PsiElement> elements) {
        CodeFragment.checkRange(elements);
        return new CodeFragment(elements);
    }

    public PsiElement getFirstElement() {
        return this.elements.get(0);
    }

    public PsiElement getLastElement() {
        return this.elements.get(this.elements.size() - 1);
    }

    public PsiElement getCommonParent() {
        return this.getFirstElement().getParent();
    }

    public Project getProject() {
        return this.getFirstElement().getProject();
    }

    public PsiFile getContainingFile() {
        return this.getFirstElement().getContainingFile();
    }

    public TextRange getTextRange() {
        return new TextRange(this.getFirstElement().getTextRange().getStartOffset(), this.getLastElement().getTextRange().getEndOffset());
    }

    private static void checkRange(List<PsiElement> elements) {
        if (elements.isEmpty()) {
            throw new IllegalArgumentException();
        }
        PsiElement parent = elements.get(0).getParent();
        boolean areNotSiblings = elements.stream().anyMatch(element -> element.getParent() != parent);
        if (parent == null || areNotSiblings) {
            throw new IllegalArgumentException();
        }
    }

    public static CodeFragment copyAsCodeBlockOf(CodeFragment codeFragment) {
        PsiElement parent = codeFragment.getCommonParent();
        if (!(parent instanceof PsiCodeBlock)) {
            throw new IllegalArgumentException("Code fragment is not inside of code block");
        }
        PsiCodeBlock block = PsiElementFactory.getInstance((Project)codeFragment.getProject()).createCodeBlock();
        block.addRange(codeFragment.getFirstElement(), codeFragment.getLastElement());
        return CodeFragment.of(Arrays.asList(block.getStatements()));
    }

    public static <T extends PsiElement> T findSameElementInCopy(CodeFragment source, CodeFragment copy, T element) {
        int sourceStartOffset = source.getTextRange().getStartOffset();
        int copyStartOffset = copy.getTextRange().getStartOffset();
        TextRange range = element.getTextRange().shiftRight(copyStartOffset - sourceStartOffset);
        return (T)CodeInsightUtilCore.findElementInRange((PsiFile)copy.getContainingFile(), (int)range.getStartOffset(), (int)range.getEndOffset(), element.getClass(), (Language)JavaLanguage.INSTANCE);
    }

    public static <T extends PsiElement> List<T> findSameElementsInCopy(CodeFragment source, CodeFragment copy, List<T> elements) {
        return ContainerUtil.map(elements, element -> CodeFragment.findSameElementInCopy(source, copy, element));
    }

    public static <T extends PsiElement> List<List<T>> findSameGroupsInCopy(CodeFragment source, CodeFragment copy, List<List<T>> groups) {
        return ContainerUtil.map(groups, group -> CodeFragment.findSameElementsInCopy(source, copy, group));
    }
}

