/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.newImpl.structures;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import java.util.List;

public class ExpressionGroup {
    public final PsiType type;
    public final List<PsiExpression> references;

    private ExpressionGroup(PsiType type2, List<PsiExpression> expressions2) {
        this.type = type2;
        this.references = expressions2;
    }

    public static ExpressionGroup of(List<PsiExpression> expressions2) {
        if (expressions2.isEmpty()) {
            throw new IllegalArgumentException("Expression group is empty");
        }
        PsiType type2 = expressions2.get(0).getType();
        if (type2 == null) {
            throw new IllegalArgumentException("Some expressions have null psi type");
        }
        if (!expressions2.stream().allMatch(it -> type2.equals(it.getType()))) {
            throw new IllegalArgumentException("Some expressions have different type");
        }
        return new ExpressionGroup(type2, expressions2);
    }
}

