/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.extractMethod.preview.ElementsRange;
import com.intellij.refactoring.extractMethod.preview.ExtractableFragment;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.intellij.usages.ChunkExtractor;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageInfo2UsageAdapter;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FragmentNode
extends DefaultMutableTreeNode
implements Comparable<FragmentNode> {
    private final TextChunk[] myTextChunks;
    private final TextChunk myLineNumberChunk;
    private final int myOffset;
    private final ExtractableFragment myFragment;
    private boolean myValid;

    protected FragmentNode(@NotNull PsiElement start, @NotNull PsiElement end, @NotNull ExtractableFragment fragment) {
        if (start == null) {
            FragmentNode.$$$reportNull$$$0(0);
        }
        if (end == null) {
            FragmentNode.$$$reportNull$$$0(1);
        }
        if (fragment == null) {
            FragmentNode.$$$reportNull$$$0(2);
        }
        this.myValid = true;
        this.myTextChunks = this.createTextChunks(start);
        this.myLineNumberChunk = FragmentNode.createNumberChunk(start, end);
        this.myOffset = start.getTextRange().getStartOffset();
        this.myFragment = fragment;
        this.setAllowsChildren(false);
    }

    public TextChunk[] getTextChunks() {
        return this.myTextChunks;
    }

    public TextChunk getLineNumberChunk() {
        return this.myLineNumberChunk;
    }

    protected TextChunk @NotNull [] createTextChunks(@NotNull PsiElement element) {
        if (element == null) {
            FragmentNode.$$$reportNull$$$0(3);
        }
        UsageInfo2UsageAdapter usageAdapter = new UsageInfo2UsageAdapter(new UsageInfo(element));
        PsiFile file = element.getContainingFile();
        TextRange range = element.getTextRange();
        TextChunk[] textChunkArray = ChunkExtractor.getExtractor((PsiFile)file).createTextChunks(usageAdapter, (CharSequence)file.getText(), range.getStartOffset(), range.getEndOffset(), false, new ArrayList());
        if (textChunkArray == null) {
            FragmentNode.$$$reportNull$$$0(4);
        }
        return textChunkArray;
    }

    private static TextChunk createNumberChunk(@NotNull PsiElement start, @NotNull PsiElement end) {
        Document document;
        if (start == null) {
            FragmentNode.$$$reportNull$$$0(5);
        }
        if (end == null) {
            FragmentNode.$$$reportNull$$$0(6);
        }
        if ((document = PsiDocumentManager.getInstance((Project)start.getProject()).getDocument(start.getContainingFile())) != null) {
            int endLine;
            int startLine = FragmentNode.getLineNumber(document, start.getTextRange().getStartOffset()) + 1;
            String lineText = startLine == (endLine = FragmentNode.getLineNumber(document, end.getTextRange().getEndOffset()) + 1) ? Integer.toString(startLine) : startLine + ".." + endLine;
            EditorColorsScheme colorsScheme = UsageTreeColorsScheme.getInstance().getScheme();
            return new TextChunk(colorsScheme.getAttributes(UsageTreeColors.USAGE_LOCATION), lineText + "  ");
        }
        return null;
    }

    @Nullable
    public Navigatable getNavigatable() {
        return this.myFragment.getNavigatable();
    }

    public boolean isExcluded() {
        return false;
    }

    public synchronized boolean isValid() {
        return this.myValid;
    }

    public synchronized void setValid(boolean valid) {
        this.myValid = valid;
    }

    @Nullable
    public TextRange getTextRange() {
        return this.myFragment.getTextRange();
    }

    @Nullable
    public ElementsRange getElementsRange() {
        return this.myFragment.getElementsRange();
    }

    private static int getLineNumber(@NotNull Document document, int offset) {
        if (document == null) {
            FragmentNode.$$$reportNull$$$0(7);
        }
        if (document.getTextLength() == 0) {
            return 0;
        }
        if (offset >= document.getTextLength()) {
            return document.getLineCount();
        }
        return document.getLineNumber(offset);
    }

    @Override
    public int compareTo(@NotNull FragmentNode o) {
        if (o == null) {
            FragmentNode.$$$reportNull$$$0(8);
        }
        return this.myOffset - o.myOffset;
    }

    @Override
    public String toString() {
        if (this.myTextChunks == null) {
            return "";
        }
        String lineNumber = this.myLineNumberChunk != null ? this.myLineNumberChunk.getText().trim() + ":" : "";
        return Stream.of(this.myTextChunks).map(TextChunk::getText).collect(Collectors.joining("", lineNumber, ""));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethod/preview/FragmentNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethod/preview/FragmentNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextChunks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTextChunks";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNumberChunk";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLineNumber";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

